/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRExpression;

public class JRDataUtils {
    public static final String STANDARD_DATE_FORMAT_DEFAULT = "default";
    public static final String STANDARD_DATE_FORMAT_SHORT = "short";
    public static final String STANDARD_DATE_FORMAT_MEDIUM = "medium";
    public static final String STANDARD_DATE_FORMAT_LONG = "long";
    public static final String STANDARD_DATE_FORMAT_FULL = "full";
    public static final String STANDARD_DATE_FORMAT_HIDE = "hide";
    public static final String STANDARD_DATE_FORMAT_SEPARATOR = ",";
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Number;

    public static DateFormat getDateFormat(String pattern, Locale locale, TimeZone tz) {
        DateFormat format;
        int sepIdx;
        String dateTok;
        int[] dateStyle = null;
        int[] timeStyle = null;
        if (pattern != null && pattern.trim().length() > 0 && (dateStyle = JRDataUtils.getDateStyle(dateTok = (sepIdx = pattern.indexOf(STANDARD_DATE_FORMAT_SEPARATOR)) < 0 ? pattern : pattern.substring(0, sepIdx))) != null) {
            if (sepIdx >= 0) {
                String timeTok = pattern.substring(sepIdx + STANDARD_DATE_FORMAT_SEPARATOR.length());
                timeStyle = JRDataUtils.getDateStyle(timeTok);
            } else {
                timeStyle = dateStyle;
            }
        }
        if (dateStyle != null && timeStyle != null) {
            format = JRDataUtils.getDateFormat(dateStyle, timeStyle, locale);
        } else {
            format = locale == null ? DateFormat.getDateTimeInstance(3, 3) : DateFormat.getDateTimeInstance(3, 3, locale);
            if (pattern != null && pattern.trim().length() > 0 && format instanceof SimpleDateFormat) {
                ((SimpleDateFormat)format).applyPattern(pattern);
            }
        }
        format.setTimeZone(tz);
        return format;
    }

    protected static int[] getDateStyle(String pattern) {
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_DEFAULT)) {
            return new int[]{2};
        }
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_SHORT)) {
            return new int[]{3};
        }
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_MEDIUM)) {
            return new int[]{2};
        }
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_LONG)) {
            return new int[]{1};
        }
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_FULL)) {
            return new int[]{0};
        }
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_HIDE)) {
            return new int[0];
        }
        return null;
    }

    protected static DateFormat getDateFormat(int[] dateStyle, int[] timeStyle, Locale locale) {
        if (dateStyle.length == 0) {
            if (timeStyle.length == 0) {
                return new SimpleDateFormat("");
            }
            return locale == null ? DateFormat.getTimeInstance(timeStyle[0]) : DateFormat.getTimeInstance(timeStyle[0], locale);
        }
        if (timeStyle.length == 0) {
            return locale == null ? DateFormat.getDateInstance(dateStyle[0]) : DateFormat.getDateInstance(dateStyle[0], locale);
        }
        return locale == null ? DateFormat.getDateTimeInstance(dateStyle[0], timeStyle[0]) : DateFormat.getDateTimeInstance(dateStyle[0], timeStyle[0], locale);
    }

    public static NumberFormat getNumberFormat(String pattern, Locale locale) {
        NumberFormat format = null;
        if (pattern != null && pattern.trim().length() > 0 && (format = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale)) instanceof DecimalFormat) {
            ((DecimalFormat)format).applyPattern(pattern);
        }
        return format;
    }

    public static Format getFormat(JRExpression valueExpression, String pattern, Locale locale, TimeZone timezone) {
        Format format = null;
        if (valueExpression != null) {
            Class valueClass;
            if ((class$java$util$Date == null ? (class$java$util$Date = JRDataUtils.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(valueClass = valueExpression.getValueClass())) {
                format = JRDataUtils.getDateFormat(pattern, locale, timezone);
            } else if ((class$java$lang$Number == null ? (class$java$lang$Number = JRDataUtils.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(valueClass)) {
                format = JRDataUtils.getNumberFormat(pattern, locale);
            }
        }
        return format;
    }

    public static boolean useFormat(JRExpression valueExpression) {
        boolean format = false;
        if (valueExpression != null) {
            Class valueClass;
            format = (class$java$util$Date == null ? (class$java$util$Date = JRDataUtils.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(valueClass = valueExpression.getValueClass()) || (class$java$lang$Number == null ? (class$java$lang$Number = JRDataUtils.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(valueClass);
        }
        return format;
    }

    public static String getPattern(JRExpression valueExpression, Format format, String originalPattern) {
        String pattern = null;
        if (format != null && valueExpression != null) {
            Class valueClass;
            if ((class$java$util$Date == null ? (class$java$util$Date = JRDataUtils.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(valueClass = valueExpression.getValueClass())) {
                if (format instanceof SimpleDateFormat) {
                    pattern = ((SimpleDateFormat)format).toPattern();
                }
            } else if ((class$java$lang$Number == null ? (class$java$lang$Number = JRDataUtils.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(valueClass) && format instanceof DecimalFormat) {
                pattern = ((DecimalFormat)format).toPattern();
            }
        }
        if (pattern == null) {
            pattern = originalPattern;
        }
        return pattern;
    }

    public static String getLocaleCode(Locale locale) {
        return locale.toString();
    }

    public static Locale getLocale(String code) {
        String country;
        String variant;
        String language;
        int firstSep = code.indexOf(95);
        if (firstSep < 0) {
            language = code;
            variant = "";
            country = "";
        } else {
            language = code.substring(0, firstSep);
            int secondSep = code.indexOf(95, firstSep + 1);
            if (secondSep < 0) {
                country = code.substring(firstSep + 1);
                variant = "";
            } else {
                country = code.substring(firstSep + 1, secondSep);
                variant = code.substring(secondSep + 1);
            }
        }
        return new Locale(language, country, variant);
    }

    public static String getTimeZoneId(TimeZone tz) {
        return tz.getID();
    }

    public static TimeZone getTimeZone(String id) {
        return TimeZone.getTimeZone(id);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

