/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRBaseChart
extends JRBaseElement
implements JRChart {
    private static final long serialVersionUID = 10200L;
    protected byte chartType = 0;
    protected boolean isShowLegend = false;
    protected byte evaluationTime = 1;
    protected byte hyperlinkType = 0;
    protected String linkType;
    protected byte hyperlinkTarget = 1;
    private JRHyperlinkParameter[] hyperlinkParameters;
    protected byte titlePosition = 1;
    protected Color titleColor = Color.black;
    protected Color subtitleColor = Color.black;
    protected JRBox box = null;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected String customizerClass;
    protected JRGroup evaluationGroup = null;
    protected JRExpression titleExpression = null;
    protected JRExpression subtitleExpression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    protected JRChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected Byte border;
    protected Byte topBorder = null;
    protected Byte leftBorder = null;
    protected Byte bottomBorder = null;
    protected Byte rightBorder = null;
    protected Color borderColor = null;
    protected Color topBorderColor = null;
    protected Color leftBorderColor = null;
    protected Color bottomBorderColor = null;
    protected Color rightBorderColor = null;
    protected Integer padding;
    protected Integer topPadding = null;
    protected Integer leftPadding = null;
    protected Integer bottomPadding = null;
    protected Integer rightPadding = null;
    protected int bookmarkLevel = 0;

    protected JRBaseChart(JRChart chart, JRBaseObjectFactory factory) {
        super(chart, factory);
        this.chartType = chart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 3: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 2: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 4: {
                this.dataset = factory.getXyzDataset((JRXyzDataset)chart.getDataset());
                this.plot = factory.getBubblePlot((JRBubblePlot)chart.getPlot());
                break;
            }
            case 5: {
                this.dataset = factory.getHighLowDataset((JRHighLowDataset)chart.getDataset());
                this.plot = factory.getCandlestickPlot((JRCandlestickPlot)chart.getPlot());
                break;
            }
            case 6: {
                this.dataset = factory.getHighLowDataset((JRHighLowDataset)chart.getDataset());
                this.plot = factory.getHighLowPlot((JRHighLowPlot)chart.getPlot());
                break;
            }
            case 7: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case 9: {
                this.dataset = factory.getPieDataset((JRPieDataset)chart.getDataset());
                this.plot = factory.getPiePlot((JRPiePlot)chart.getPlot());
                break;
            }
            case 8: {
                this.dataset = factory.getPieDataset((JRPieDataset)chart.getDataset());
                this.plot = factory.getPie3DPlot((JRPie3DPlot)chart.getPlot());
                break;
            }
            case 10: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getScatterPlot((JRScatterPlot)chart.getPlot());
                break;
            }
            case 12: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 11: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 16: {
                this.dataset = factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
                this.plot = factory.getTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
                break;
            }
            case 13: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 14: {
                switch (chart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
                        break;
                    }
                    case 5: {
                        this.dataset = factory.getTimePeriodDataset((JRTimePeriodDataset)chart.getDataset());
                        break;
                    }
                    case 3: {
                        this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                    }
                }
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 15: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        this.isShowLegend = chart.isShowLegend();
        this.evaluationTime = chart.getEvaluationTime();
        this.linkType = chart.getLinkType();
        this.hyperlinkTarget = chart.getHyperlinkTarget();
        this.titlePosition = chart.getTitlePosition();
        this.titleColor = chart.getTitleColor();
        this.subtitleColor = chart.getSubtitleColor();
        this.titleFont = factory.getFont(chart.getTitleFont());
        this.subtitleFont = factory.getFont(chart.getSubtitleFont());
        this.evaluationGroup = factory.getGroup(chart.getEvaluationGroup());
        this.titleExpression = factory.getExpression(chart.getTitleExpression());
        this.subtitleExpression = factory.getExpression(chart.getSubtitleExpression());
        this.anchorNameExpression = factory.getExpression(chart.getAnchorNameExpression());
        this.hyperlinkReferenceExpression = factory.getExpression(chart.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(chart.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(chart.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(chart.getHyperlinkTooltipExpression());
        this.bookmarkLevel = chart.getBookmarkLevel();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(chart, factory);
        this.customizerClass = chart.getCustomizerClass();
        this.border = chart.getOwnBorder();
        this.topBorder = chart.getOwnTopBorder();
        this.leftBorder = chart.getOwnLeftBorder();
        this.bottomBorder = chart.getOwnBottomBorder();
        this.rightBorder = chart.getOwnRightBorder();
        this.borderColor = chart.getOwnBorderColor();
        this.topBorderColor = chart.getOwnTopBorderColor();
        this.leftBorderColor = chart.getOwnLeftBorderColor();
        this.bottomBorderColor = chart.getOwnBottomBorderColor();
        this.rightBorderColor = chart.getOwnRightBorderColor();
        this.padding = chart.getOwnPadding();
        this.topPadding = chart.getOwnTopPadding();
        this.leftPadding = chart.getOwnLeftPadding();
        this.bottomPadding = chart.getOwnBottomPadding();
        this.rightPadding = chart.getOwnRightPadding();
    }

    public boolean isShowLegend() {
        return this.isShowLegend;
    }

    public void setShowLegend(boolean isShowLegend) {
        this.isShowLegend = isShowLegend;
    }

    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRBox getBox() {
        return this;
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public byte getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(byte titlePosition) {
        this.titlePosition = titlePosition;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public Color getSubtitleColor() {
        return this.subtitleColor;
    }

    public void setSubtitleColor(Color subtitleColor) {
        this.subtitleColor = subtitleColor;
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    public byte getChartType() {
        return this.chartType;
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getChart(this);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void writeXml(JRXmlWriter xmlWriter) throws IOException {
        xmlWriter.writeChartTag(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    public Byte getOwnBorder() {
        return this.border;
    }

    public void setBorder(byte border) {
        this.border = new Byte(border);
    }

    public void setBorder(Byte border) {
        this.border = border;
    }

    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    public Color getOwnBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    public Integer getOwnPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = new Integer(padding);
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }

    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    public Byte getOwnTopBorder() {
        return this.topBorder;
    }

    public void setTopBorder(byte topBorder) {
        this.topBorder = new Byte(topBorder);
    }

    public void setTopBorder(Byte topBorder) {
        this.topBorder = topBorder;
    }

    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    public Color getOwnTopBorderColor() {
        return this.topBorderColor;
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.topBorderColor = topBorderColor;
    }

    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    public Integer getOwnTopPadding() {
        return this.topPadding;
    }

    public void setTopPadding(int topPadding) {
        this.topPadding = new Integer(topPadding);
    }

    public void setTopPadding(Integer topPadding) {
        this.topPadding = topPadding;
    }

    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    public Byte getOwnLeftBorder() {
        return this.leftBorder;
    }

    public void setLeftBorder(byte leftBorder) {
        this.leftBorder = new Byte(leftBorder);
    }

    public void setLeftBorder(Byte leftBorder) {
        this.leftBorder = leftBorder;
    }

    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    public Color getOwnLeftBorderColor() {
        return this.leftBorderColor;
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.leftBorderColor = leftBorderColor;
    }

    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    public Integer getOwnLeftPadding() {
        return this.leftPadding;
    }

    public void setLeftPadding(int leftPadding) {
        this.leftPadding = new Integer(leftPadding);
    }

    public void setLeftPadding(Integer leftPadding) {
        this.leftPadding = leftPadding;
    }

    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    public Byte getOwnBottomBorder() {
        return this.bottomBorder;
    }

    public void setBottomBorder(byte bottomBorder) {
        this.bottomBorder = new Byte(bottomBorder);
    }

    public void setBottomBorder(Byte bottomBorder) {
        this.bottomBorder = bottomBorder;
    }

    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    public Color getOwnBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.bottomBorderColor = bottomBorderColor;
    }

    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    public Integer getOwnBottomPadding() {
        return this.bottomPadding;
    }

    public void setBottomPadding(int bottomPadding) {
        this.bottomPadding = new Integer(bottomPadding);
    }

    public void setBottomPadding(Integer bottomPadding) {
        this.bottomPadding = bottomPadding;
    }

    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    public Byte getOwnRightBorder() {
        return this.rightBorder;
    }

    public void setRightBorder(byte rightBorder) {
        this.rightBorder = new Byte(rightBorder);
    }

    public void setRightBorder(Byte rightBorder) {
        this.rightBorder = rightBorder;
    }

    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    public Color getOwnRightBorderColor() {
        return this.rightBorderColor;
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.rightBorderColor = rightBorderColor;
    }

    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    public Integer getOwnRightPadding() {
        return this.rightPadding;
    }

    public void setRightPadding(int rightPadding) {
        this.rightPadding = new Integer(rightPadding);
    }

    public void setRightPadding(Integer rightPadding) {
        this.rightPadding = rightPadding;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.normalizeLinkType();
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }
}

