/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import java.awt.Color;

public class ColorRoutines {
    private static final int RGB = 1;
    private static final int RBG = 2;
    private static final int GBR = 3;
    private static final int GRB = 4;
    private static final int BRG = 5;
    private static final int BGR = 6;
    private boolean preserveGrey;
    private int chue;
    private int csat;
    private int cbri;
    private int fr;
    private int fg;
    private int fb;
    int hi;
    int lo;
    int md;
    boolean hiIsR;
    boolean hiIsG;
    boolean hiIsB;
    boolean mdIsR;
    boolean mdIsG;
    boolean mdIsB;
    boolean loIsR;
    boolean loIsG;
    boolean loIsB;

    public ColorRoutines(Color c) {
        this.setHSB(c.getRed(), c.getGreen(), c.getBlue());
    }

    public ColorRoutines(int hue, int sat, int bri, boolean preserveGrey) {
        this.chue = hue;
        this.csat = sat;
        this.cbri = bri;
        this.preserveGrey = preserveGrey;
        Color c = Color.getHSBColor((float)((double)this.chue / 360.0), 1.0f, 1.0f);
        this.fr = c.getRed();
        this.fg = c.getGreen();
        this.fb = c.getBlue();
        if (this.fr >= this.fg && this.fg >= this.fb) {
            this.hi = this.fr;
            this.md = this.fg;
            this.lo = this.fb;
            this.hiIsR = true;
            this.mdIsG = true;
            this.loIsB = true;
        } else if (this.fr >= this.fb && this.fb >= this.fg) {
            this.hi = this.fr;
            this.md = this.fb;
            this.lo = this.fg;
            this.hiIsR = true;
            this.mdIsB = true;
            this.loIsG = true;
        } else if (this.fg >= this.fr && this.fr >= this.fb) {
            this.hi = this.fg;
            this.md = this.fr;
            this.lo = this.fb;
            this.hiIsG = true;
            this.mdIsR = true;
            this.loIsB = true;
        } else if (this.fg >= this.fb && this.fb >= this.fr) {
            this.hi = this.fg;
            this.md = this.fb;
            this.lo = this.fr;
            this.hiIsG = true;
            this.mdIsB = true;
            this.loIsR = true;
        } else if (this.fb >= this.fg && this.fg >= this.fr) {
            this.hi = this.fb;
            this.md = this.fg;
            this.lo = this.fr;
            this.hiIsB = true;
            this.mdIsG = true;
            this.loIsR = true;
        } else if (this.fb >= this.fr && this.fr >= this.fg) {
            this.hi = this.fb;
            this.md = this.fr;
            this.lo = this.fg;
            this.hiIsB = true;
            this.mdIsR = true;
            this.loIsG = true;
        }
    }

    private void setHSB(int r, int g, int b) {
        this.chue = ColorRoutines.getHue(r, g, b);
        this.csat = ColorRoutines.getSaturation(r, g, b);
        this.cbri = ColorRoutines.getBrightness(r, g, b);
    }

    public static Color getAverage(Color c1, Color c2) {
        int r = (int)Math.round((double)(c1.getRed() + c2.getRed()) / 2.0);
        int g = (int)Math.round((double)(c1.getGreen() + c2.getGreen()) / 2.0);
        int b = (int)Math.round((double)(c1.getBlue() + c2.getBlue()) / 2.0);
        return new Color(r, g, b);
    }

    public static Color getGradient(Color c1, Color c2, int d, int i) {
        if (i == 0) {
            return c1;
        }
        if (i == d) {
            return c2;
        }
        double d2 = (double)i * 1.1 / (double)d;
        double d1 = 1.0 - d2;
        int r = (int)Math.round((double)c1.getRed() * d1 + (double)c2.getRed() * d2);
        int g = (int)Math.round((double)c1.getGreen() * d1 + (double)c2.getGreen() * d2);
        int b = (int)Math.round((double)c1.getBlue() * d1 + (double)c2.getBlue() * d2);
        return new Color(r, g, b);
    }

    public static Color getMaxSaturation(Color c, int memH) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        if (r == g && r == b) {
            return c;
        }
        int ta = 0;
        int tb = 0;
        int tc = 0;
        int mapping = 1;
        if (r >= g && r >= b) {
            tc = r;
            if (g == b) {
                ta = g;
                tb = b;
                mapping = 1;
            } else if (g > b) {
                ta = g;
                tb = b;
                mapping = 1;
            } else {
                tb = g;
                ta = b;
                mapping = 2;
            }
        } else if (g >= r && g >= b) {
            tc = g;
            if (r == b) {
                ta = r;
                tb = b;
                mapping = 4;
            } else if (r > b) {
                ta = r;
                tb = b;
                mapping = 4;
            } else {
                tb = r;
                ta = b;
                mapping = 3;
            }
        } else if (b >= r && b >= g) {
            tc = b;
            if (r == g) {
                ta = r;
                tb = g;
                mapping = 5;
            } else if (r > g) {
                ta = r;
                tb = g;
                mapping = 5;
            } else {
                tb = r;
                ta = g;
                mapping = 6;
            }
        }
        if (tb == 0) {
            return c;
        }
        int nc = Math.min(255, tc + tb);
        int nb = Math.max(0, tc + tb - 255);
        int na = ta;
        int h = 0;
        int mh = 0;
        int ba = 0;
        int delta = 360;
        Color rc = null;
        switch (mapping) {
            case 1: {
                mh = h = ColorRoutines.getHue(nc, na, nb);
                while (h != memH && na < 256) {
                    h = ColorRoutines.getHue(nc, ++na, nb);
                    if (na == 256) break;
                    if (h == memH) {
                        return new Color(nc, na, nb);
                    }
                    if (mh < memH && h > memH || mh > memH && h < memH) {
                        return new Color(nc, na, nb);
                    }
                    if (Math.abs(h - memH) < delta) {
                        delta = Math.abs(h - memH);
                        ba = na;
                    }
                    mh = h;
                }
                if (h != memH) {
                    mh = h = ColorRoutines.getHue(nc, na, nb);
                    na = ta;
                    while (h != memH && na >= 0) {
                        h = ColorRoutines.getHue(nc, --na, nb);
                        if (na == -1) break;
                        if (h == memH) {
                            return new Color(nc, na, nb);
                        }
                        if (mh < memH && h > memH || mh > memH && h < memH) {
                            return new Color(nc, na, nb);
                        }
                        if (Math.abs(h - memH) < delta) {
                            delta = Math.abs(h - memH);
                            ba = na;
                        }
                        mh = h;
                    }
                }
                if (na == 256 | na == -1) {
                    na = ba;
                }
                rc = new Color(nc, na, nb);
                break;
            }
            case 2: {
                mh = h = ColorRoutines.getHue(nc, nb, na);
                while (h != memH && na < 256) {
                    h = ColorRoutines.getHue(nc, nb, ++na);
                    if (na == 256) break;
                    if (h == memH) {
                        return new Color(nc, nb, na);
                    }
                    if (mh < memH && h > memH || mh > memH && h < memH) {
                        return new Color(nc, nb, na);
                    }
                    if (Math.abs(h - memH) < delta) {
                        delta = Math.abs(h - memH);
                        ba = na;
                    }
                    mh = h;
                }
                if (h != memH) {
                    mh = h = ColorRoutines.getHue(nc, na, nb);
                    na = ta;
                    while (h != memH && na >= 0) {
                        h = ColorRoutines.getHue(nc, nb, --na);
                        if (na == -1) break;
                        if (h == memH) {
                            return new Color(nc, nb, na);
                        }
                        if (mh < memH && h > memH || mh > memH && h < memH) {
                            return new Color(nc, nb, na);
                        }
                        if (Math.abs(h - memH) < delta) {
                            delta = Math.abs(h - memH);
                            ba = na;
                        }
                        mh = h;
                    }
                }
                if (na == 256 | na == -1) {
                    na = ba;
                }
                rc = new Color(nc, nb, na);
                break;
            }
            case 3: {
                mh = h = ColorRoutines.getHue(nb, nc, na);
                while (h != memH && na < 256) {
                    h = ColorRoutines.getHue(nb, nc, ++na);
                    if (na == 256) break;
                    if (h == memH) {
                        return new Color(nb, nc, na);
                    }
                    if (mh < memH && h > memH || mh > memH && h < memH) {
                        return new Color(nb, nc, na);
                    }
                    if (Math.abs(h - memH) < delta) {
                        delta = Math.abs(h - memH);
                        ba = na;
                    }
                    mh = h;
                }
                if (h != memH) {
                    mh = h = ColorRoutines.getHue(nc, na, nb);
                    na = ta;
                    while (h != memH && na >= 0) {
                        h = ColorRoutines.getHue(nb, nc, --na);
                        if (na == -1) break;
                        if (h == memH) {
                            return new Color(nb, nc, na);
                        }
                        if (mh < memH && h > memH || mh > memH && h < memH) {
                            return new Color(nb, nc, na);
                        }
                        if (Math.abs(h - memH) < delta) {
                            delta = Math.abs(h - memH);
                            ba = na;
                        }
                        mh = h;
                    }
                }
                if (na == 256 | na == -1) {
                    na = ba;
                }
                rc = new Color(nb, nc, na);
                break;
            }
            case 4: {
                mh = h = ColorRoutines.getHue(na, nc, nb);
                while (h != memH && na < 256) {
                    h = ColorRoutines.getHue(++na, nc, nb);
                    if (na == 256) break;
                    if (h == memH) {
                        return new Color(na, nc, nb);
                    }
                    if (mh < memH && h > memH || mh > memH && h < memH) {
                        return new Color(na, nc, nb);
                    }
                    if (Math.abs(h - memH) < delta) {
                        delta = Math.abs(h - memH);
                        ba = na;
                    }
                    mh = h;
                }
                if (h != memH) {
                    mh = h = ColorRoutines.getHue(nc, na, nb);
                    na = ta;
                    while (h != memH && na >= 0) {
                        h = ColorRoutines.getHue(--na, nc, nb);
                        if (na == -1) break;
                        if (h == memH) {
                            return new Color(na, nc, nb);
                        }
                        if (mh < memH && h > memH || mh > memH && h < memH) {
                            return new Color(na, nc, nb);
                        }
                        if (Math.abs(h - memH) < delta) {
                            delta = Math.abs(h - memH);
                            ba = na;
                        }
                        mh = h;
                    }
                }
                if (na == 256 | na == -1) {
                    na = ba;
                }
                rc = new Color(na, nc, nb);
                break;
            }
            case 5: {
                mh = h = ColorRoutines.getHue(na, nb, nc);
                while (h != memH && na < 256) {
                    h = ColorRoutines.getHue(++na, nb, nc);
                    if (na == 256) break;
                    if (h == memH) {
                        return new Color(na, nb, nc);
                    }
                    if (mh < memH && h > memH || mh > memH && h < memH) {
                        return new Color(na, nb, nc);
                    }
                    if (Math.abs(h - memH) < delta) {
                        delta = Math.abs(h - memH);
                        ba = na;
                    }
                    mh = h;
                }
                if (h != memH) {
                    mh = h = ColorRoutines.getHue(nc, na, nb);
                    na = ta;
                    while (h != memH && na >= 0) {
                        h = ColorRoutines.getHue(--na, nb, nc);
                        if (na == -1) break;
                        if (h == memH) {
                            return new Color(na, nb, nc);
                        }
                        if (mh < memH && h > memH || mh > memH && h < memH) {
                            return new Color(na, nb, nc);
                        }
                        if (Math.abs(h - memH) < delta) {
                            delta = Math.abs(h - memH);
                            ba = na;
                        }
                        mh = h;
                    }
                }
                if (na == 256 | na == -1) {
                    na = ba;
                }
                rc = new Color(na, nb, nc);
                break;
            }
            case 6: {
                mh = h = ColorRoutines.getHue(nb, na, nc);
                while (h != memH && na < 256) {
                    h = ColorRoutines.getHue(nb, ++na, nc);
                    if (na == 256) break;
                    if (h == memH) {
                        return new Color(nb, na, nc);
                    }
                    if (mh < memH && h > memH || mh > memH && h < memH) {
                        return new Color(nb, na, nc);
                    }
                    if (Math.abs(h - memH) < delta) {
                        delta = Math.abs(h - memH);
                        ba = na;
                    }
                    mh = h;
                }
                if (h != memH) {
                    mh = h = ColorRoutines.getHue(nc, na, nb);
                    na = ta;
                    while (h != memH && na >= 0) {
                        h = ColorRoutines.getHue(nb, --na, nc);
                        if (na == -1) break;
                        if (h == memH) {
                            return new Color(nb, na, nc);
                        }
                        if (mh < memH && h > memH || mh > memH && h < memH) {
                            return new Color(nb, na, nc);
                        }
                        if (Math.abs(h - memH) < delta) {
                            delta = Math.abs(h - memH);
                            ba = na;
                        }
                        mh = h;
                    }
                }
                if (na == 256 | na == -1) {
                    na = ba;
                }
                rc = new Color(nb, na, nc);
            }
        }
        return rc;
    }

    public static float getGreyValue(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int tb = 0;
        int tc = 0;
        if (r >= g && r >= b) {
            if (r == 0) {
                return 0.0f;
            }
            tc = r;
            tb = g >= b ? b : g;
        } else if (g >= r && g >= b) {
            tc = g;
            tb = r >= b ? b : r;
        } else if (b >= r && b >= g) {
            tc = b;
            tb = r >= g ? g : r;
        }
        return (float)((double)(tc + tb) / 2.0);
    }

    public static int getBrightness(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return ColorRoutines.getBrightness(r, g, b);
    }

    public static int getBrightness(int r, int g, int b) {
        if (r >= g && r >= b) {
            return (int)Math.round((double)(100 * r) / 255.0);
        }
        if (g >= r && g >= b) {
            return (int)Math.round((double)(100 * g) / 255.0);
        }
        if (b >= r && b >= g) {
            return (int)Math.round((double)(100 * b) / 255.0);
        }
        return -1;
    }

    public static int getSaturation(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return ColorRoutines.getSaturation(r, g, b);
    }

    public static int getSaturation(int r, int g, int b) {
        int tb = 0;
        int tc = 0;
        if (r >= g && r >= b) {
            if (r == 0) {
                return 0;
            }
            tc = r;
            tb = g >= b ? b : g;
        } else if (g >= r && g >= b) {
            tc = g;
            tb = r >= b ? b : r;
        } else if (b >= r && b >= g) {
            tc = b;
            tb = r >= g ? g : r;
        }
        return 100 - (int)Math.round(100.0 * (double)tb / (double)tc);
    }

    public static int getHue(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return ColorRoutines.getHue(r, g, b);
    }

    public static int calculateHue(Color c) {
        float[] f = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        return (int)Math.round(360.0 * (double)f[0]);
    }

    public static int getHue(int r, int g, int b) {
        int ta = 0;
        int tb = 0;
        int tc = 0;
        int mapping = 1;
        if (r >= g && r >= b) {
            tc = r;
            if (g == b) {
                return 0;
            }
            if (g > b) {
                ta = g;
                tb = b;
                mapping = 1;
            } else {
                tb = g;
                ta = b;
                mapping = 2;
            }
        } else if (g >= r && g >= b) {
            tc = g;
            if (r == b) {
                return 120;
            }
            if (r > b) {
                ta = r;
                tb = b;
                mapping = 4;
            } else {
                tb = r;
                ta = b;
                mapping = 3;
            }
        } else if (b >= r && b >= g) {
            tc = b;
            if (r == g) {
                return 240;
            }
            if (r > g) {
                ta = r;
                tb = g;
                mapping = 5;
            } else {
                tb = r;
                ta = g;
                mapping = 6;
            }
        }
        double na = (double)ta * 255.0 / (double)tc;
        double nb = (double)tb * 255.0 / (double)tc;
        double val = (na - nb) * 255.0 / (255.0 - nb);
        int w = (int)Math.round(60.0 * val / 255.0);
        switch (mapping) {
            case 1: {
                return w;
            }
            case 2: {
                return 360 - w;
            }
            case 3: {
                return 120 + w;
            }
            case 4: {
                return 120 - w;
            }
            case 5: {
                return 240 + w;
            }
            case 6: {
                return 240 - w;
            }
        }
        return -1;
    }

    public static Color getHSB(int h, int s, int b) {
        double cr = 0.0;
        double cg = 0.0;
        double cb = 0.0;
        int mapping = 1;
        if (h == 360) {
            h = 0;
        }
        int winkel = h / 60;
        int amount = h % 60;
        switch (winkel) {
            case 0: {
                cr = 255.0;
                cg = (double)(255 * amount) / 60.0;
                mapping = 1;
                break;
            }
            case 1: {
                cg = 255.0;
                cr = 255.0 - (double)(255 * amount) / 60.0;
                mapping = 3;
                break;
            }
            case 2: {
                cg = 255.0;
                cb = (double)(255 * amount) / 60.0;
                mapping = 3;
                break;
            }
            case 3: {
                cb = 255.0;
                cg = 255.0 - (double)(255 * amount) / 60.0;
                mapping = 5;
                break;
            }
            case 4: {
                cb = 255.0;
                cr = (double)(255 * amount) / 60.0;
                mapping = 5;
                break;
            }
            case 5: {
                cr = 255.0;
                cb = 255.0 - (double)(255 * amount) / 60.0;
                mapping = 1;
            }
        }
        cr = cr * (double)b / 100.0;
        cg = cg * (double)b / 100.0;
        cb = cb * (double)b / 100.0;
        int d = 100 - s;
        switch (mapping) {
            case 1: {
                cg += (cr - cg) * (double)d / 100.0;
                cb += (cr - cb) * (double)d / 100.0;
                break;
            }
            case 3: {
                cr += (cg - cr) * (double)d / 100.0;
                cb += (cg - cb) * (double)d / 100.0;
                break;
            }
            case 5: {
                cr += (cb - cr) * (double)d / 100.0;
                cg += (cb - cg) * (double)d / 100.0;
            }
        }
        return new Color((int)Math.round(cr), (int)Math.round(cg), (int)Math.round(cb));
    }

    public int colorize(int r, int g, int b, int a) {
        if (this.cbri == 100) {
            return ColorRoutines.colorToInt(255, 255, 255, a);
        }
        if (this.cbri == -100) {
            return ColorRoutines.colorToInt(0, 0, 0, a);
        }
        int hi1 = r;
        if (g >= r && g >= b) {
            hi1 = g;
        } else if (b >= r && b >= g) {
            hi1 = b;
        }
        int lo1 = r;
        if (g <= r && g <= b) {
            lo1 = g;
        } else if (b <= r && b <= g) {
            lo1 = b;
        }
        int grey = (hi1 + lo1) / 2;
        if (this.cbri < 0) {
            grey += grey * this.cbri / 100;
        } else if (this.cbri > 0) {
            grey += (255 - grey) * this.cbri / 100;
        }
        if (this.preserveGrey && r == g && r == b) {
            return ColorRoutines.colorToInt(grey, grey, grey, a);
        }
        int hr = 0;
        int hg = 0;
        int hb = 0;
        int diff = 0;
        diff = grey >= 127 ? 255 - grey : grey;
        if (this.hiIsR) {
            hr = grey + diff * this.csat / 100;
        } else if (this.hiIsG) {
            hg = grey + diff * this.csat / 100;
        } else if (this.hiIsB) {
            hb = grey + diff * this.csat / 100;
        }
        if (this.mdIsR) {
            diff = grey >= 127 ? this.fr + (255 - this.fr) * (grey - 127) / 128 - grey : this.fr * grey / 127 - grey;
            hr = grey + diff * this.csat / 100;
        } else if (this.mdIsG) {
            diff = grey >= 127 ? this.fg + (255 - this.fg) * (grey - 127) / 128 - grey : this.fg * grey / 127 - grey;
            hg = grey + diff * this.csat / 100;
        } else if (this.mdIsB) {
            diff = grey >= 127 ? this.fb + (255 - this.fb) * (grey - 127) / 128 - grey : this.fb * grey / 127 - grey;
            hb = grey + diff * this.csat / 100;
        }
        diff = grey - (255 - grey);
        if (diff < 0) {
            diff = 0;
        }
        diff = grey - diff;
        if (this.loIsR) {
            hr = grey - diff * this.csat / 100;
        } else if (this.loIsG) {
            hg = grey - diff * this.csat / 100;
        } else if (this.loIsB) {
            hb = grey - diff * this.csat / 100;
        }
        return ColorRoutines.colorToInt(hr, hg, hb, a);
    }

    public static Color getInverseColor(Color c) {
        int r = 255 - c.getRed();
        int g = 255 - c.getGreen();
        int b = 255 - c.getBlue();
        return new Color(r, g, b);
    }

    public static Color getRandomColor() {
        int r = (int)(Math.random() * 255.0);
        int g = (int)(Math.random() * 255.0);
        int b = (int)(Math.random() * 255.0);
        return new Color(r, g, b);
    }

    public static Color getAlphaColor(Color c, int a) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return new Color(r, g, b, a);
    }

    protected static int colorToInt(Color c, int a) {
        return c.getBlue() + c.getGreen() * 256 + c.getRed() * 65536 + a * 0x1000000;
    }

    protected static int colorToInt(int r, int g, int b, int a) {
        return b + g * 256 + r * 65536 + a * 0x1000000;
    }

    public static Color lighten(Color c, int amount) {
        if (amount < 0) {
            return c;
        }
        if (amount > 100) {
            amount = 100;
        }
        int dr = (int)Math.round((double)((255 - c.getRed()) * amount) / 100.0);
        int dg = (int)Math.round((double)((255 - c.getGreen()) * amount) / 100.0);
        int db = (int)Math.round((double)((255 - c.getBlue()) * amount) / 100.0);
        return new Color(c.getRed() + dr, c.getGreen() + dg, c.getBlue() + db, c.getAlpha());
    }

    public static Color darken(Color c, int amount) {
        if (amount < 0 || amount > 100) {
            return c;
        }
        int r = (int)Math.round((double)(c.getRed() * (100 - amount)) / 100.0);
        int g = (int)Math.round((double)(c.getGreen() * (100 - amount)) / 100.0);
        int b = (int)Math.round((double)(c.getBlue() * (100 - amount)) / 100.0);
        return new Color(r, g, b, c.getAlpha());
    }

    public static Color lighten(int grey, int amount) {
        if (amount < 0 || amount > 100) {
            return new Color(grey, grey, grey);
        }
        int val = (255 - grey) * amount / 100 + grey;
        return new Color(val, val, val);
    }

    public static Color darken(int grey, int amount) {
        if (amount < 0 || amount > 100) {
            return new Color(grey, grey, grey);
        }
        int val = grey * (100 - amount) / 100;
        return new Color(val, val, val);
    }
}

