/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Stack;
import mondrian.olap.Util;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXHandler
implements ContentHandler {
    private final ContentHandler contentHandler;
    private final Stack stack = new Stack();
    static final Attributes EmptyAttributes = new Attributes(){

        public int getLength() {
            return 0;
        }

        public String getURI(int index) {
            return null;
        }

        public String getLocalName(int index) {
            return null;
        }

        public String getQName(int index) {
            return null;
        }

        public String getType(int index) {
            return null;
        }

        public String getValue(int index) {
            return null;
        }

        public int getIndex(String uri, String localName) {
            return 0;
        }

        public int getIndex(String qName) {
            return 0;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getType(String qName) {
            return null;
        }

        public String getValue(String uri, String localName) {
            return null;
        }

        public String getValue(String qName) {
            return null;
        }
    };

    public SAXHandler(ContentHandler saxHandler) {
        this.contentHandler = saxHandler;
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        Util.assertTrue(this.stack.isEmpty());
        this.contentHandler.endDocument();
    }

    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.contentHandler.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.contentHandler.endElement(namespaceURI, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void characters(String s) throws SAXException {
        this.contentHandler.characters(s.toCharArray(), 0, s.length());
    }

    public void element(String tagName, String[] attributes) throws SAXException {
        this.startElement(tagName, attributes);
        this.endElement();
    }

    public void startElement(String tagName) throws SAXException {
        this.contentHandler.startElement(null, null, tagName, EmptyAttributes);
        this.stack.push(tagName);
    }

    public void startElement(String tagName, String[] attributes) throws SAXException {
        this.contentHandler.startElement(null, null, tagName, new StringAttributes(attributes));
        this.stack.push(tagName);
    }

    public void endElement() throws SAXException {
        String tagName = (String)this.stack.pop();
        this.contentHandler.endElement(null, null, tagName);
    }

    public void completeBeforeElement(String tagName) throws SAXException {
        if (this.stack.indexOf(tagName) == -1) {
            return;
        }
        String currentTagName = (String)this.stack.peek();
        while (!tagName.equals(currentTagName)) {
            this.contentHandler.endElement(null, null, currentTagName);
            this.stack.pop();
            currentTagName = (String)this.stack.peek();
        }
    }

    public static class StringAttributes
    implements Attributes {
        private final String[] strings;

        public StringAttributes(String[] strings) {
            this.strings = strings;
        }

        public int getLength() {
            return this.strings.length / 2;
        }

        public String getURI(int index) {
            return null;
        }

        public String getLocalName(int index) {
            return null;
        }

        public String getQName(int index) {
            return this.strings[index * 2];
        }

        public String getType(int index) {
            return null;
        }

        public String getValue(int index) {
            return this.strings[index * 2 + 1];
        }

        public int getIndex(String uri, String localName) {
            return -1;
        }

        public int getIndex(String qName) {
            int count = this.strings.length / 2;
            for (int i = 0; i < count; ++i) {
                String string = this.strings[i * 2];
                if (!string.equals(qName)) continue;
                return i;
            }
            return -1;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getType(String qName) {
            return null;
        }

        public String getValue(String uri, String localName) {
            return null;
        }

        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (index < 0) {
                return null;
            }
            return this.strings[index * 2 + 1];
        }
    }
}

