/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Level;
import mondrian.olap.LevelBase;
import mondrian.olap.LevelType;
import mondrian.olap.Member;
import mondrian.olap.MemberFormatter;
import mondrian.olap.MondrianDef;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapProperty;
import org.apache.log4j.Logger;

public class RolapLevel
extends LevelBase {
    private static final Logger LOGGER = Logger.getLogger((Class)RolapEvaluator.class);
    static final int NUMERIC = 1;
    static final int ALL = 2;
    static final int UNIQUE = 4;
    private final MondrianDef.Expression keyExp;
    private final MondrianDef.Expression ordinalExp;
    private final MondrianDef.Expression captionExp;
    private final boolean unique;
    private final boolean numeric;
    private final int flags;
    private final RolapProperty[] properties;
    private final RolapProperty[] inheritedProperties;
    private final MondrianDef.Expression nameExp;
    private final MondrianDef.Expression parentExp;
    private final String nullParentValue;
    private RolapLevel closedPeer;
    private final HideMemberCondition hideMemberCondition;
    private final MondrianDef.Closure xmlClosure;

    public static RolapLevel lookupLevel(RolapLevel[] levels, String levelName) {
        for (int i = 0; i < levels.length; ++i) {
            RolapLevel level = levels[i];
            if (!level.getName().equals(levelName)) continue;
            return level;
        }
        return null;
    }

    RolapLevel(RolapHierarchy hierarchy, int depth, String name, MondrianDef.Expression keyExp, MondrianDef.Expression nameExp, MondrianDef.Expression captionExp, MondrianDef.Expression ordinalExp, MondrianDef.Expression parentExp, String nullParentValue, MondrianDef.Closure xmlClosure, RolapProperty[] properties, int flags, HideMemberCondition hideMemberCondition, LevelType levelType) {
        super(hierarchy, name, depth, levelType);
        Util.assertPrecondition(properties != null, "properties != null");
        Util.assertPrecondition(hideMemberCondition != null, "hideMemberCondition != null");
        Util.assertPrecondition(levelType != null, "levelType != null");
        if (keyExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)keyExp);
        }
        this.flags = flags;
        boolean isAll = (flags & 2) == 2;
        this.unique = (flags & 4) == 4;
        this.numeric = (flags & 1) == 1;
        this.keyExp = keyExp;
        if (nameExp != null && nameExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)nameExp);
        }
        this.nameExp = nameExp;
        if (captionExp != null && captionExp instanceof MondrianDef.Column) {
            this.checkColumn((MondrianDef.Column)captionExp);
        }
        this.captionExp = captionExp;
        if (ordinalExp != null) {
            if (ordinalExp instanceof MondrianDef.Column) {
                this.checkColumn((MondrianDef.Column)ordinalExp);
            }
            this.ordinalExp = ordinalExp;
        } else {
            this.ordinalExp = this.keyExp;
        }
        this.parentExp = parentExp;
        if (parentExp != null) {
            Util.assertTrue(!isAll, "'All' level '" + this + "' must not be parent-child");
            Util.assertTrue(this.unique, "Parent-child level '" + this + "' must have uniqueMembers=\"true\"");
        }
        this.nullParentValue = nullParentValue;
        Util.assertPrecondition(parentExp != null || nullParentValue == null, "parentExp != null || nullParentValue == null");
        this.xmlClosure = xmlClosure;
        for (int i = 0; i < properties.length; ++i) {
            RolapProperty property = properties[i];
            if (!(property.getExp() instanceof MondrianDef.Column)) continue;
            this.checkColumn((MondrianDef.Column)property.getExp());
        }
        this.properties = properties;
        ArrayList<Property> list = new ArrayList<Property>();
        for (Level level = this; level != null; level = level.getParentLevel()) {
            Property[] levelProperties = level.getProperties();
            for (int i = 0; i < levelProperties.length; ++i) {
                Property levelProperty = levelProperties[i];
                Property existingProperty = this.lookupProperty(list, levelProperty.getName());
                if (existingProperty == null) {
                    list.add(levelProperty);
                    continue;
                }
                if (existingProperty.getType() == levelProperty.getType()) continue;
                throw Util.newError("Property " + this.getName() + "." + levelProperty.getName() + " overrides a " + "property with the same name but different type");
            }
        }
        this.inheritedProperties = list.toArray(RolapProperty.emptyArray);
        Dimension dim = hierarchy.getDimension();
        if (dim.getDimensionType() == DimensionType.TimeDimension) {
            if (!levelType.isTime() && !isAll) {
                throw MondrianResource.instance().NonTimeLevelInTimeHierarchy.ex(this.getUniqueName());
            }
        } else if (dim.getDimensionType() != null && levelType.isTime()) {
            throw MondrianResource.instance().TimeLevelInNonTimeHierarchy.ex(this.getUniqueName());
        }
        this.hideMemberCondition = hideMemberCondition;
        this.closedPeer = null;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    String getTableName() {
        String tableName = null;
        MondrianDef.Expression expr = this.getKeyExp();
        if (expr instanceof MondrianDef.Column) {
            MondrianDef.Column mc = (MondrianDef.Column)expr;
            tableName = mc.getTableAlias();
        }
        return tableName;
    }

    public MondrianDef.Expression getKeyExp() {
        return this.keyExp;
    }

    MondrianDef.Expression getOrdinalExp() {
        return this.ordinalExp;
    }

    public MondrianDef.Expression getCaptionExp() {
        return this.captionExp;
    }

    public boolean hasCaptionColumn() {
        return this.captionExp != null;
    }

    int getFlags() {
        return this.flags;
    }

    HideMemberCondition getHideMemberCondition() {
        return this.hideMemberCondition;
    }

    boolean isUnique() {
        return this.unique;
    }

    boolean isNumeric() {
        return this.numeric;
    }

    RolapProperty[] getRolapProperties() {
        return this.properties;
    }

    String getNullParentValue() {
        return this.nullParentValue;
    }

    MondrianDef.Expression getParentExp() {
        return this.parentExp;
    }

    MondrianDef.Expression getNameExp() {
        return this.nameExp;
    }

    private Property lookupProperty(List list, String propertyName) {
        Property existingProperty = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().equals(propertyName)) continue;
            existingProperty = property;
            break;
        }
        return existingProperty;
    }

    RolapLevel(RolapHierarchy hierarchy, int depth, MondrianDef.Level xmlLevel) {
        this(hierarchy, depth, xmlLevel.name, xmlLevel.getKeyExp(), xmlLevel.getNameExp(), xmlLevel.getCaptionExp(), xmlLevel.getOrdinalExp(), xmlLevel.getParentExp(), xmlLevel.nullParentValue, xmlLevel.closure, RolapLevel.createProperties(xmlLevel), (xmlLevel.type.equals("Numeric") ? 1 : 0) | (xmlLevel.uniqueMembers != false ? 4 : 0), HideMemberCondition.lookup(xmlLevel.hideMemberIf), LevelType.lookup(xmlLevel.levelType));
        if (!Util.isEmpty(xmlLevel.caption)) {
            this.setCaption(xmlLevel.caption);
        }
        if (!Util.isEmpty(xmlLevel.formatter)) {
            try {
                Class<?> clazz = Class.forName(xmlLevel.formatter);
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                this.memberFormatter = (MemberFormatter)ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw MondrianResource.instance().MemberFormatterLoadFailed.ex(xmlLevel.formatter, this.getUniqueName(), e);
            }
        }
    }

    private static RolapProperty[] createProperties(MondrianDef.Level xmlLevel) {
        ArrayList<RolapProperty> list = new ArrayList<RolapProperty>();
        MondrianDef.Expression nameExp = xmlLevel.getNameExp();
        if (nameExp != null) {
            list.add(new RolapProperty(Property.NAME.name, 0, nameExp, null, null));
        }
        for (int i = 0; i < xmlLevel.properties.length; ++i) {
            MondrianDef.Property property = xmlLevel.properties[i];
            list.add(new RolapProperty(property.name, RolapLevel.convertPropertyTypeNameToCode(property.type), xmlLevel.getPropertyExp(i), property.formatter, property.caption));
        }
        return list.toArray(RolapProperty.emptyArray);
    }

    private static int convertPropertyTypeNameToCode(String type) {
        if (type.equals("String")) {
            return 0;
        }
        if (type.equals("Numeric")) {
            return 1;
        }
        if (type.equals("Boolean")) {
            return 2;
        }
        throw Util.newError("Unknown property type '" + type + "'");
    }

    private void checkColumn(MondrianDef.Column nameColumn) {
        RolapHierarchy rolapHierarchy = (RolapHierarchy)this.hierarchy;
        if (nameColumn.table == null) {
            MondrianDef.Relation table = rolapHierarchy.getUniqueTable();
            if (table == null) {
                throw Util.newError("must specify a table for level " + this.getUniqueName() + " because hierarchy has more than one table");
            }
            nameColumn.table = table.getAlias();
        } else {
            Util.assertTrue(rolapHierarchy.tableExists(nameColumn.table));
        }
    }

    void init(RolapCube cube, MondrianDef.CubeDimension xmlDimension) {
        if (this.xmlClosure != null) {
            RolapDimension dimension = ((RolapHierarchy)this.hierarchy).createClosedPeerDimension(this, this.xmlClosure, cube, xmlDimension);
            dimension.init(cube, xmlDimension);
            cube.registerDimension(dimension);
            this.closedPeer = (RolapLevel)dimension.getHierarchies()[0].getLevels()[1];
        }
    }

    public boolean isAll() {
        return this.hierarchy.hasAll() && this.depth == 0;
    }

    public boolean areMembersUnique() {
        return this.depth == 0 || this.depth == 1 && this.hierarchy.hasAll();
    }

    public String getTableAlias() {
        return this.keyExp.getTableAlias();
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public Property[] getInheritedProperties() {
        return this.inheritedProperties;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String name) {
        Member[] levelMembers = schemaReader.getLevelMembers(this);
        for (int idx = 0; idx < levelMembers.length; ++idx) {
            if (!levelMembers[idx].getName().equals(name)) continue;
            return levelMembers[idx];
        }
        return null;
    }

    boolean hasClosedPeer() {
        return this.parentExp != null && this.closedPeer != null;
    }

    RolapLevel getClosedPeer() {
        return this.closedPeer;
    }

    public static class HideMemberCondition
    extends EnumeratedValues.BasicValue {
        public static final int NeverORDINAL = 0;
        public static final HideMemberCondition Never = new HideMemberCondition("Never", 0);
        public static final int IfBlankNameORDINAL = 1;
        public static final HideMemberCondition IfBlankName = new HideMemberCondition("IfBlankName", 1);
        public static final int IfParentsNameORDINAL = 2;
        public static final HideMemberCondition IfParentsName = new HideMemberCondition("IfParentsName", 2);
        public static final EnumeratedValues enumeration = new EnumeratedValues(new HideMemberCondition[]{Never, IfBlankName, IfParentsName});

        private HideMemberCondition(String name, int ordinal) {
            super(name, ordinal, null);
        }

        public static HideMemberCondition lookup(String s) {
            return (HideMemberCondition)enumeration.getValue(s, true);
        }
    }
}

