/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

public interface BitKey {
    public void setByPos(int var1, boolean var2);

    public void setByPos(int var1);

    public boolean isSetByPos(int var1);

    public void clearByPos(int var1);

    public void clear();

    public boolean isSuperSetOf(BitKey var1);

    public BitKey or(BitKey var1);

    public BitKey copy();

    public BitKey emptyCopy();

    public static class Big
    extends AbstractBitKey {
        private long[] bits;

        private Big(int size) {
            this.bits = new long[Big.chunkCount(size)];
        }

        private Big(Big big) {
            this.bits = (long[])big.bits.clone();
        }

        private int size() {
            return this.bits.length;
        }

        public void setByPos(int pos) {
            int n = Big.chunkPos(pos);
            this.bits[n] = this.bits[n] | Big.bit(pos);
        }

        public boolean isSetByPos(int pos) {
            return (this.bits[Big.chunkPos(pos)] & Big.bit(pos)) != 0L;
        }

        public void clearByPos(int pos) {
            int n = Big.chunkPos(pos);
            this.bits[n] = this.bits[n] & (Big.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL);
        }

        public void clear() {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
        }

        private void or(long bits0) {
            this.bits[0] = this.bits[0] | bits0;
        }

        private void or(long bits0, long bits1) {
            this.bits[0] = this.bits[0] | bits0;
            this.bits[1] = this.bits[1] | bits1;
        }

        private void or(long[] bits) {
            for (int i = 0; i < bits.length; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] | bits[i];
            }
        }

        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Big bk = (Big)this.copy();
                bk.or(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Big bk = (Big)this.copy();
                bk.or(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if (other.size() > this.size()) {
                    Big bk = (Big)other.copy();
                    bk.or(this.bits);
                    return bk;
                }
                Big bk = (Big)this.copy();
                bk.or(other.bits);
                return bk;
            }
            String msg = bitKey == null ? "Null BitKey" : "Bad BitKey type: " + bitKey.getClass().getName();
            throw new IllegalArgumentException(msg);
        }

        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits[0] | other.bits) == this.bits[0];
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits[0] | other.bits0) == this.bits[0] && (this.bits[1] | other.bits1) == this.bits[1];
            }
            if (bitKey instanceof Big) {
                int i;
                Big other = (Big)bitKey;
                int len = Math.min(this.bits.length, other.bits.length);
                for (i = 0; i < len; ++i) {
                    if ((this.bits[i] | other.bits[i]) == this.bits[i]) continue;
                    return false;
                }
                if (other.bits.length > this.bits.length) {
                    for (i = len; i < other.bits.length; ++i) {
                        if (other.bits[i] == 0L) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                if (this.bits[0] != other.bits) {
                    return false;
                }
                for (int i = 1; i < this.bits.length; ++i) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                if (this.bits[0] != other.bits0) {
                    return false;
                }
                if (this.bits[1] != other.bits1) {
                    return false;
                }
                for (int i = 2; i < this.bits.length; ++i) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            if (o instanceof Big) {
                int i;
                Big other = (Big)o;
                int len = Math.min(this.bits.length, other.bits.length);
                for (i = 0; i < len; ++i) {
                    if (this.bits[i] == other.bits[i]) continue;
                    return false;
                }
                if (this.bits.length > other.bits.length) {
                    for (i = len; i < this.bits.length; ++i) {
                        if (this.bits[i] == 0L) continue;
                        return false;
                    }
                } else if (other.bits.length > this.bits.length) {
                    for (i = len; i < other.bits.length; ++i) {
                        if (other.bits[i] == 0L) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            long h = 1234L;
            int i = this.bits.length;
            while (--i >= 0) {
                h ^= this.bits[i] * (long)(i + 1);
            }
            return (int)(h >> 32 ^ h);
        }

        public String toString() {
            int start;
            StringBuffer buf = new StringBuffer(64);
            buf.append("0x");
            for (int i = start = this.bits.length * 64 - 1; i >= 0; --i) {
                buf.append(this.isSetByPos(i) ? (char)'1' : '0');
            }
            return buf.toString();
        }

        public BitKey copy() {
            return new Big(this);
        }

        public BitKey emptyCopy() {
            return new Big(this.size());
        }
    }

    public static class Mid128
    extends AbstractBitKey {
        private long bits0;
        private long bits1;

        private Mid128() {
        }

        private Mid128(Mid128 mid) {
            this.bits0 = mid.bits0;
            this.bits1 = mid.bits1;
        }

        public void setByPos(int pos) {
            if (pos < 64) {
                this.bits0 |= Mid128.bit(pos);
            } else {
                this.bits1 |= Mid128.bit(pos);
            }
        }

        public boolean isSetByPos(int pos) {
            if (pos < 64) {
                return (this.bits0 & Mid128.bit(pos)) != 0L;
            }
            return (this.bits1 & Mid128.bit(pos)) != 0L;
        }

        public void clearByPos(int pos) {
            if (pos < 64) {
                this.bits0 &= Mid128.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
            } else {
                this.bits1 &= Mid128.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }

        public void clear() {
            this.bits0 = 0L;
            this.bits1 = 0L;
        }

        private void or(long bits0, long bits1) {
            this.bits0 |= bits0;
            this.bits1 |= bits1;
        }

        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.or(other.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)this.copy();
                bk.or(other.bits0, other.bits1);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)other.copy();
                bk.or(this.bits0, this.bits1);
                return bk;
            }
            String msg = bitKey == null ? "Null BitKey" : "Bad BitKey type: " + bitKey.getClass().getName();
            throw new IllegalArgumentException(msg);
        }

        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits0 | other.bits) == this.bits0;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits0 | other.bits0) == this.bits0 && (this.bits1 | other.bits1) == this.bits1;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if ((this.bits0 | other.bits[0]) != this.bits0) {
                    return false;
                }
                if ((this.bits1 | other.bits[1]) != this.bits1) {
                    return false;
                }
                for (int i = 2; i < other.bits.length; ++i) {
                    if (other.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                return this.bits0 == other.bits && this.bits1 == 0L;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                return this.bits0 == other.bits0 && this.bits1 == other.bits1;
            }
            if (o instanceof Big) {
                Big other = (Big)o;
                if (this.bits0 != other.bits[0]) {
                    return false;
                }
                if (this.bits1 != other.bits[1]) {
                    return false;
                }
                for (int i = 2; i < other.bits.length; ++i) {
                    if (other.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            long h = 1234L;
            h ^= this.bits0;
            return (int)((h ^= this.bits1 * 2L) >> 32 ^ h);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(64);
            buf.append("0x");
            for (int i = 127; i >= 0; --i) {
                buf.append(this.isSetByPos(i) ? (char)'1' : '0');
            }
            return buf.toString();
        }

        public BitKey copy() {
            return new Mid128(this);
        }

        public BitKey emptyCopy() {
            return new Mid128();
        }
    }

    public static class Small
    extends AbstractBitKey {
        private long bits;

        private Small() {
        }

        private Small(long bits) {
            this.bits = bits;
        }

        private Small(Small small) {
            this.bits = small.bits;
        }

        public void setByPos(int pos) {
            this.bits |= Small.bit(pos);
        }

        public boolean isSetByPos(int pos) {
            return (this.bits & Small.bit(pos)) != 0L;
        }

        public void clearByPos(int pos) {
            this.bits &= Small.bit(pos) ^ 0xFFFFFFFFFFFFFFFFL;
        }

        public void clear() {
            this.bits = 0L;
        }

        private void or(long bits) {
            this.bits |= bits;
        }

        public BitKey or(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                Small bk = (Small)this.copy();
                bk.or(other.bits);
                return bk;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                Mid128 bk = (Mid128)other.copy();
                bk.or(this.bits, 0L);
                return bk;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                Big bk = (Big)other.copy();
                bk.or(this.bits);
                return bk;
            }
            String msg = bitKey == null ? "Null BitKey" : "Bad BitKey type: " + bitKey.getClass().getName();
            throw new IllegalArgumentException(msg);
        }

        public boolean isSuperSetOf(BitKey bitKey) {
            if (bitKey instanceof Small) {
                Small other = (Small)bitKey;
                return (this.bits | other.bits) == this.bits;
            }
            if (bitKey instanceof Mid128) {
                Mid128 other = (Mid128)bitKey;
                return (this.bits | other.bits0) == this.bits && other.bits1 == 0L;
            }
            if (bitKey instanceof Big) {
                Big other = (Big)bitKey;
                if ((this.bits | other.bits[0]) != this.bits) {
                    return false;
                }
                for (int i = 1; i < other.bits.length; ++i) {
                    if (other.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Small) {
                Small other = (Small)o;
                return this.bits == other.bits;
            }
            if (o instanceof Mid128) {
                Mid128 other = (Mid128)o;
                return this.bits == other.bits0 && other.bits1 == 0L;
            }
            if (o instanceof Big) {
                Big other = (Big)o;
                if (this.bits != other.bits[0]) {
                    return false;
                }
                for (int i = 1; i < other.bits.length; ++i) {
                    if (other.bits[i] == 0L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.bits ^ this.bits >>> 32);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(64);
            buf.append("0x");
            for (int i = 63; i >= 0; --i) {
                buf.append(this.isSetByPos(i) ? (char)'1' : '0');
            }
            return buf.toString();
        }

        public BitKey copy() {
            return new Small(this);
        }

        public BitKey emptyCopy() {
            return new Small();
        }
    }

    public static abstract class AbstractBitKey
    implements BitKey {
        protected static final int ChunkBitCount = 6;
        protected static final int Mask = 63;

        protected AbstractBitKey() {
        }

        protected static long bit(int pos) {
            return 1L << (pos & 0x3F);
        }

        protected static int chunkPos(int size) {
            return size >> 6;
        }

        protected static int chunkCount(int size) {
            return size + 63 >> 6;
        }

        public final void setByPos(int pos, boolean value) {
            if (value) {
                this.setByPos(pos);
            } else {
                this.clearByPos(pos);
            }
        }
    }

    public static abstract class Factory {
        public static BitKey makeBitKey(int size) {
            if (size < 0) {
                String msg = "Negative size \"" + size + "\" not allowed";
                throw new IllegalArgumentException(msg);
            }
            switch (AbstractBitKey.chunkCount(size)) {
                case 0: 
                case 1: {
                    return new Small();
                }
                case 2: {
                    return new Mid128();
                }
            }
            return new Big(size);
        }
    }
}

