/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.olap.Category;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.Util;

public class Syntax
extends EnumeratedValues.BasicValue {
    public static final Syntax Function = new Syntax("Function", 0){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (fun.equals("_Value") && args[0] instanceof FunCall && ((FunCall)args[0]).isCallToTuple()) {
                ((FunCall)args[0]).unparse(pw);
                return;
            }
            ExpBase.unparseList(pw, args, fun + "(", ", ", ")");
        }
    };
    public static final Syntax Property = new Syntax("Property", 1){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            Util.assertTrue(args.length >= 1);
            args[0].unparse(pw);
            pw.print(".");
            pw.print(fun);
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return Syntax.getTypeDescription(argTypes[0]) + "." + name;
        }
    };
    public static final Syntax Method = new Syntax("Method", 2){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            Util.assertTrue(args.length >= 1);
            args[0].unparse(pw);
            pw.print(".");
            pw.print(fun);
            pw.print("(");
            for (int i = 1; i < args.length; ++i) {
                if (i > 1) {
                    pw.print(", ");
                }
                args[i].unparse(pw);
            }
            pw.print(")");
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return (returnType == 0 ? "" : Syntax.getTypeDescription(returnType) + " ") + Syntax.getTypeDescription(argTypes[0]) + "." + name + "(" + Syntax.getTypeDescriptionCommaList(argTypes, 1) + ")";
        }
    };
    public static final Syntax Infix = new Syntax("Infix", 3){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (Syntax.needParen(args)) {
                ExpBase.unparseList(pw, args, "(", " " + fun + " ", ")");
            } else {
                ExpBase.unparseList(pw, args, "", " " + fun + " ", "");
            }
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return Syntax.getTypeDescription(argTypes[0]) + " " + name + " " + Syntax.getTypeDescription(argTypes[1]);
        }
    };
    public static final Syntax Prefix = new Syntax("Prefix", 4){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (Syntax.needParen(args)) {
                ExpBase.unparseList(pw, args, "(" + fun + " ", null, ")");
            } else {
                ExpBase.unparseList(pw, args, "" + fun + " ", null, "");
            }
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            return name + " " + Syntax.getTypeDescription(argTypes[0]);
        }
    };
    public static final Syntax Braces = new Syntax("Braces", 5){

        public String getSignature(String name, int returnType, int[] argTypes) {
            return "{" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + "}";
        }
    };
    public static final Syntax Parentheses = new Syntax("Parentheses", 6){

        public String getSignature(String name, int returnType, int[] argTypes) {
            return "(" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + ")";
        }
    };
    public static final Syntax Case = new Syntax("Case", 7){

        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            pw.print("CASE");
            int j = 0;
            if (fun.equals("_CaseTest")) {
                pw.print(" ");
                args[j++].unparse(pw);
            } else {
                Util.assertTrue(fun.equals("_CaseMatch"));
            }
            int clauseCount = (args.length - j) / 2;
            for (int i = 0; i < clauseCount; ++i) {
                pw.print(" WHEN ");
                args[j++].unparse(pw);
                pw.print(" THEN ");
                args[j++].unparse(pw);
            }
            if (j < args.length) {
                pw.print(" ELSE ");
                args[j++].unparse(pw);
            }
            Util.assertTrue(j == args.length);
            pw.print(" END");
        }

        public String getSignature(String name, int returnType, int[] argTypes) {
            String s = Syntax.getTypeDescription(argTypes[0]);
            if (argTypes[0] == 5) {
                return "CASE WHEN " + s + " THEN <Expression> ... END";
            }
            return "CASE " + s + " WHEN " + s + " THEN <Expression> ... END";
        }
    };
    public static final Syntax Internal = new Syntax("Internal", 8);
    public static final Syntax QuotedProperty = new Syntax("Quoted property", Syntax.Property.ordinal | 0x100);
    public static final Syntax AmpersandQuotedProperty = new Syntax("Ampersand-quoted property", Syntax.Property.ordinal | 0x200);
    private static final int mask = 255;
    public static final EnumeratedValues enumeration = new EnumeratedValues(new Syntax[]{Function, Property, Method, Infix, Prefix, Braces, Parentheses, Case, Internal});

    private Syntax(String name, int ordinal) {
        super(name, ordinal, null);
    }

    public static Syntax get(int ordinal) {
        return (Syntax)enumeration.getValue(ordinal & 0xFF);
    }

    public void unparse(String fun, Exp[] args, PrintWriter pw) {
        throw new UnsupportedOperationException();
    }

    public String getSignature(String name, int returnType, int[] argTypes) {
        return (returnType == 0 ? "" : Syntax.getTypeDescription(returnType) + " ") + name + "(" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + ")";
    }

    private static boolean needParen(Exp[] args) {
        return args.length != 1 || !(args[0] instanceof FunCall) || ((FunCall)args[0]).getSyntax() != Parentheses;
    }

    private static String getTypeDescription(int type) {
        return "<" + Category.instance.getDescription(type & 0x1F) + ">";
    }

    private static String getTypeDescriptionCommaList(int[] types, int start) {
        int initialSize = (types.length - start) * 16;
        StringBuffer sb = new StringBuffer(initialSize > 0 ? initialSize : 16);
        for (int i = start; i < types.length; ++i) {
            if (i > start) {
                sb.append(", ");
            }
            sb.append("<").append(Category.instance.getDescription(types[i] & 0x1F)).append(">");
        }
        return sb.toString();
    }
}

