/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;

public class PersistentElementHolder
extends AbstractPersistentCollection {
    private Element element;

    public PersistentElementHolder(SessionImplementor session, Element element) {
        super(session);
        this.element = element;
        this.setInitialized();
    }

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        List elements = this.element.elements(persister.getElementNodeName());
        ArrayList<Object> snapshot = new ArrayList<Object>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            Element elem = (Element)elements.get(i);
            Object value = elementType.fromXMLNode((Node)elem, persister.getFactory());
            Object copy = elementType.deepCopy(value, this.getSession().getEntityMode(), persister.getFactory());
            snapshot.add(copy);
        }
        return snapshot;
    }

    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        return CollectionHelper.EMPTY_COLLECTION;
    }

    public PersistentElementHolder(SessionImplementor session, CollectionPersister persister, Serializable key) throws HibernateException {
        super(session);
        Element owner = (Element)session.getPersistenceContext().getCollectionOwner(key, persister);
        if (owner == null) {
            throw new AssertionFailure("null owner");
        }
        String nodeName = persister.getNodeName();
        if (".".equals(nodeName)) {
            this.element = owner;
        } else {
            this.element = owner.element(nodeName);
            if (this.element == null) {
                this.element = owner.addElement(nodeName);
            }
        }
    }

    public boolean isWrapper(Object collection) {
        return this.element == collection;
    }

    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        ArrayList snapshot = (ArrayList)this.getSnapshot();
        List elements = this.element.elements(persister.getElementNodeName());
        if (snapshot.size() != elements.size()) {
            return false;
        }
        for (int i = 0; i < snapshot.size(); ++i) {
            Element elem;
            Object current;
            Object old = snapshot.get(i);
            if (!elementType.isDirty(old, current = elementType.fromXMLNode((Node)(elem = (Element)elements.get(i)), persister.getFactory()), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public boolean empty() {
        return !this.element.elementIterator().hasNext();
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, CollectionAliases descriptor, Object owner) throws HibernateException, SQLException {
        Object object = persister.readElement(rs, owner, descriptor.getSuffixedElementAliases(), this.getSession());
        Type elementType = persister.getElementType();
        Element subelement = this.element.addElement(persister.getElementNodeName());
        elementType.setToXMLNode((Node)subelement, object, persister.getFactory());
        return object;
    }

    public Iterator entries(CollectionPersister persister) {
        Type elementType = persister.getElementType();
        List elements = this.element.elements(persister.getElementNodeName());
        int length = elements.size();
        ArrayList<Object> result = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Element elem = (Element)elements.get(i);
            Object object = elementType.fromXMLNode((Node)elem, persister.getFactory());
            result.add(object);
        }
        return result.iterator();
    }

    public void beforeInitialize(CollectionPersister persister) {
    }

    public boolean isDirectlyAccessible() {
        return true;
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        Type elementType = persister.getElementType();
        Serializable[] cached = (Serializable[])disassembled;
        for (int i = 0; i < cached.length; ++i) {
            Object object = elementType.assemble(cached[i], this.getSession(), owner);
            Element subelement = this.element.addElement(persister.getElementNodeName());
            elementType.setToXMLNode((Node)subelement, object, persister.getFactory());
        }
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        List elements = this.element.elements(persister.getElementNodeName());
        int length = elements.size();
        Serializable[] result = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            Element elem = (Element)elements.get(i);
            Object object = elementType.fromXMLNode((Node)elem, persister.getFactory());
            result[i] = elementType.disassemble(object, this.getSession(), null);
        }
        return result;
    }

    public Object getValue() {
        return this.element;
    }

    public Iterator getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        Type elementType = persister.getElementType();
        ArrayList snapshot = (ArrayList)this.getSnapshot();
        List elements = this.element.elements(persister.getElementNodeName());
        ArrayList result = new ArrayList();
        for (int i = 0; i < snapshot.size(); ++i) {
            Object old = snapshot.get(i);
            if (i >= elements.size()) {
                result.add(old);
                continue;
            }
            Element elem = (Element)elements.get(i);
            Object object = elementType.fromXMLNode((Node)elem, persister.getFactory());
            if (!elementType.isDirty(old, object, this.getSession())) continue;
            result.add(old);
        }
        return result.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elementType) throws HibernateException {
        ArrayList snapshot = (ArrayList)this.getSnapshot();
        return i >= snapshot.size() || elementType.isDirty(snapshot.get(i), entry, this.getSession());
    }

    public boolean needsUpdating(Object entry, int i, Type elementType) throws HibernateException {
        return false;
    }

    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        throw new UnsupportedOperationException();
    }

    public Object getElement(Object entry) {
        return entry;
    }

    public Object getSnapshotElement(Object entry, int i) {
        throw new UnsupportedOperationException();
    }

    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }
}

