/*
 * ProgressBarCellRenderer.java
 *
 * Created on March 27, 2006, 8:39 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package it.businesslogic.ireport.plugin.locale;

import it.businesslogic.ireport.plugin.locale.ResourceKey;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 *
 * @author gtoffoli
 */
public class MissingResourceCellRenderer extends JLabel implements TableCellRenderer {
    
    /** Creates a new instance of ProgressBarCellRenderer */
    public MissingResourceCellRenderer() {
        super();
        
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        
        boolean isMissing = false;
        if (value instanceof ResourceKey)
        {
            ResourceKey rk = (ResourceKey)value;
            isMissing = rk.isMissing();            
        }
        if (!isSelected) {
            setForeground(((isMissing) ? Color.RED : table.getSelectionForeground()));
            setBackground(table.getSelectionBackground());
        } else {
            setForeground(((isMissing) ? Color.RED : table.getForeground()));
            setBackground(table.getBackground());
        }
        
        if (value == null) setText("");
        else setText(""+value);
        this.updateUI();
        return this;
    }
    
}
