/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.Util;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeSql;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.sql.SqlQuery;

public class RolapNativeFilter
extends RolapNativeSet {
    public RolapNativeFilter() {
        super.setEnabled(MondrianProperties.instance().EnableNativeFilter.get());
    }

    protected boolean isStrict() {
        return true;
    }

    /*
     * Loose catch block
     */
    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        RolapNativeSet.SetEvaluator setEvaluator;
        Connection con;
        block16: {
            String filterExpr;
            RolapSchemaReader schemaReader;
            RolapNativeSet.CrossJoinArg[] cargs;
            block14: {
                NativeEvaluator nativeEvaluator;
                block15: {
                    if (!this.isEnabled()) {
                        return null;
                    }
                    String funName = fun.getName();
                    if (!"Filter".equalsIgnoreCase(funName)) {
                        return null;
                    }
                    if (args.length != 2) {
                        return null;
                    }
                    cargs = this.checkCrossJoinArg(args[0]);
                    if (cargs == null) {
                        return null;
                    }
                    if (this.isPreferInterpreter(cargs)) {
                        return null;
                    }
                    schemaReader = (RolapSchemaReader)evaluator.getSchemaReader();
                    DataSource ds = schemaReader.getDataSource();
                    con = null;
                    con = ds.getConnection();
                    SqlQuery sqlQuery = SqlTupleReader.newQuery(con, "NativeFilter");
                    RolapNativeSql sql = new RolapNativeSql(sqlQuery);
                    filterExpr = sql.generateFilterCondition(args[1]);
                    if (filterExpr != null) break block14;
                    nativeEvaluator = null;
                    Object var15_15 = null;
                    if (con == null) break block15;
                    try {
                        con.close();
                    }
                    catch (SQLException e2) {
                        LOGGER.error(null, (Throwable)e2);
                    }
                }
                return nativeEvaluator;
            }
            LOGGER.info((Object)"using native filter");
            FilterConstraint constraint = new FilterConstraint(cargs, evaluator, filterExpr);
            setEvaluator = new RolapNativeSet.SetEvaluator(this, cargs, schemaReader, constraint);
            Object var15_16 = null;
            if (con == null) break block16;
            try {
                con.close();
            }
            catch (SQLException e2) {
                LOGGER.error(null, (Throwable)e2);
            }
        }
        return setEvaluator;
        catch (SQLException e) {
            try {
                throw Util.newInternal(e, "RolapNativeFilter");
            }
            catch (Throwable throwable) {
                block17: {
                    Object var15_17 = null;
                    if (con == null) break block17;
                    try {
                        con.close();
                    }
                    catch (SQLException e2) {
                        LOGGER.error(null, (Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
    }

    class FilterConstraint
    extends RolapNativeSet.SetConstraint {
        String filterExpr;

        public FilterConstraint(RolapNativeSet.CrossJoinArg[] args, RolapEvaluator evaluator, String filterByExpr) {
            super(args, evaluator, true);
            this.filterExpr = filterByExpr;
        }

        protected boolean isJoinRequired() {
            return true;
        }

        public void addConstraint(SqlQuery sqlQuery) {
            sqlQuery.addHaving(this.filterExpr);
            super.addConstraint(sqlQuery);
        }

        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            key.add(this.filterExpr);
            return key;
        }
    }
}

