/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.Cell;
import mondrian.olap.CellFormatter;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;

class RolapCell
implements Cell {
    private final RolapResult result;
    protected final Object value;
    private final int ordinal;

    RolapCell(RolapResult result, int ordinal, Object value) {
        this.result = result;
        this.value = value;
        this.ordinal = ordinal;
    }

    public Object getValue() {
        return this.value;
    }

    public String getFormattedValue() {
        RolapCube c;
        Dimension measuresDim;
        int[] pos = this.result.getCellPos(this.ordinal);
        Evaluator evaluator = this.result.getEvaluator(pos);
        Member m = evaluator.getContext(measuresDim = (c = (RolapCube)evaluator.getCube()).getMeasuresHierarchy().getDimension());
        CellFormatter cf = m instanceof RolapStoredMeasure ? ((RolapStoredMeasure)m).getFormatter() : null;
        return cf != null ? cf.formatCell(this.value) : evaluator.format(this.value);
    }

    public boolean isNull() {
        return this.value == Util.nullValue;
    }

    public boolean isError() {
        return this.value instanceof Throwable;
    }

    public String getDrillThroughSQL(boolean extendedContext) {
        AggregationManager aggMan = AggregationManager.instance();
        RolapEvaluator evaluator = this.getEvaluator();
        Member[] currentMembers = evaluator.getCurrentMembers();
        for (int i = 0; i < currentMembers.length; ++i) {
            Member member = currentMembers[i];
            RolapLevel level = (RolapLevel)member.getLevel();
            if (!level.hasClosedPeer()) continue;
            currentMembers[i] = member.getDataMember();
        }
        CellRequest cellRequest = RolapAggregationManager.makeRequest(currentMembers, extendedContext);
        return cellRequest == null ? null : ((RolapAggregationManager)aggMan).getDrillThroughSQL(cellRequest);
    }

    public boolean canDrillThrough() {
        Member[] currentMembers = this.getEvaluator().getCurrentMembers();
        return currentMembers[0] instanceof RolapStoredMeasure;
    }

    private RolapEvaluator getEvaluator() {
        int[] pos = this.result.getCellPos(this.ordinal);
        return this.result.getCellEvaluator(pos);
    }

    public Object getPropertyValue(String propertyName) {
        Property property = Property.lookup(propertyName);
        Integer defaultValue = null;
        if (property != null) {
            switch (property.ordinal) {
                case 32: {
                    return new Integer(this.ordinal);
                }
                case 41: {
                    return this.getValue();
                }
                case 38: {
                    return this.getEvaluator().getFormatString();
                }
                case 37: {
                    return this.getFormattedValue();
                }
                case 36: {
                    defaultValue = new Integer(0);
                    break;
                }
                case 40: {
                    defaultValue = new Integer(0);
                    break;
                }
            }
        }
        return this.getEvaluator().getProperty(propertyName, defaultValue);
    }

    public Member getContextMember(Dimension dimension) {
        return this.result.getMember(this.result.getCellPos(this.ordinal), dimension);
    }
}

