/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

class XtdFunDef
extends FunDefBase {
    private final LevelType levelType;

    public XtdFunDef(FunDef dummyFunDef, LevelType levelType) {
        super(dummyFunDef);
        this.levelType = levelType;
    }

    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 0) {
            Hierarchy hierarchy = validator.getQuery().getCube().getTimeDimension().getHierarchy();
            return new SetType(new MemberType(hierarchy, null, null));
        }
        Type type = args[0].getTypeX();
        if (type.getHierarchy().getDimension().getDimensionType() != DimensionType.TimeDimension) {
            throw MondrianResource.instance().TimeArgNeeded.ex(this.getName());
        }
        return super.getResultType(validator, args);
    }

    public boolean callDependsOn(FunCall call, Dimension dimension) {
        if (call.getArgCount() == 0) {
            Type type = call.getTypeX();
            return type.usesDimension(dimension);
        }
        return super.callDependsOn(call, dimension);
    }

    private Level getLevel(Evaluator evaluator) {
        switch (this.levelType.ordinal) {
            case 1: {
                return evaluator.getCube().getYearLevel();
            }
            case 2: {
                return evaluator.getCube().getQuarterLevel();
            }
            case 3: {
                return evaluator.getCube().getMonthLevel();
            }
            case 4: {
                return evaluator.getCube().getWeekLevel();
            }
            case 5: {
                return evaluator.getCube().getWeekLevel();
            }
        }
        throw this.levelType.unexpected();
    }

    public Object evaluate(Evaluator evaluator, Exp[] args) {
        return XtdFunDef.periodsToDate(evaluator, this.getLevel(evaluator), XtdFunDef.getMemberArg(evaluator, args, 0, false));
    }

    public static class Resolver
    extends MultiResolver {
        private final LevelType levelType;

        public Resolver(String name, String signature, String description, String[] signatures, LevelType levelType) {
            super(name, signature, description, signatures);
            this.levelType = levelType;
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new XtdFunDef(dummyFunDef, this.levelType);
        }
    }
}

