/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import net.sf.jasperreports.compilers.JRGroovyCompiler;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRJavacCompiler;
import net.sf.jasperreports.engine.design.JRJdk12Compiler;
import net.sf.jasperreports.engine.design.JRJdk13Compiler;
import net.sf.jasperreports.engine.design.JRJdtCompiler;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRProperties;

public final class JRDefaultCompiler
implements JRCompiler {
    private static final JRDefaultCompiler instance = new JRDefaultCompiler();
    static /* synthetic */ Class class$net$sf$jasperreports$engine$design$JRDefaultCompiler;

    private JRDefaultCompiler() {
    }

    public static JRDefaultCompiler getInstance() {
        return instance;
    }

    public JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        JRCompiler jrCompiler = null;
        String compiler = JRProperties.getProperty("net.sf.jasperreports.compiler.class");
        if (compiler == null || compiler.trim().length() == 0) {
            jrCompiler = "groovy".equals(jasperDesign.getLanguage()) ? new JRGroovyCompiler() : JRDefaultCompiler.getJavaCompiler();
        } else {
            try {
                Class clazz = JRClassLoader.loadClassForName(compiler);
                jrCompiler = (JRCompiler)clazz.newInstance();
            }
            catch (Exception e) {
                throw new JRException("Could not instantiate report compiler : " + compiler, e);
            }
        }
        return jrCompiler.compileReport(jasperDesign);
    }

    private static JRCompiler getJavaCompiler() {
        JRAbstractJavaCompiler compiler = null;
        try {
            JRClassLoader.loadClassForName("org.eclipse.jdt.internal.compiler.Compiler");
            compiler = new JRJdtCompiler();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (compiler == null) {
            try {
                JRClassLoader.loadClassForName("com.sun.tools.javac.Main");
                compiler = new JRJdk13Compiler();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (compiler == null) {
            try {
                JRClassLoader.loadClassForName("sun.tools.javac.Main");
                compiler = new JRJdk12Compiler();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (compiler == null) {
            compiler = new JRJavacCompiler();
        }
        return compiler;
    }

    private static JRCompiler getCompiler(JasperReport jasperReport) throws JRException {
        JRCompiler compiler = null;
        String compilerClassName = jasperReport.getCompilerClass();
        Class<?> compilerClass = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                compilerClass = classLoader.loadClass(compilerClassName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (compilerClass == null) {
            classLoader = (class$net$sf$jasperreports$engine$design$JRDefaultCompiler == null ? (class$net$sf$jasperreports$engine$design$JRDefaultCompiler = JRDefaultCompiler.class$("net.sf.jasperreports.engine.design.JRDefaultCompiler")) : class$net$sf$jasperreports$engine$design$JRDefaultCompiler).getClassLoader();
            try {
                compilerClass = classLoader == null ? Class.forName(compilerClassName) : classLoader.loadClass(compilerClassName);
            }
            catch (ClassNotFoundException e) {
                throw new JRException("Report compiler class not found : " + compilerClassName);
            }
        }
        try {
            compiler = (JRCompiler)compilerClass.newInstance();
        }
        catch (Exception e) {
            throw new JRException("Could not instantiate report compiler : " + compilerClassName, e);
        }
        return compiler;
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport, JRDataset dataset) throws JRException {
        JRCompiler compiler = JRDefaultCompiler.getCompiler(jasperReport);
        return compiler.loadEvaluator(jasperReport, dataset);
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport, JRCrosstab crosstab) throws JRException {
        JRCompiler compiler = JRDefaultCompiler.getCompiler(jasperReport);
        return compiler.loadEvaluator(jasperReport, crosstab);
    }

    public JREvaluator loadEvaluator(JasperReport jasperReport) throws JRException {
        return this.loadEvaluator(jasperReport, jasperReport.getMainDataset());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

