/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.editors;

import java.awt.BorderLayout;
import net.charabia.jsmoothgen.application.JavaPropertyPair;
import net.charabia.jsmoothgen.application.gui.Editor;
import net.charabia.jsmoothgen.application.gui.util.PropertyEditorDialog;
import net.charabia.jsmoothgen.application.gui.util.SortedEditableList;

public class JavaProperties
extends Editor {
    private SortedEditableList m_props = new SortedEditableList();

    public JavaProperties() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.m_props);
        this.m_props.setEditor(new PropEditor());
    }

    public void dataChanged() {
        Object[] props = this.m_model.getJavaProperties();
        this.m_props.setData(props);
    }

    public void updateModel() {
        Object[] po = this.m_props.getData();
        JavaPropertyPair[] props = new JavaPropertyPair[po.length];
        for (int i = 0; i < po.length; ++i) {
            props[i] = (JavaPropertyPair)po[i];
        }
        this.m_model.setJavaProperties(props);
    }

    public String getLabel() {
        return "JAVAPROP_LABEL";
    }

    public String getDescription() {
        return "JAVAPROP_HELP";
    }

    public class PropEditor
    implements SortedEditableList.Editor {
        public Object createNewItem(SortedEditableList selist) {
            JavaPropertyPair jpp = new JavaPropertyPair("", "");
            PropertyEditorDialog dia = new PropertyEditorDialog(jpp);
            if (dia.ask() && jpp.getName().trim().length() > 0) {
                return jpp;
            }
            return null;
        }

        public Object editItem(SortedEditableList selist, Object item) {
            JavaPropertyPair jpp = (JavaPropertyPair)item;
            PropertyEditorDialog dia = new PropertyEditorDialog(jpp);
            dia.show();
            return item;
        }

        public boolean removeItem(SortedEditableList selist, Object item) {
            return true;
        }
    }
}

