/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class IntelligentLineBorder
implements Border {
    private Color color;
    private boolean isHidingEdges;

    public IntelligentLineBorder() {
        this(Color.BLACK);
    }

    public IntelligentLineBorder(Color color) {
        this(color, true);
    }

    public IntelligentLineBorder(boolean isHidingEdges) {
        this(Color.BLACK, isHidingEdges);
    }

    public IntelligentLineBorder(Color color, boolean isHidingEdges) {
        this.color = color;
        this.isHidingEdges = isHidingEdges;
    }

    public Insets getBorderInsets(Component c) {
        int left = !this.isTouchingLeftEdge(c) ? 1 : 0;
        int right = !this.isTouchingRightEdge(c) ? 1 : 0;
        int top = !this.isTouchingTopEdge(c) ? 1 : 0;
        int bottom = !this.isTouchingBottomEdge(c) ? 1 : 0;
        return new Insets(top, left, bottom, right);
    }

    protected boolean isTouchingLeftEdge(Component c) {
        if (!this.isHidingEdges) {
            return false;
        }
        Component parent = this.getParent(c);
        if (parent == null) {
            return false;
        }
        return c.getX() == c.getParent().getInsets().left;
    }

    protected boolean isTouchingTopEdge(Component c) {
        if (!this.isHidingEdges) {
            return false;
        }
        Component parent = this.getParent(c);
        if (parent == null) {
            return false;
        }
        return c.getY() == c.getParent().getInsets().top;
    }

    protected boolean isTouchingRightEdge(Component c) {
        if (!this.isHidingEdges) {
            return false;
        }
        Component parent = this.getParent(c);
        if (parent == null) {
            return false;
        }
        return c.getX() + c.getWidth() == c.getParent().getWidth() - c.getParent().getInsets().right;
    }

    protected boolean isTouchingBottomEdge(Component c) {
        if (!this.isHidingEdges) {
            return false;
        }
        Component parent = this.getParent(c);
        if (parent == null) {
            return false;
        }
        return c.getY() + c.getHeight() == c.getParent().getHeight() - c.getParent().getInsets().bottom;
    }

    protected Component getParent(Component c) {
        Container parent = c.getParent();
        while (parent != null && parent != c) {
            Border border;
            if (parent instanceof JComponent && (border = ((JComponent)parent).getBorder()) != null) {
                return parent;
            }
            Container newParent = parent.getParent();
            if (newParent == null) {
                return parent;
            }
            parent = newParent;
        }
        return null;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.color);
        if (!this.isTouchingLeftEdge(c)) {
            g.drawLine(x, y, x, y + height);
        }
        if (!this.isTouchingTopEdge(c)) {
            g.drawLine(x, y, x + width, y);
        }
        if (!this.isTouchingRightEdge(c)) {
            g.drawLine(x + width - 1, y, x + width - 1, y + height);
        }
        if (!this.isTouchingBottomEdge(c)) {
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
        }
    }
}

