/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRProperties;

public class JRQueryExecuterUtils {
    private static final Map factoryCache = new HashMap();

    public static JRQueryExecuterFactory getQueryExecuterFactory(String language) throws JRException {
        String factoryClassName = JRProperties.getProperty("net.sf.jasperreports.query.executer.factory." + language);
        if (factoryClassName == null) {
            throw new JRException("No query executer factory class registered for " + language + " queries.  " + "Create a propery named " + "net.sf.jasperreports.query.executer.factory." + language + ".");
        }
        JRQueryExecuterFactory queryExecuterFactory = JRQueryExecuterUtils.getCachedFactory(factoryClassName);
        if (queryExecuterFactory == null) {
            try {
                Class queryExecuterFactoryClass = JRClassLoader.loadClassForName(factoryClassName);
                queryExecuterFactory = (JRQueryExecuterFactory)queryExecuterFactoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new JRException("Query executer factory class " + factoryClassName + " not found.", e);
            }
            catch (InstantiationException e) {
                throw new JRException("Error instantiating query executer factory " + factoryClassName + ".", e);
            }
            catch (IllegalAccessException e) {
                throw new JRException("Error instantiating query executer factory " + factoryClassName + ".", e);
            }
            JRQueryExecuterUtils.cacheFactory(factoryClassName, queryExecuterFactory);
        }
        return queryExecuterFactory;
    }

    private static synchronized JRQueryExecuterFactory getCachedFactory(String factoryClassName) {
        return (JRQueryExecuterFactory)factoryCache.get(factoryClassName);
    }

    private static synchronized void cacheFactory(String factoryClassName, JRQueryExecuterFactory queryExecuterFactory) {
        factoryCache.put(factoryClassName, queryExecuterFactory);
    }
}

