/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MissingMethodException;
import groovy.lang.Range;
import groovy.lang.Tuple;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.IteratorClosureAdapter;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.RegexSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Invoker {
    protected static final Object[] EMPTY_ARGUMENTS = new Object[0];
    protected static final Class[] EMPTY_TYPES = new Class[0];
    private MetaClassRegistry metaRegistry = new MetaClassRegistry();

    public MetaClassRegistry getMetaRegistry() {
        return this.metaRegistry;
    }

    public MetaClass getMetaClass(Object object) {
        return this.metaRegistry.getMetaClass(object.getClass());
    }

    public Object invokeMethod(Object object, String methodName, Object arguments) {
        if (object == null) {
            throw new NullPointerException("Cannot invoke method: " + methodName + " on null object");
        }
        if (object instanceof Class) {
            Class theClass = (Class)object;
            MetaClass metaClass = this.metaRegistry.getMetaClass(theClass);
            return metaClass.invokeStaticMethod(object, methodName, this.asArray(arguments));
        }
        if (!(object instanceof GroovyObject)) {
            Class<?> theClass = object.getClass();
            MetaClass metaClass = this.metaRegistry.getMetaClass(theClass);
            return metaClass.invokeMethod(object, methodName, this.asArray(arguments));
        }
        if (object instanceof Closure) {
            Closure closure = (Closure)object;
            return closure.invokeMethod(methodName, arguments);
        }
        GroovyObject groovy = (GroovyObject)object;
        try {
            return groovy.getMetaClass().invokeMethod(object, methodName, arguments);
        }
        catch (MissingMethodException e) {
            if (e.getMethod().equals(methodName) && object.getClass() == e.getType()) {
                return groovy.invokeMethod(methodName, arguments);
            }
            throw e;
        }
    }

    public Object invokeSuperMethod(Object object, String methodName, Object arguments) {
        if (object == null) {
            throw new NullPointerException("Cannot invoke method: " + methodName + " on null object");
        }
        Class<?> theClass = object.getClass();
        MetaClass metaClass = this.metaRegistry.getMetaClass(theClass.getSuperclass());
        return metaClass.invokeMethod(object, methodName, this.asArray(arguments));
    }

    public Object invokeStaticMethod(String type, String method, Object arguments) {
        MetaClass metaClass = this.metaRegistry.getMetaClass(this.loadClass(type));
        List argumentList = this.asList(arguments);
        return metaClass.invokeStaticMethod(null, method, this.asArray(arguments));
    }

    public Object invokeConstructor(String type, Object arguments) {
        return this.invokeConstructorOf(this.loadClass(type), arguments);
    }

    public Object invokeConstructorOf(Class type, Object arguments) {
        MetaClass metaClass = this.metaRegistry.getMetaClass(type);
        return metaClass.invokeConstructor(this.asArray(arguments));
    }

    public Object[] asArray(Object arguments) {
        if (arguments == null) {
            return EMPTY_ARGUMENTS;
        }
        if (arguments instanceof Tuple) {
            Tuple tuple = (Tuple)arguments;
            return tuple.toArray();
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }

    public List asList(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value.getClass().isArray()) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof Enumeration) {
            ArrayList answer = new ArrayList();
            Enumeration e = (Enumeration)value;
            while (e.hasMoreElements()) {
                answer.add(e.nextElement());
            }
            return answer;
        }
        return Collections.singletonList(value);
    }

    public Collection asCollection(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.entrySet();
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return InvokerHelper.primitiveArrayToList(value);
            }
            return Arrays.asList((Object[])value);
        }
        if (value instanceof MethodClosure) {
            MethodClosure method = (MethodClosure)value;
            IteratorClosureAdapter adapter = new IteratorClosureAdapter(method.getDelegate());
            method.call(adapter);
            return adapter.asList();
        }
        if (value instanceof String) {
            return DefaultGroovyMethods.toList((String)value);
        }
        if (value instanceof File) {
            try {
                return DefaultGroovyMethods.readLines((File)value);
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("Error reading file: " + value, e);
            }
        }
        return Collections.singletonList(value);
    }

    public Iterator asIterator(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (value instanceof Iterator) {
            return (Iterator)value;
        }
        if (value instanceof NodeList) {
            final NodeList nodeList = (NodeList)value;
            return new Iterator(){
                private int current = 0;

                public boolean hasNext() {
                    return this.current < nodeList.getLength();
                }

                public Object next() {
                    Node node = nodeList.item(this.current++);
                    return node;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove() from an Enumeration");
                }
            };
        }
        if (value instanceof Enumeration) {
            final Enumeration enumeration = (Enumeration)value;
            return new Iterator(){
                private Object last;

                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                public Object next() {
                    this.last = enumeration.nextElement();
                    return this.last;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove() from an Enumeration");
                }
            };
        }
        if (value instanceof Matcher) {
            final Matcher matcher = (Matcher)value;
            return new Iterator(){
                private boolean found = false;
                private boolean done = false;

                public boolean hasNext() {
                    if (this.done) {
                        return false;
                    }
                    if (!this.found) {
                        this.found = matcher.find();
                        if (!this.found) {
                            this.done = true;
                        }
                    }
                    return this.found;
                }

                public Object next() {
                    if (!this.found && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.found = false;
                    return matcher.group();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        try {
            final Method method = value.getClass().getMethod("iterator", EMPTY_TYPES);
            if (method != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        method.setAccessible(true);
                        return null;
                    }
                });
                return (Iterator)method.invoke(value, EMPTY_ARGUMENTS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.asCollection(value).iterator();
    }

    public boolean objectsEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left != null) {
            if (right == null) {
                return false;
            }
            if (left instanceof Comparable) {
                return this.compareTo(left, right) == 0;
            }
            return left.equals(right);
        }
        return false;
    }

    public String inspect(Object self) {
        return this.format(self, true);
    }

    public int compareTo(Object left, Object right) {
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left instanceof Comparable) {
            if (left instanceof Number) {
                if (this.isValidCharacterString(right)) {
                    return this.asCharacter((Number)left).compareTo(this.asCharacter((String)right));
                }
                return DefaultGroovyMethods.compareTo((Number)left, this.asNumber(right));
            }
            if (left instanceof Character) {
                if (this.isValidCharacterString(right)) {
                    return ((Character)left).compareTo(this.asCharacter((String)right));
                }
                if (right instanceof Number) {
                    return ((Character)left).compareTo(this.asCharacter((Number)right));
                }
            } else {
                if (right instanceof Number) {
                    if (this.isValidCharacterString(left)) {
                        return this.asCharacter((String)left).compareTo(this.asCharacter((Number)right));
                    }
                    return DefaultGroovyMethods.compareTo(this.asNumber(left), (Number)right);
                }
                if (left instanceof String && right instanceof Character) {
                    return ((String)left).compareTo(right.toString());
                }
            }
            Comparable comparable = (Comparable)left;
            return comparable.compareTo(right);
        }
        if (left.getClass().isArray()) {
            Collection leftList = this.asCollection(left);
            if (right.getClass().isArray()) {
                right = this.asCollection(right);
            }
            return ((Comparable)((Object)leftList)).compareTo(right);
        }
        throw new GroovyRuntimeException("Cannot compare values: " + left + " and " + right);
    }

    public String toString(Object arguments) {
        return this.format(arguments, false);
    }

    public String toTypeString(Object[] arguments) {
        if (arguments == null) {
            return "null";
        }
        StringBuffer argBuf = new StringBuffer();
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                argBuf.append(", ");
            }
            argBuf.append(arguments[i] != null ? arguments[i].getClass().getName() : "null");
        }
        return argBuf.toString();
    }

    protected String format(Object arguments, boolean verbose) {
        if (arguments == null) {
            return "null";
        }
        if (arguments.getClass().isArray()) {
            return this.format(this.asCollection(arguments), verbose);
        }
        if (arguments instanceof Range) {
            Range range = (Range)arguments;
            if (verbose) {
                return range.inspect();
            }
            return range.toString();
        }
        if (arguments instanceof List) {
            List list = (List)arguments;
            StringBuffer buffer = new StringBuffer("[");
            boolean first = true;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(this.format(iter.next(), verbose));
            }
            buffer.append("]");
            return buffer.toString();
        }
        if (arguments instanceof Map) {
            Map map = (Map)arguments;
            if (map.isEmpty()) {
                return "[:]";
            }
            StringBuffer buffer = new StringBuffer("[");
            boolean first = true;
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                Map.Entry entry = iter.next();
                buffer.append(this.format(entry.getKey(), verbose));
                buffer.append(":");
                buffer.append(this.format(entry.getValue(), verbose));
            }
            buffer.append("]");
            return buffer.toString();
        }
        if (arguments instanceof Element) {
            Element node = (Element)arguments;
            OutputFormat format = new OutputFormat(node.getOwnerDocument());
            format.setOmitXMLDeclaration(true);
            format.setIndenting(true);
            format.setLineWidth(0);
            format.setPreserveSpace(true);
            StringWriter sw = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Writer)sw, format);
            try {
                serializer.asDOMSerializer();
                serializer.serialize(node);
            }
            catch (IOException e) {
                // empty catch block
            }
            return sw.toString();
        }
        if (arguments instanceof String) {
            if (verbose) {
                return "\"" + arguments + "\"";
            }
            return (String)arguments;
        }
        return arguments.toString();
    }

    public Object getProperty(Object object, String property) {
        if (object == null) {
            throw new NullPointerException("Cannot get property: " + property + " on null object");
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            return pogo.getProperty(property);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.get(property);
        }
        return this.metaRegistry.getMetaClass(object.getClass()).getProperty(object, property);
    }

    public void setProperty(Object object, String property, Object newValue) {
        if (object == null) {
            throw new GroovyRuntimeException("Cannot set property on null object");
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            pogo.setProperty(property, newValue);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            map.put(property, newValue);
        } else {
            this.metaRegistry.getMetaClass(object.getClass()).setProperty(object, property, newValue);
        }
    }

    public Object getAttribute(Object object, String attribute) {
        if (object == null) {
            throw new NullPointerException("Cannot get attribute: " + attribute + " on null object");
        }
        return this.metaRegistry.getMetaClass(object.getClass()).getAttribute(object, attribute);
    }

    public void setAttribute(Object object, String attribute, Object newValue) {
        if (object == null) {
            throw new GroovyRuntimeException("Cannot set attribute on null object");
        }
        this.metaRegistry.getMetaClass(object.getClass()).setAttribute(object, attribute, newValue);
    }

    protected Class loadClass(String type) {
        try {
            return this.getClass().getClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(type);
            }
            catch (ClassNotFoundException e2) {
                try {
                    return Class.forName(type);
                }
                catch (ClassNotFoundException e3) {
                    throw new GroovyRuntimeException("Could not load type: " + type, e);
                }
            }
        }
    }

    public Matcher objectFindRegex(Object left, Object right) {
        String regexToCompareTo;
        String stringToCompare = left instanceof String ? (String)left : this.toString(left);
        if (right instanceof String) {
            regexToCompareTo = (String)right;
        } else {
            if (right instanceof Pattern) {
                Pattern pattern = (Pattern)right;
                return pattern.matcher(stringToCompare);
            }
            regexToCompareTo = this.toString(right);
        }
        Matcher matcher = Pattern.compile(regexToCompareTo).matcher(stringToCompare);
        return matcher;
    }

    public boolean objectMatchRegex(Object left, Object right) {
        Pattern pattern = right instanceof Pattern ? (Pattern)right : Pattern.compile(this.toString(right));
        String stringToCompare = this.toString(left);
        Matcher matcher = pattern.matcher(stringToCompare);
        RegexSupport.setLastMatcher(matcher);
        return matcher.matches();
    }

    public Pattern regexPattern(Object regex) {
        return Pattern.compile(regex.toString());
    }

    public Object asType(Object object, Class type) {
        if (object == null) {
            return null;
        }
        if (type.isArray()) {
            return this.asArray(object, type);
        }
        if (type.isInstance(object)) {
            return object;
        }
        if (type.isAssignableFrom(Collection.class) && object.getClass().isArray()) {
            Collection answer = null;
            try {
                answer = (Collection)type.newInstance();
            }
            catch (Exception e) {
                throw new ClassCastException("Could not instantiate instance of: " + type.getName() + ". Reason: " + e);
            }
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(object, i);
                answer.add(element);
            }
            return answer;
        }
        if (type.equals(String.class)) {
            return object.toString();
        }
        if (type.equals(Character.class)) {
            if (object instanceof Number) {
                return this.asCharacter((Number)object);
            }
            String text = object.toString();
            if (text.length() == 1) {
                return new Character(text.charAt(0));
            }
            throw new ClassCastException("Cannot cast: " + text + " to a Character");
        }
        if (Number.class.isAssignableFrom(type)) {
            if (object instanceof Character) {
                return new Integer(((Character)object).charValue());
            }
            if (object instanceof String) {
                String c = (String)object;
                if (c.length() == 1) {
                    return new Integer(c.charAt(0));
                }
                throw new ClassCastException("Cannot cast: '" + c + "' to an Integer");
            }
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            if (type.isPrimitive()) {
                if (type == Byte.TYPE) {
                    return new Byte(n.byteValue());
                }
                if (type == Character.TYPE) {
                    return new Character((char)n.intValue());
                }
                if (type == Short.TYPE) {
                    return new Short(n.shortValue());
                }
                if (type == Integer.TYPE) {
                    return new Integer(n.intValue());
                }
                if (type == Long.TYPE) {
                    return new Long(n.longValue());
                }
                if (type == Float.TYPE) {
                    return new Float(n.floatValue());
                }
                if (type == Double.TYPE) {
                    Double answer = new Double(n.doubleValue());
                    if (!(n instanceof Double || answer != Double.NEGATIVE_INFINITY && answer != Double.POSITIVE_INFINITY)) {
                        throw new GroovyRuntimeException("Automatic coercion of " + n.getClass().getName() + " value " + n + " to double failed.  Value is out of range.");
                    }
                    return answer;
                }
            } else if (Number.class.isAssignableFrom(type)) {
                if (type == Byte.class) {
                    return new Byte(n.byteValue());
                }
                if (type == Character.class) {
                    return new Character((char)n.intValue());
                }
                if (type == Short.class) {
                    return new Short(n.shortValue());
                }
                if (type == Integer.class) {
                    return new Integer(n.intValue());
                }
                if (type == Long.class) {
                    return new Long(n.longValue());
                }
                if (type == Float.class) {
                    return new Float(n.floatValue());
                }
                if (type == Double.class) {
                    Double answer = new Double(n.doubleValue());
                    if (!(n instanceof Double || answer != Double.NEGATIVE_INFINITY && answer != Double.POSITIVE_INFINITY)) {
                        throw new GroovyRuntimeException("Automatic coercion of " + n.getClass().getName() + " value " + n + " to double failed.  Value is out of range.");
                    }
                    return answer;
                }
            }
        }
        if (type == Boolean.class) {
            return this.asBool(object) ? Boolean.TRUE : Boolean.FALSE;
        }
        return object;
    }

    public Object asArray(Object object, Class type) {
        Collection list = this.asCollection(object);
        int size = list.size();
        Class<?> elementType = type.getComponentType();
        Object array = Array.newInstance(elementType, size);
        int idx = 0;
        if (Boolean.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setBoolean(array, idx, this.asBool(element));
                ++idx;
            }
        } else if (Byte.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setByte(array, idx, this.asByte(element));
                ++idx;
            }
        } else if (Character.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setChar(array, idx, this.asChar(element));
                ++idx;
            }
        } else if (Double.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setDouble(array, idx, this.asDouble(element));
                ++idx;
            }
        } else if (Float.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setFloat(array, idx, this.asFloat(element));
                ++idx;
            }
        } else if (Integer.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setInt(array, idx, this.asInt(element));
                ++idx;
            }
        } else if (Long.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setLong(array, idx, this.asLong(element));
                ++idx;
            }
        } else if (Short.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setShort(array, idx, this.asShort(element));
                ++idx;
            }
        } else {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Object coercedElement = this.asType(element, elementType);
                Array.set(array, idx, coercedElement);
                ++idx;
            }
        }
        return array;
    }

    public Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.length() == 1) {
                return new Integer(s.charAt(0));
            }
            return new BigDecimal(s);
        }
        if (value instanceof Character) {
            return new Integer(((Character)value).charValue());
        }
        throw new GroovyRuntimeException("Could not convert object: " + value + " into a Number");
    }

    public byte asByte(Object element) {
        return this.asNumber(element).byteValue();
    }

    public char asChar(Object element) {
        if (element instanceof String) {
            return this.asCharacter((String)element).charValue();
        }
        return this.asCharacter(this.asNumber(element)).charValue();
    }

    public float asFloat(Object element) {
        return this.asNumber(element).floatValue();
    }

    public double asDouble(Object element) {
        return this.asNumber(element).doubleValue();
    }

    public short asShort(Object element) {
        return this.asNumber(element).shortValue();
    }

    public int asInt(Object element) {
        return this.asNumber(element).intValue();
    }

    public long asLong(Object element) {
        return this.asNumber(element).longValue();
    }

    public boolean asBool(Object object) {
        if (object instanceof Boolean) {
            Boolean booleanValue = (Boolean)object;
            return booleanValue;
        }
        if (object instanceof Matcher) {
            Matcher matcher = (Matcher)object;
            RegexSupport.setLastMatcher(matcher);
            return matcher.find();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return !collection.isEmpty();
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            return n.doubleValue() != 0.0;
        }
        return object != null;
    }

    protected Character asCharacter(Number value) {
        return new Character((char)value.intValue());
    }

    protected Character asCharacter(String text) {
        return new Character(text.charAt(0));
    }

    protected boolean isValidCharacterString(Object value) {
        String s;
        return value instanceof String && (s = (String)value).length() == 1;
    }

    public void removeMetaClass(Class clazz) {
        this.getMetaRegistry().removeMetaClass(clazz);
    }
}

