/*
 * ComboBoxSheetProperty.java
 *
 * Created on 16 febbraio 2005, 19.13
 */

package it.businesslogic.ireport.gui.sheet;

import java.util.*;
import javax.swing.*;
import it.businesslogic.ireport.util.*;

public class FontSheetProperty extends SheetProperty {
    
    private FontSheetPropertyComponent editor = null;
    
    public FontSheetProperty(String key, String name) {
        super( key, name, SheetProperty.STRING, "");
    }
    
    public JComponent getEditor()
    {
        if (editor != null) return editor;
        editor = new FontSheetPropertyComponent();
        editor.addActionListener( this );
        return editor;
    }
    
    public Object getEditorValue(JComponent component)
    {
        return editor.getIreportFont();
    }
    
    public void setEditorValue(JComponent component, Object value)
    {
        try {
            getEditor(); // In this way we are sure that editor is not null.
            editor.setIreportFont((it.businesslogic.ireport.IReportFont)value);
        } catch (Exception ex) {}
    }
    
    public void setFontMode( int mode)
    {
        try {
            getEditor(); // In this way we are sure that editor is not null.
            editor.setFontMode( mode );
        } catch (Exception ex) {}
    }
}