/*
 * CrosstabMeasuresView.java
 *
 * Created on January 24, 2006, 10:42 AM
 */

package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.CrosstabParameter;
import it.businesslogic.ireport.crosstab.Measure;
import it.businesslogic.ireport.gui.event.CrosstabLayoutChangedEvent;
import it.businesslogic.ireport.gui.library.LibraryTreeCellRenderer;
import it.businesslogic.ireport.gui.library.TreeTransfertHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

/**
 *
 * @author  gtoffoli
 */
public class CrosstabMeasuresView extends javax.swing.JPanel implements it.businesslogic.ireport.gui.event.CrosstabLayoutChangedListener {
    
    
    private CrosstabReportElement crosstabReportElement = null;
    
    
    /** Creates new form CrosstabMeasuresView */
    public CrosstabMeasuresView() {
        initComponents();
        
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("measures");
        
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        
        jTree.setModel( dtm );
        jTree.setDragEnabled(true);
        jTree.setRootVisible( false );
        jTree.setTransferHandler(new TreeTransfertHandler());
        jTree.setCellRenderer( new LibraryTreeCellRenderer() );
        jTree.expandPath( new TreePath(root));
        
    }

    public CrosstabReportElement getCrosstabReportElement() {
        return crosstabReportElement;
    }

    public void setCrosstabReportElement(CrosstabReportElement crosstabReportElement) {
        
        // Stop to listen to the old crosstab (if not null)
        if (this.crosstabReportElement != null && this.crosstabReportElement != crosstabReportElement)
        {
            this.crosstabReportElement.removeCrosstabLayoutChangedListener( this );
        }
        
        // Start to listen to the new crosstab (if not null)
        if (crosstabReportElement != null && this.crosstabReportElement != crosstabReportElement)
        {
            crosstabReportElement.addCrosstabLayoutChangedListener( this );
        }
        
        this.crosstabReportElement = crosstabReportElement;
        
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)jTree.getModel().getRoot();
        root.removeAllChildren();
        
        if (crosstabReportElement != null)
            {
            
            
            for (int i=0; i<crosstabReportElement.getRowGroups().size(); ++i)
            {
                CrosstabGroup group = (CrosstabGroup)crosstabReportElement.getRowGroups().elementAt(i);
                root.add(new DefaultMutableTreeNode( group ));
            }
            
            for (int i=0; i<crosstabReportElement.getColumnGroups().size(); ++i)
            {
                CrosstabGroup group = (CrosstabGroup)crosstabReportElement.getColumnGroups().elementAt(i);
                root.add(new DefaultMutableTreeNode( group ));
            }
            
            for (int i=0; i<crosstabReportElement.getMeasures().size(); ++i)
            {
                Measure measure = (Measure)crosstabReportElement.getMeasures().elementAt(i);
                root.add(new DefaultMutableTreeNode( measure ));
            }
            
            for (int i=0; i<crosstabReportElement.getCrosstabParameters().size(); ++i)
            {
                CrosstabParameter parameter = (CrosstabParameter)crosstabReportElement.getCrosstabParameters().elementAt(i);
                root.add(new DefaultMutableTreeNode( parameter ));
            }
            
        }
        
        jTree.expandPath( new TreePath(root));
        jTree.updateUI();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jScrollPane1 = new javax.swing.JScrollPane();
        jTree = new javax.swing.JTree();

        setLayout(new java.awt.BorderLayout());

        jScrollPane1.setViewportView(jTree);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents

    public void crosstabLayoutChanged(CrosstabLayoutChangedEvent evt) {
        setCrosstabReportElement(crosstabReportElement);
    }

    public void crosstabMeasureChanged(CrosstabLayoutChangedEvent evt) {
        setCrosstabReportElement(crosstabReportElement);
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTree jTree;
    // End of variables declaration//GEN-END:variables
    
}
