/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyButtonUI;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class TinySpinnerButtonUI
extends TinyButtonUI {
    private int orientation;
    protected static Dimension size = new Dimension(15, 8);

    public static ComponentUI createUI(JComponent c) {
        throw new IllegalStateException("Must not be used this way.");
    }

    TinySpinnerButtonUI(int type) {
        this.orientation = type;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        if (!button.isEnabled()) {
            g.setColor(Theme.spinnerButtDisabledColor[Theme.style].getColor());
        } else if (button.getModel().isPressed()) {
            g.setColor(Theme.spinnerButtPressedColor[Theme.style].getColor());
        } else if (button.getModel().isRollover() && Theme.spinnerRollover[Theme.style]) {
            g.setColor(Theme.spinnerButtRolloverColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.spinnerButtColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyButton(g, button);
                break;
            }
            case 1: {
                this.drawWinButton(g, button);
                break;
            }
            case 2: {
                this.drawXpButton(g, button);
            }
        }
        if (!button.isEnabled()) {
            g.setColor(Theme.spinnerArrowDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.spinnerArrowColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyArrow(g, button);
                break;
            }
            case 1: {
                this.drawWinArrow(g, button);
                break;
            }
            case 2: {
                this.drawXpArrow(g, button);
            }
        }
    }

    private void drawTinyButton(Graphics g, AbstractButton b) {
    }

    private void drawWinButton(Graphics g, AbstractButton b) {
        int x2 = TinySpinnerButtonUI.size.width - 1;
        int y2 = TinySpinnerButtonUI.size.height - 1;
        g.fillRect(2, 2, 11, 4);
        if (!b.isEnabled()) {
            g.setColor(Theme.spinnerLightDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.spinnerLightColor[Theme.style].getColor());
        }
        if (b.getModel().isPressed()) {
            g.drawLine(0, y2, x2, y2);
            g.drawLine(x2, 0, x2, y2);
        } else {
            g.drawLine(1, 1, x2 - 2, 1);
            g.drawLine(1, 2, 1, y2 - 2);
        }
        g.setColor(Theme.backColor[Theme.style].getColor());
        if (b.getModel().isPressed()) {
            g.drawLine(1, y2 - 1, x2 - 1, y2 - 1);
            g.drawLine(x2 - 1, 1, x2 - 1, y2 - 2);
        } else {
            g.drawLine(0, 0, x2 - 1, 0);
            g.drawLine(0, 1, 0, y2 - 1);
        }
        if (!b.isEnabled()) {
            g.setColor(Theme.spinnerDarkDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.spinnerDarkColor[Theme.style].getColor());
        }
        if (b.getModel().isPressed()) {
            g.drawLine(0, 0, x2 - 1, 0);
            g.drawLine(0, 1, 0, y2 - 1);
        } else {
            g.drawLine(1, y2 - 1, x2 - 1, y2 - 1);
            g.drawLine(x2 - 1, 1, x2 - 1, y2 - 2);
        }
        if (!b.isEnabled()) {
            g.setColor(Theme.spinnerBorderDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.spinnerBorderColor[Theme.style].getColor());
        }
        if (b.getModel().isPressed()) {
            g.drawLine(1, 1, x2 - 2, 1);
            g.drawLine(1, 2, 1, y2 - 2);
        } else {
            g.drawLine(0, y2, x2, y2);
            g.drawLine(x2, 0, x2, y2);
        }
    }

    private void drawXpButton(Graphics g, AbstractButton b) {
        int x2 = TinySpinnerButtonUI.size.width - 1;
        int y2 = TinySpinnerButtonUI.size.height - 1;
        int spread1 = Theme.spinnerSpreadLight[Theme.style];
        int spread2 = Theme.spinnerSpreadDark[Theme.style];
        if (!b.isEnabled()) {
            spread1 = Theme.spinnerSpreadLightDisabled[Theme.style];
            spread2 = Theme.spinnerSpreadDarkDisabled[Theme.style];
        }
        int h = TinySpinnerButtonUI.size.height;
        float spreadStep1 = 10.0f * (float)spread1 / (float)(h - 2);
        float spreadStep2 = 10.0f * (float)spread2 / (float)(h - 2);
        int halfY = h / 2;
        Color c = g.getColor();
        int y = 1;
        while (y < h - 1) {
            int yd;
            if (y < halfY) {
                yd = halfY - y;
                g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
            } else if (y == halfY) {
                g.setColor(c);
            } else {
                yd = y - halfY;
                g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
            }
            g.drawLine(1, y, x2, y);
            ++y;
        }
        if (!b.isEnabled()) {
            g.setColor(Theme.spinnerBorderDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.spinnerBorderColor[Theme.style].getColor());
        }
        g.drawRect(0, 0, x2, y2);
    }

    private void drawTinyArrow(Graphics g, AbstractButton b) {
    }

    private void drawWinArrow(Graphics g, AbstractButton b) {
        int y = 3;
        int x = 6;
        if (b.getModel().isPressed()) {
            y = 4;
            x = 7;
        }
        switch (this.orientation) {
            case 1: {
                g.drawLine(x + 1, y, x + 1, y);
                g.drawLine(x, y + 1, x + 2, y + 1);
                break;
            }
            case 5: {
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x, y, x + 2, y);
            }
        }
    }

    private void drawXpArrow(Graphics g, AbstractButton b) {
        switch (this.orientation) {
            case 1: {
                g.drawLine(7, 2, 7, 2);
                g.drawLine(6, 3, 8, 3);
                g.drawLine(5, 4, 9, 4);
                g.drawLine(4, 5, 6, 5);
                g.drawLine(8, 5, 10, 5);
                break;
            }
            case 5: {
                g.drawLine(4, 2, 6, 2);
                g.drawLine(8, 2, 10, 2);
                g.drawLine(5, 3, 9, 3);
                g.drawLine(6, 4, 8, 4);
                g.drawLine(7, 5, 7, 5);
            }
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        return size;
    }
}

