/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyRadioButtonIcon;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;

public class TinyRadioButtonUI
extends MetalRadioButtonUI {
    private static final TinyRadioButtonUI radioButtonUI = new TinyRadioButtonUI();
    private static BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    private static TinyRadioButtonIcon radioButton;

    public static ComponentUI createUI(JComponent c) {
        if (c instanceof JRadioButton) {
            JRadioButton jb = (JRadioButton)c;
            jb.setRolloverEnabled(true);
        }
        return radioButtonUI;
    }

    public void installUI(JComponent arg0) {
        super.installUI(arg0);
        this.icon = this.getRadioButton();
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        if (!ControlPanel.isInstantiated) {
            return;
        }
        button.setForeground(Theme.radioFontColor[Theme.style].getColor());
    }

    protected TinyRadioButtonIcon getRadioButton() {
        if (radioButton == null) {
            radioButton = new TinyRadioButtonIcon();
        }
        return radioButton;
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension arg2) {
        if (!Theme.buttonFocus[Theme.style]) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.black);
        g2d.setStroke(focusStroke);
        int x1 = t.x - 1;
        int y1 = t.y - 1;
        int x2 = x1 + t.width + 1;
        int y2 = y1 + t.height + 1;
        g2d.drawLine(x1, y1, x2, y1);
        g2d.drawLine(x1, y1, x1, y2);
        g2d.drawLine(x1, y2, x2, y2);
        g2d.drawLine(x2, y1, x2, y2);
    }
}

