/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import jcmdline.Strings;

public class StringFormatHelper {
    private static StringFormatHelper helper;

    private StringFormatHelper() {
    }

    public static StringFormatHelper getHelper() {
        if (helper == null) {
            helper = new StringFormatHelper();
        }
        return helper;
    }

    public String formatHangingIndent(String s, int indent, int lineLen) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (lineLen <= indent) {
            throw new IllegalArgumentException(Strings.get("StringFormatHelper.lineLenLessThanIndent"));
        }
        if (lineLen <= 0) {
            throw new IllegalArgumentException(Strings.get("StringFormatHelper.lineLenZero"));
        }
        StringBuffer sb = new StringBuffer(s.length() + (s.length() / lineLen - indent) + 20);
        String[] a = this.breakString(s, lineLen);
        sb.append(a[0]);
        if (a[1] != null) {
            sb.append(this.formatBlockedText(a[1], indent, lineLen));
        }
        return sb.toString();
    }

    public String formatBlockedText(String s, int indent, int lineLen) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (lineLen <= indent) {
            throw new IllegalArgumentException(Strings.get("StringFormatHelper.lineLenLessThanIndent"));
        }
        if (lineLen <= 0) {
            throw new IllegalArgumentException(Strings.get("StringFormatHelper.lineLenZero"));
        }
        StringBuffer sb = new StringBuffer(s.length() + (s.length() / lineLen - indent) + 20);
        StringBuffer indentBuf = new StringBuffer(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(" ");
        }
        int splitLen = lineLen - indent;
        String[] a = this.breakString(s, splitLen);
        while (a[1] != null) {
            sb.append(indentBuf).append(a[0]);
            a = this.breakString(a[1], splitLen);
        }
        sb.append(indentBuf).append(a[0]);
        return sb.toString();
    }

    protected String[] breakString(String s, int maxLen) {
        s = s == null ? "" : s;
        String line = null;
        String remainder = null;
        int idx = s.indexOf(10);
        if (idx != -1 && idx <= maxLen) {
            line = s.substring(0, ++idx);
            if (idx < s.length()) {
                remainder = s.substring(idx);
            }
        } else if (s.length() <= maxLen) {
            line = s;
        } else {
            idx = s.lastIndexOf(32, maxLen);
            if (idx != -1) {
                line = s.substring(0, idx);
                while (idx < s.length() && s.charAt(idx) == ' ') {
                    ++idx;
                }
                if (idx < s.length()) {
                    line = line + "\n";
                    remainder = s.substring(idx);
                }
            } else {
                line = s.substring(0, maxLen) + "\n";
                remainder = s.substring(maxLen);
            }
        }
        return new String[]{line, remainder};
    }

    public String formatLabeledList(String[] labels, String[] texts, String divider, int maxIndent, int lineLen) {
        if (labels.length != texts.length) {
            throw new IllegalArgumentException(Strings.get("StringFormatHelper.labelDescriptionError", new Object[]{new Integer(labels.length), new Integer(texts.length)}));
        }
        int indent = 0;
        int dividerlen = divider.length();
        for (int i = 0; i < labels.length; ++i) {
            int currlen = labels[i].length() + dividerlen;
            if (currlen > maxIndent || currlen <= indent) continue;
            indent = currlen;
        }
        indent = indent == 0 ? 10 : indent;
        StringBuffer list = new StringBuffer(1600);
        StringBuffer item = new StringBuffer(400);
        for (int i = 0; i < labels.length; ++i) {
            item.delete(0, item.length());
            item.append(labels[i]);
            int spacefill = indent - divider.length();
            while (item.length() < spacefill) {
                item.append(' ');
            }
            item.append(divider);
            if (item.length() > indent) {
                item.append("\n");
            }
            item.append(texts[i]);
            list.append(this.formatHangingIndent(item.toString() + "\n", indent, lineLen));
        }
        return list.toString();
    }
}

