/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRFillFrame
extends JRFillElement
implements JRFrame {
    protected final JRFrame parentFrame;
    private JRFillFrameElements frameContainer;
    private JRTemplateFrame templateFrame;
    private JRTemplateFrame bottomTemplateFrame;
    private JRTemplateFrame topTemplateFrame;
    private JRTemplateFrame topBottomTemplateFrame;
    private boolean first;
    private boolean fillBottomBorder;
    private boolean filling;

    public JRFillFrame(JRBaseFiller filler, JRFrame frame, JRFillObjectFactory factory) {
        super(filler, frame, factory);
        this.parentFrame = frame;
        this.frameContainer = new JRFillFrameElements(factory);
        this.templateFrame = new JRTemplateFrame(this);
    }

    protected JRFillFrame(JRFillFrame frame, JRFillCloneFactory factory) {
        super(frame, factory);
        this.parentFrame = frame.parentFrame;
        this.frameContainer = new JRFillFrameElements(frame.frameContainer, factory);
        this.templateFrame = frame.templateFrame;
        this.bottomTemplateFrame = frame.bottomTemplateFrame;
        this.topTemplateFrame = frame.topTemplateFrame;
        this.topBottomTemplateFrame = frame.topBottomTemplateFrame;
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.frameContainer.evaluate(evaluation);
            boolean repeating = true;
            JRFillElement[] elements = (JRFillElement[])this.getElements();
            for (int i = 0; repeating && i < elements.length; repeating &= elements[i].isValueRepeating(), ++i) {
            }
            this.setValueRepeating(repeating);
        }
        this.filling = false;
    }

    protected void rewind() throws JRException {
        this.frameContainer.rewind();
        this.filling = false;
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        super.prepare(availableStretchHeight, isOverflow);
        if (!this.isToPrint()) {
            return false;
        }
        this.first = !isOverflow || !this.filling;
        int topPadding = this.first ? this.getTopPadding() : 0;
        int bottomPadding = this.getBottomPadding();
        if (availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY() - topPadding) {
            this.setToPrint(false);
            return true;
        }
        if (!(this.filling || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
            this.setToPrint(false);
            return false;
        }
        if (!this.filling && isOverflow && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setToPrint(false);
                return false;
            }
        }
        int stretchHeight = availableStretchHeight - this.getRelativeY() + this.getY() + this.getBandBottomY();
        this.frameContainer.initFill();
        this.frameContainer.resetElements();
        this.frameContainer.prepareElements(stretchHeight + bottomPadding, true);
        boolean willOverflow = this.frameContainer.willOverflow();
        if (willOverflow) {
            this.setStretchHeight(this.getHeight() + stretchHeight);
            this.fillBottomBorder = false;
        } else {
            int neededStretch = this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + topPadding + bottomPadding;
            if (neededStretch <= this.getHeight() + stretchHeight) {
                this.setStretchHeight(neededStretch);
                this.fillBottomBorder = true;
            } else {
                this.setStretchHeight(this.getHeight() + stretchHeight);
                this.fillBottomBorder = false;
            }
        }
        this.filling = willOverflow;
        return willOverflow;
    }

    protected void setStretchHeight(int stretchHeight) {
        super.setStretchHeight(stretchHeight);
        int topPadding = this.first ? this.getTopPadding() : 0;
        int bottomPadding = this.getBottomPadding();
        this.frameContainer.setStretchHeight(stretchHeight + this.frameContainer.getFirstY() - topPadding - bottomPadding);
    }

    protected JRPrintElement fill() throws JRException {
        this.frameContainer.stretchElements();
        this.frameContainer.moveBandBottomElements();
        this.frameContainer.removeBlankElements();
        JRTemplatePrintFrame printFrame = new JRTemplatePrintFrame(this.getTemplate());
        printFrame.setX(this.getX());
        printFrame.setY(this.getRelativeY());
        printFrame.setWidth(this.getWidth());
        this.frameContainer.fillElements(printFrame);
        printFrame.setHeight(this.getStretchHeight());
        return printFrame;
    }

    protected JRTemplateFrame getTemplate() {
        JRTemplateFrame boxTemplate;
        if (this.first) {
            if (this.fillBottomBorder) {
                boxTemplate = this.templateFrame;
            } else {
                if (this.bottomTemplateFrame == null) {
                    JRBaseBox bottomBox = new JRBaseBox(this, true, true, true, false, null);
                    this.bottomTemplateFrame = new JRTemplateFrame(this);
                    this.bottomTemplateFrame.setBox(bottomBox);
                }
                boxTemplate = this.bottomTemplateFrame;
            }
        } else if (this.fillBottomBorder) {
            if (this.topTemplateFrame == null) {
                JRBaseBox topBox = new JRBaseBox(this, true, true, false, true, null);
                this.topTemplateFrame = new JRTemplateFrame(this);
                this.topTemplateFrame.setBox(topBox);
            }
            boxTemplate = this.topTemplateFrame;
        } else {
            if (this.topBottomTemplateFrame == null) {
                JRBaseBox topBottomBox = new JRBaseBox(this, true, true, false, false, null);
                this.topBottomTemplateFrame = new JRTemplateFrame(this);
                this.topBottomTemplateFrame.setBox(topBottomBox);
            }
            boxTemplate = this.topBottomTemplateFrame;
        }
        return boxTemplate;
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    public JRElement[] getElements() {
        return this.frameContainer.getElements();
    }

    public List getChildren() {
        return this.frameContainer.getChildren();
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getFrame(this);
    }

    public void writeXml(JRXmlWriter writer) throws IOException {
        writer.writeFrame(this);
    }

    public JRElement getElementByKey(String key) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), key);
    }

    public JRCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillFrame(this, factory);
    }

    public byte getBorder() {
        return this.parentFrame.getBorder();
    }

    public Byte getOwnBorder() {
        return this.parentFrame.getOwnBorder();
    }

    public void setBorder(byte border) {
    }

    public Color getBorderColor() {
        return this.parentFrame.getBorderColor();
    }

    public Color getOwnBorderColor() {
        return this.parentFrame.getOwnBorderColor();
    }

    public void setBorderColor(Color borderColor) {
    }

    public int getPadding() {
        return this.parentFrame.getPadding();
    }

    public Integer getOwnPadding() {
        return this.parentFrame.getOwnPadding();
    }

    public void setPadding(int padding) {
    }

    public byte getTopBorder() {
        return this.parentFrame.getTopBorder();
    }

    public Byte getOwnTopBorder() {
        return this.parentFrame.getOwnTopBorder();
    }

    public void setTopBorder(byte topBorder) {
    }

    public Color getTopBorderColor() {
        return this.parentFrame.getTopBorderColor();
    }

    public Color getOwnTopBorderColor() {
        return this.parentFrame.getOwnTopBorderColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
    }

    public int getTopPadding() {
        return this.parentFrame.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.parentFrame.getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
    }

    public byte getLeftBorder() {
        return this.parentFrame.getLeftBorder();
    }

    public Byte getOwnLeftBorder() {
        return this.parentFrame.getOwnLeftBorder();
    }

    public void setLeftBorder(byte leftBorder) {
    }

    public Color getLeftBorderColor() {
        return this.parentFrame.getLeftBorderColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.parentFrame.getOwnLeftBorderColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
    }

    public int getLeftPadding() {
        return this.parentFrame.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.parentFrame.getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
    }

    public byte getBottomBorder() {
        return this.parentFrame.getBottomBorder();
    }

    public Byte getOwnBottomBorder() {
        return this.parentFrame.getOwnBottomBorder();
    }

    public void setBottomBorder(byte bottomBorder) {
    }

    public Color getBottomBorderColor() {
        return this.parentFrame.getBottomBorderColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.parentFrame.getOwnBottomBorderColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
    }

    public int getBottomPadding() {
        return this.parentFrame.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.parentFrame.getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
    }

    public byte getRightBorder() {
        return this.parentFrame.getRightBorder();
    }

    public Byte getOwnRightBorder() {
        return this.parentFrame.getOwnRightBorder();
    }

    public void setRightBorder(byte rightBorder) {
    }

    public Color getRightBorderColor() {
        return this.parentFrame.getRightBorderColor();
    }

    public Color getOwnRightBorderColor() {
        return this.parentFrame.getOwnRightBorderColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
    }

    public int getRightPadding() {
        return this.parentFrame.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.parentFrame.getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
    }

    public void setBorder(Byte border) {
    }

    public void setPadding(Integer padding) {
    }

    public void setTopBorder(Byte topBorder) {
    }

    public void setTopPadding(Integer topPadding) {
    }

    public void setLeftBorder(Byte leftBorder) {
    }

    public void setLeftPadding(Integer leftPadding) {
    }

    public void setBottomBorder(Byte bottomBorder) {
    }

    public void setBottomPadding(Integer bottomPadding) {
    }

    public void setRightBorder(Byte rightBorder) {
    }

    public void setRightPadding(Integer rightPadding) {
    }

    protected class JRFillFrameElements
    extends JRFillElementContainer {
        JRFillFrameElements(JRFillObjectFactory factory) {
            super(JRFillFrame.this.filler, JRFillFrame.this.parentFrame, factory);
            this.initElements();
        }

        JRFillFrameElements(JRFillFrameElements frameElements, JRFillCloneFactory factory) {
            super(frameElements, factory);
            this.initElements();
        }

        protected int getContainerHeight() {
            return JRFillFrame.this.getHeight() - JRFillFrame.this.getTopPadding() - JRFillFrame.this.getBottomPadding();
        }
    }
}

