/*
 * PageTransformation.java
 *
 * Created on June 5, 2005 11:31 RL
 */

package it.businesslogic.ireport.undo;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.util.PageSize;
import java.awt.*;

/**
 * @author Robert Lamping
 * When changing the page size during an elementtransaction, (like in FormatCommandShrink),
 * then there is a need to undo this
 *
 * TO DO
 * 1. Recalc columnwidth!!!
 */
public class PageTransformation implements it.businesslogic.ireport.UndoOperation, ITransformation 
{
    // the target in question
    JReportFrame jrf;
    
    //OLD
    private int oldWidth;
    private int oldHeight;
    private String oldReportFormat;
    private int oldColumnWidth;
    
    //NEW
    private int newWidth;
    private int newHeight;
    private String newReportFormat;
    private int newColumnWidth;
    
    public PageTransformation()
    {
    }
    
    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JReportFrame)
        {
           if (this.jrf != null ) {
            isEqual = this.jrf.equals( (JReportFrame) obj );
           }
        } 
        return isEqual;
    }
    
    
    // As the element will not be removed.
    // the element should be able to undo itself
    public void undo()
    {
        this.jrf.getReport().setWidth( oldWidth );
        this.jrf.getReport().setHeight( oldHeight );
        this.jrf.getReport().setReportFormat(oldReportFormat );
        this.jrf.getReport().setColumnWidth( oldColumnWidth );
    }
    
    public void redo()
    {
        this.jrf.getReport().setWidth( newWidth );
        this.jrf.getReport().setHeight( newHeight );
        this.jrf.getReport().setReportFormat( newReportFormat );
        this.jrf.getReport().setColumnWidth( newColumnWidth );
    }
    
    /**
     * Let this class decide on its own which information is captures
     * for a later redo.
     */
    public void captureCurrent(Object obj)
    {
        // TODO you might wish to check whether this the obj is instanceof JReportFrame
        // or enclose with try/catch
        this.jrf = (JReportFrame) obj;
        oldWidth = jrf.getReport().getWidth();
        oldHeight = jrf.getReport().getHeight();
        oldReportFormat = jrf.getReport().getReportFormat();
        oldColumnWidth = jrf.getReport().getColumnWidth();
        
    }
    
    /**
     * Let this class decide on its own which information is captures
     * for a later unddo
     */
    public void captureModified( Object obj)
    {
        JReportFrame jrf = (JReportFrame) obj;
        newWidth = jrf.getReport().getWidth();
        newHeight = jrf.getReport().getHeight();
        newReportFormat = jrf.getReport().getReportFormat();
        newColumnWidth = jrf.getReport().getColumnWidth();

    }
    
}