/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseDataset
implements JRDataset,
Serializable {
    private static final long serialVersionUID = 10101L;
    protected final boolean isMain;
    protected String name = null;
    protected String scriptletClass = null;
    protected JRParameter[] parameters = null;
    protected JRQuery query = null;
    protected JRField[] fields = null;
    protected JRVariable[] variables = null;
    protected JRGroup[] groups = null;
    protected String resourceBundle = null;
    protected byte whenResourceMissingType = 1;

    protected JRBaseDataset(boolean isMain) {
        this.isMain = isMain;
    }

    protected JRBaseDataset(JRDataset dataset, JRBaseObjectFactory factory) {
        JRGroup[] jrGroups;
        JRVariable[] jrVariables;
        JRField[] jrFields;
        factory.put(dataset, this);
        this.name = dataset.getName();
        this.scriptletClass = dataset.getScriptletClass();
        this.resourceBundle = dataset.getResourceBundle();
        this.whenResourceMissingType = dataset.getWhenResourceMissingType();
        this.query = factory.getQuery(dataset.getQuery());
        this.isMain = dataset.isMainDataset();
        JRParameter[] jrParameters = dataset.getParameters();
        if (jrParameters != null && jrParameters.length > 0) {
            this.parameters = new JRParameter[jrParameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = factory.getParameter(jrParameters[i]);
            }
        }
        if ((jrFields = dataset.getFields()) != null && jrFields.length > 0) {
            this.fields = new JRField[jrFields.length];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = factory.getField(jrFields[i]);
            }
        }
        if ((jrVariables = dataset.getVariables()) != null && jrVariables.length > 0) {
            this.variables = new JRVariable[jrVariables.length];
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = factory.getVariable(jrVariables[i]);
            }
        }
        if ((jrGroups = dataset.getGroups()) != null && jrGroups.length > 0) {
            this.groups = new JRGroup[jrGroups.length];
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = factory.getGroup(jrGroups[i]);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getScriptletClass() {
        return this.scriptletClass;
    }

    public JRQuery getQuery() {
        return this.query;
    }

    public JRParameter[] getParameters() {
        return this.parameters;
    }

    public JRField[] getFields() {
        return this.fields;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public JRGroup[] getGroups() {
        return this.groups;
    }

    public boolean isMainDataset() {
        return this.isMain;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public byte getWhenResourceMissingType() {
        return this.whenResourceMissingType;
    }

    public void setWhenResourceMissingType(byte whenResourceMissingType) {
        this.whenResourceMissingType = whenResourceMissingType;
    }
}

