/*
 * ProjectExplorerTreeCellRenderer.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 1 giugno 2003, 16.04
 */

package it.businesslogic.ireport.gui;
import it.businesslogic.ireport.*;
import  javax.swing.tree.*;
import  javax.swing.*;
import  java.awt.*;

/**
 *
 * @author  Administrator
 */
public class DocumentStructureTreeCellRenderer extends DefaultTreeCellRenderer {

    static ImageIcon docIcon;
    static ImageIcon bandIcon;
    static ImageIcon textfieldIcon;
    static ImageIcon statictextIcon;
    static ImageIcon imageIcon;
    static ImageIcon ellipseIcon;
    static ImageIcon rectangleIcon;
    static ImageIcon subreportIcon;
    static ImageIcon lineIcon;
    static ImageIcon chartIcon;

    public DocumentStructureTreeCellRenderer() {
        super();
        if (docIcon == null) docIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/doc.gif"));
        if (bandIcon == null) bandIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/band.gif"));
        if (textfieldIcon == null) textfieldIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/textfield.gif"));
        if (statictextIcon == null) statictextIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/static.gif"));
        if (imageIcon == null) imageIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/image.gif"));
        if (ellipseIcon == null) ellipseIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/ellipse.gif"));
        if (rectangleIcon == null) rectangleIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/rectangle.gif"));
        if (subreportIcon == null) subreportIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/subreport.gif"));
        if (lineIcon == null) lineIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/line.gif"));
        if (chartIcon == null) chartIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/chart.gif"));
        
        /*
        this.setOpenIcon(folderOpenedIcon);
        this.setClosedIcon(folderClosedIcon);
        this.setLeafIcon(documentIcon);
         */
    }

    public Component getTreeCellRendererComponent(
                        JTree tree,
                        Object value,
                        boolean sel,
                        boolean expanded,
                        boolean leaf,
                        int row,
                        boolean hasFocus) {

        super.getTreeCellRendererComponent(
                        tree, value, sel,
                        expanded, leaf, row,
                        hasFocus);
            this.setForeground( Color.BLACK);
            ImageIcon icon = getElementIcon(value);
            setIcon(icon);

            setToolTipText(null);

        return this;
    }

    protected ImageIcon getElementIcon(Object value) {
        DefaultMutableTreeNode node =
                (DefaultMutableTreeNode)value;
        this.setForeground( Color.BLACK);
        
        if (node.getUserObject() instanceof ReportElement &&
            !((ReportElement)node.getUserObject()).insideBandReal())
            this.setForeground( Color.RED);
        
        if (node.getUserObject() instanceof Band) return bandIcon;
        if (node.getUserObject() instanceof TextFieldReportElement ) return textfieldIcon;
        if (node.getUserObject() instanceof StaticTextReportElement ) return statictextIcon;
        if (node.getUserObject() instanceof ChartReportElement) return chartIcon;
        if (node.getUserObject() instanceof ChartReportElement2) return chartIcon;
        if (node.getUserObject() instanceof ImageReportElement) return imageIcon;
        if (node.getUserObject() instanceof EllipseReportElement) return ellipseIcon;
        if (node.getUserObject() instanceof RectangleReportElement) return rectangleIcon;
        if (node.getUserObject() instanceof SubReportElement) return subreportIcon;
        if (node.getUserObject() instanceof LineReportElement) return lineIcon;
     
        return docIcon;
    }
}

