/*
 * SubDataset.java
 *
 * Created on 28 settembre 2005, 1.39
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package it.businesslogic.ireport;
import java.util.*;
import org.syntax.jedit.IReportKeywordLookup;
import org.syntax.jedit.KeywordLookupIF;


/**
 *
 * @author Administrator
 */
public class SubDataset {
    
        private String name = "";
    
        private IReportKeywordLookup keywordLookup = new IReportKeywordLookup();
    
        private String query = "";
        
        private Vector fields = new Vector();
        
        private Vector parameters = new Vector();
    
        private Vector variables = new Vector();
        
        private Vector groups = new Vector();
        
        private String whenResourceMissingType = "Null";
    
        private String scriptletClass = "";
    
        private String ResourceBundleBaseName = "";
        
        /** Getter for property query.
         * @return Value of property query.
         *
         */
        public java.lang.String getQuery() {
            return query;
        }

        /** Setter for property query.
         * @param query New value of property query.
         *
         */
        public void setQuery(java.lang.String query) {
            this.query = query;
        }
        
        /**********************************************************/
        // FIELDS
        
        /** Getter for property fields.
         * @return Value of property fields.
         *
         */
        public java.util.Vector getFields() {
            return fields;
        }
    
        public void addField(JRField field) {
            this.fields.add(field);
            getKeywordLookup().addKeyword("$F{"  + field.getName() + "}");
        }
        
        public void removeField(JRField field) {
            this.fields.remove(field);
            getKeywordLookup().removeKeyword("$F{" + field.getName() + "}");
        }
        
       /** Setter for property fields.
         * @param fields New value of property fields.
         *
         */
        public void setFields(java.util.Vector fields) {
            this.fields = fields;
        }
        
        
         /** Getter for property parameters.
         * @return Value of property parameters.
         *
         */
        public java.util.Vector getParameters() {
            return parameters;
        }

        /** Setter for property parameters.
         * @param parameters New value of property parameters.
         *
         */
        public void setParameters(java.util.Vector parameters) {
            this.parameters = parameters;
        }

        public void addParameter(JRParameter parameter) {
            this.parameters.add(parameter);
            getKeywordLookup().addKeyword("$P{" + parameter.getName() + "}");
        }

        public void removeParameter(JRParameter parameter) {
            if (parameter.isBuiltin()) return;
            this.parameters.remove(parameter);
            getKeywordLookup().removeKeyword("$P{" + parameter.getName() + "}");
        }

        
        
            /** Getter for property variables.
         * @return Value of property variables.
         *
         */
        public java.util.Vector getVariables() {
            return variables;
        }

        public void addVariable(JRVariable variable) {
            this.variables.add(variable);
            getKeywordLookup().addKeyword("$V{" + variable.getName() + "}");
        }
        
        public void removeVariable(JRVariable variable) {
            if (variable.isBuiltin()) return;
            this.variables.remove(variable);
            getKeywordLookup().removeKeyword("$V{" + variable.getName() + "}");
        }

        /** Setter for property variables.
         * @param variables New value of property variables.
         *
         */
        public void setVariables(java.util.Vector variables) {
            this.variables = variables;
        }

         /** Getter for property groups.
         * @return Value of property groups.
         *
         */
        public java.util.Vector getGroups() {
            return groups;
        }

        /** Setter for property groups.
         * @param groups New value of property groups.
         *
         */
        public void setGroups(java.util.Vector groups) {
            this.groups = groups;
        }

        /**********************************************************/
        // KEYWORDS LOOKUP  
        public IReportKeywordLookup getKeywordLookup() {
            return keywordLookup;
        }

        public void setKeywordLookup(IReportKeywordLookup keywordLookup) {
            this.keywordLookup = keywordLookup;
        }
        
        
        public String getWhenResourceMissingType() {
            return whenResourceMissingType;
        }

        public void setWhenResourceMissingType(String whenResourceMissingType) {
            this.whenResourceMissingType = whenResourceMissingType;
        }
        
        /** Getter for property scriptletClass.
     * @return Value of property scriptletClass.
     *
     */
    public java.lang.String getScriptletClass() {
        return scriptletClass;
    }
    
    /** Setter for property scriptletClass.
     * @param scriptletClass New value of property scriptletClass.
     *
     */
    public void setScriptletClass(java.lang.String scriptletClass) {
        this.scriptletClass = scriptletClass;
    }
    
    public String getResourceBundleBaseName() {
        return ResourceBundleBaseName;
    }

    public void setResourceBundleBaseName(String ResourceBundleBaseName) {
        this.ResourceBundleBaseName = ResourceBundleBaseName;
    }

       /** Getter for property name.
     * @return Value of property name.
     *
     */
    public java.lang.String getName() {
        return name;
    }
    
    /** Setter for property name.
     * @param name New value of property name.
     *
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }
}
