/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.undo.ReplacedElementItem;
import java.util.Enumeration;
import java.util.Vector;

public class ReplacedElementsOperation
implements UndoOperation {
    private Vector elements = new Vector();
    private JReportFrame jrf = null;

    public ReplacedElementsOperation(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        Enumeration e = this.getElements().elements();
        Vector<ReportElement> added_elements = new Vector<ReportElement>();
        Vector<ReportElement> removed_elements = new Vector<ReportElement>();
        while (e.hasMoreElements()) {
            ReplacedElementItem ei = (ReplacedElementItem)e.nextElement();
            ReportElement newElement = ei.getNewElement();
            ReportElement oldElement = ei.getOldElement();
            int index = this.jrf.getReport().getElements().indexOf(oldElement);
            this.jrf.getReport().getElements().remove(oldElement);
            this.jrf.getReport().getElements().add(index, newElement);
            added_elements.add(newElement);
            removed_elements.add(oldElement);
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, removed_elements, 1));
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, added_elements, 2));
        this.jrf.getReportPanel().repaint();
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        Vector<ReportElement> added_elements = new Vector<ReportElement>();
        Vector<ReportElement> removed_elements = new Vector<ReportElement>();
        for (int i = this.getElements().size() - 1; i >= 0; --i) {
            ReplacedElementItem ei = (ReplacedElementItem)this.getElements().get(i);
            ReportElement newElement = ei.getNewElement();
            ReportElement oldElement = ei.getOldElement();
            int index = this.jrf.getReport().getElements().indexOf(newElement);
            this.jrf.getReport().getElements().remove(newElement);
            this.jrf.getReport().getElements().add(index, oldElement);
            added_elements.add(oldElement);
            removed_elements.add(newElement);
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, removed_elements, 1));
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, added_elements, 2));
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return "Transformed element(s)";
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector elements) {
        this.elements = elements;
    }

    public void addElement(ReportElement oldEelement, ReportElement newElement) {
        ReplacedElementItem ei = new ReplacedElementItem(oldEelement, newElement);
        this.getElements().add(ei);
    }
}

