/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.prompt;

import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PromptDialog
extends JDialog {
    static Vector cachedValues = new Vector();
    private int dialogResult = 2;
    private Object value = null;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabelClass;
    private JLabel jLabelParamName;
    private JLabel jLabelYouCan;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;

    public PromptDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jLabelYouCan.setText(I18n.getString("gui.prompt.parameter", "You can provide a value for the parameter:"));
        for (int i = 0; i < cachedValues.size(); ++i) {
            this.jComboBox1.addItem(cachedValues.elementAt(i));
        }
        this.jComboBox1.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                PromptDialog.this.jButton1KeyPressed(evt);
            }

            public void keyTyped(KeyEvent evt) {
            }
        });
        Misc.centerFrame(this);
    }

    public void setParameter(JRParameter param) {
        String val = param.getLastDefaultValue();
        if (val == null) {
            val = "";
        }
        this.jComboBox1.setSelectedItem(val);
        this.jComboBox1.getEditor().selectAll();
        this.jLabelParamName.setText(param.getName());
        if (param.getDescription() != null && param.getDescription().length() > 0) {
            this.jLabelParamName.setToolTipText(param.getDescription());
        }
        String format = "";
        if (param.getClassType().equals("java.util.Date")) {
            format = " (" + MainFrame.getMainInstance().getProperties().getProperty("dateformat", "d/M/y") + ")";
        }
        if (param.getClassType().equals("java.sql.Time") || param.getClassType().equals("java.sql.Timestamp")) {
            format = " (" + MainFrame.getMainInstance().getProperties().getProperty("timeformat", "d/M/y H:m:s") + ")";
        }
        if (param.getClassType().equals("java.lang.Boolean")) {
            format = " (true | false)";
        }
        this.jLabelClass.setText(I18n.getString("gui.prompt.class", "The class  type is:") + " " + param.getClassType() + format);
        this.jComboBox1.requestFocusInWindow();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabelYouCan = new JLabel();
        this.jLabelParamName = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabelClass = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle("Parameter prompt");
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/keyboard.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelYouCan.setFont(new Font("Dialog", 0, 12));
        this.jLabelYouCan.setText("You can provide a value for the parameter:");
        this.jLabelYouCan.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelYouCan, gridBagConstraints);
        this.jLabelParamName.setFont(new Font("Dialog", 1, 16));
        this.jLabelParamName.setText("Param name");
        this.jLabelParamName.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelParamName, gridBagConstraints);
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setPreferredSize(new Dimension(400, 25));
        this.jComboBox1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                PromptDialog.this.jComboBox1KeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jComboBox1, gridBagConstraints);
        this.jLabelClass.setFont(new Font("Dialog", 0, 12));
        this.jLabelClass.setText("The class  type is:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jLabelClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(50, 40));
        this.jPanel2.setPreferredSize(new Dimension(40, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jButton1.setText("Ok");
        this.jButton1.setPreferredSize(new Dimension(100, 26));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PromptDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                PromptDialog.this.jButton1KeyPressed(evt);
            }

            public void keyTyped(KeyEvent evt) {
                PromptDialog.this.jButton1KeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel2.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText("Use default");
        this.jButton2.setPreferredSize(new Dimension(100, 26));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PromptDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel2.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void jComboBox1KeyPressed(KeyEvent evt) {
    }

    private void jButton1KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jComboBox1.setSelectedItem(this.jComboBox1.getEditor().getItem());
            this.jButton1.requestFocusInWindow();
            this.jButton1ActionPerformed(null);
        }
    }

    private void jButton1KeyTyped(KeyEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setValue(null);
        this.setVisible(false);
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setDialogResult(0);
        if (this.jComboBox1.getSelectedItem() != null) {
            this.setValue(this.jComboBox1.getSelectedItem());
            if (!cachedValues.contains(this.getValue())) {
                cachedValues.addElement(this.getValue());
            }
        } else {
            this.setValue(null);
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new PromptDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

