/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.tools.codec.Base64Encoder;

public class JRXmlExporter
extends JRAbstractExporter {
    protected StringBuffer sbuffer = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageNameToImageDataMap = null;
    protected Map fontsMap = new HashMap();
    protected String dtdLocation = null;
    protected boolean isEmbeddingImages = true;
    protected File destFile = null;
    protected File imagesDir = null;
    protected static final int colorMask = Integer.parseInt("FFFFFF", 16);

    public void exportReport() throws JRException {
        StringBuffer sb;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        this.setPageRange();
        this.dtdLocation = (String)this.parameters.get(JRXmlExporterParameter.DTD_LOCATION);
        if (this.dtdLocation == null) {
            this.dtdLocation = "http://jasperreports.sourceforge.net/dtds/jasperprint.dtd";
        }
        if ((sb = (StringBuffer)this.parameters.get(JRXmlExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            sb.append(this.exportReportToBuffer().toString());
        } else {
            OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
            if (os != null) {
                String xmlString = this.exportReportToBuffer().toString();
                try {
                    byte[] bytes = xmlString.getBytes("UTF-8");
                    os.write(bytes, 0, bytes.length);
                }
                catch (Exception e) {
                    throw new JRException("Error writing to OutputStream : " + this.jasperPrint.getName(), e);
                }
            } else {
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        this.destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                this.imagesDir = new File(this.destFile.getParent(), this.destFile.getName() + "_files");
                Boolean isEmbeddingImagesParameter = (Boolean)this.parameters.get(JRXmlExporterParameter.IS_EMBEDDING_IMAGES);
                if (isEmbeddingImagesParameter == null) {
                    isEmbeddingImagesParameter = Boolean.TRUE;
                }
                this.isEmbeddingImages = isEmbeddingImagesParameter;
                this.exportReportToFile();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void exportReportToFile() throws JRException {
        FileOutputStream fos;
        block16: {
            this.rendererToImagePathMap = new HashMap();
            this.imageNameToImageDataMap = new HashMap();
            String xmlString = this.exportReportToBuffer().toString();
            fos = null;
            try {
                try {
                    byte[] bytes = xmlString.getBytes("UTF-8");
                    fos = new FileOutputStream(this.destFile);
                    fos.write(bytes, 0, bytes.length);
                    fos.flush();
                }
                catch (IOException e) {
                    throw new JRException("Error writing to file : " + this.destFile, e);
                }
                Object var5_5 = null;
                if (fos == null) break block16;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            fos.close();
        }
        if (this.isEmbeddingImages) return;
        Set imageNames = this.imageNameToImageDataMap.keySet();
        if (imageNames == null) return;
        if (imageNames.size() <= 0) return;
        if (!this.imagesDir.exists()) {
            this.imagesDir.mkdir();
        }
        Iterator it = imageNames.iterator();
        while (it.hasNext()) {
            IOException e3;
            Object var10_12;
            String imageName = (String)it.next();
            byte[] imageData = (byte[])this.imageNameToImageDataMap.get(imageName);
            File imageFile = new File(this.imagesDir, imageName);
            try {
                try {
                    fos = new FileOutputStream(imageFile);
                    fos.write(imageData, 0, imageData.length);
                }
                catch (IOException e2) {
                    throw new JRException("Error writing to image file : " + imageFile, e2);
                }
                var10_12 = null;
                if (fos == null) continue;
                {
                }
            }
            catch (Throwable throwable) {
                var10_12 = null;
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e3) {}
            fos.close();
        }
    }

    protected StringBuffer exportReportToBuffer() throws JRException {
        List pages;
        this.sbuffer = new StringBuffer();
        this.sbuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.sbuffer.append("<!DOCTYPE jasperPrint PUBLIC \"-//JasperReports//DTD Report Design//EN\" \"");
        this.sbuffer.append(this.dtdLocation);
        this.sbuffer.append("\">\n");
        this.sbuffer.append("\n");
        this.sbuffer.append("<jasperPrint name=\"");
        this.sbuffer.append(this.jasperPrint.getName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" pageWidth=\"");
        this.sbuffer.append(this.jasperPrint.getPageWidth());
        this.sbuffer.append("\"");
        this.sbuffer.append(" pageHeight=\"");
        this.sbuffer.append(this.jasperPrint.getPageHeight());
        this.sbuffer.append("\"");
        if (this.jasperPrint.getOrientation() != 1) {
            this.sbuffer.append(" orientation=\"");
            this.sbuffer.append((String)JRXmlConstants.getOrientationMap().get(new Byte(this.jasperPrint.getOrientation())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        JRReportFont[] fonts = this.jasperPrint.getFonts();
        if (fonts != null && fonts.length > 0) {
            for (int i = 0; i < fonts.length; ++i) {
                this.fontsMap.put(fonts[i].getName(), fonts[i]);
                this.exportReportFont(fonts[i]);
            }
        }
        if ((pages = this.jasperPrint.getPages()) != null && pages.size() > 0) {
            JRPrintPage page = null;
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                page = (JRPrintPage)pages.get(i);
                this.exportPage(page);
            }
        }
        this.sbuffer.append("</jasperPrint>\n");
        return this.sbuffer;
    }

    protected void exportReportFont(JRReportFont font) {
        this.sbuffer.append("\t<reportFont");
        this.sbuffer.append(" name=\"");
        this.sbuffer.append(font.getName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isDefault=\"");
        this.sbuffer.append(font.isDefault());
        this.sbuffer.append("\"");
        this.sbuffer.append(" fontName=\"");
        this.sbuffer.append(font.getFontName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" size=\"");
        this.sbuffer.append(font.getSize());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isBold=\"");
        this.sbuffer.append(font.isBold());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isItalic=\"");
        this.sbuffer.append(font.isItalic());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isUnderline=\"");
        this.sbuffer.append(font.isUnderline());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isStrikeThrough=\"");
        this.sbuffer.append(font.isStrikeThrough());
        this.sbuffer.append("\"");
        this.sbuffer.append(" pdfFontName=\"");
        this.sbuffer.append(font.getPdfFontName());
        this.sbuffer.append("\"");
        this.sbuffer.append(" pdfEncoding=\"");
        this.sbuffer.append(font.getPdfEncoding());
        this.sbuffer.append("\"");
        this.sbuffer.append(" isPdfEmbedded=\"");
        this.sbuffer.append(font.isPdfEmbedded());
        this.sbuffer.append("\"");
        this.sbuffer.append("/>\n");
    }

    protected void exportPage(JRPrintPage page) throws JRException {
        this.sbuffer.append("\t<page>\n");
        JRPrintElement element = null;
        List elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (!(element instanceof JRPrintText)) continue;
                this.exportText((JRPrintText)element);
            }
        }
        this.sbuffer.append("\t</page>\n");
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportLine(JRPrintLine line) {
        this.sbuffer.append("\t\t<line");
        if (line.getDirection() != 1) {
            this.sbuffer.append(" direction=\"");
            this.sbuffer.append((String)JRXmlConstants.getDirectionMap().get(new Byte(line.getDirection())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.exportReportElement(line);
        this.exportGraphicElement(line);
        this.sbuffer.append("\t\t</line>\n");
    }

    protected void exportReportElement(JRPrintElement element) {
        this.sbuffer.append("\t\t\t<reportElement");
        if (element instanceof JRPrintLine && element.getMode() != 1 || element instanceof JRPrintRectangle && element.getMode() != 1 || element instanceof JRPrintEllipse && element.getMode() != 1 || element instanceof JRPrintImage && element.getMode() != 2 || element instanceof JRPrintText && element.getMode() != 2) {
            this.sbuffer.append(" mode=\"");
            this.sbuffer.append((String)JRXmlConstants.getModeMap().get(new Byte(element.getMode())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(" x=\"");
        this.sbuffer.append(element.getX() + this.globalOffsetX);
        this.sbuffer.append("\"");
        this.sbuffer.append(" y=\"");
        this.sbuffer.append(element.getY() + this.globalOffsetY);
        this.sbuffer.append("\"");
        this.sbuffer.append(" width=\"");
        this.sbuffer.append(element.getWidth());
        this.sbuffer.append("\"");
        this.sbuffer.append(" height=\"");
        this.sbuffer.append(element.getHeight());
        this.sbuffer.append("\"");
        if (element.getForecolor().getRGB() != Color.black.getRGB()) {
            this.sbuffer.append(" forecolor=\"#");
            this.sbuffer.append(this.getHexaColor(element.getForecolor()));
            this.sbuffer.append("\"");
        }
        if (element.getBackcolor().getRGB() != Color.white.getRGB()) {
            this.sbuffer.append(" backcolor=\"#");
            this.sbuffer.append(this.getHexaColor(element.getBackcolor()));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append("/>\n");
    }

    protected void exportGraphicElement(JRPrintGraphicElement element) {
        this.sbuffer.append("\t\t\t<graphicElement");
        if (element instanceof JRPrintLine && element.getPen() != 1 || element instanceof JRPrintRectangle && element.getPen() != 1 || element instanceof JRPrintEllipse && element.getPen() != 1 || element instanceof JRPrintImage && element.getPen() != 0) {
            this.sbuffer.append(" pen=\"");
            this.sbuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(element.getPen())));
            this.sbuffer.append("\"");
        }
        if (element.getFill() != 1) {
            this.sbuffer.append(" fill=\"");
            this.sbuffer.append((String)JRXmlConstants.getFillMap().get(new Byte(element.getFill())));
            this.sbuffer.append("\"");
        }
        this.sbuffer.append("/>\n");
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        this.sbuffer.append("\t\t<rectangle");
        if (rectangle.getRadius() != 0) {
            this.sbuffer.append(" radius=\"");
            this.sbuffer.append(rectangle.getRadius());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.exportReportElement(rectangle);
        this.exportGraphicElement(rectangle);
        this.sbuffer.append("\t\t</rectangle>\n");
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        this.sbuffer.append("\t\t\t<ellipse>\n");
        this.exportReportElement(ellipse);
        this.exportGraphicElement(ellipse);
        this.sbuffer.append("\t\t</ellipse>\n");
    }

    protected void exportImage(JRPrintImage image) throws JRException {
        this.sbuffer.append("\t\t<image");
        if (image.getScaleImage() != 3) {
            this.sbuffer.append(" scaleImage=\"");
            this.sbuffer.append((String)JRXmlConstants.getScaleImageMap().get(new Byte(image.getScaleImage())));
            this.sbuffer.append("\"");
        }
        if (image.getHorizontalAlignment() != 1) {
            this.sbuffer.append(" hAlign=\"");
            this.sbuffer.append((String)JRXmlConstants.getHorizontalAlignMap().get(new Byte(image.getHorizontalAlignment())));
            this.sbuffer.append("\"");
        }
        if (image.getVerticalAlignment() != 1) {
            this.sbuffer.append(" vAlign=\"");
            this.sbuffer.append((String)JRXmlConstants.getVerticalAlignMap().get(new Byte(image.getVerticalAlignment())));
            this.sbuffer.append("\"");
        }
        if (image.isLazy()) {
            this.sbuffer.append(" isLazy=\"");
            this.sbuffer.append(image.isLazy());
            this.sbuffer.append("\"");
        }
        if (image.getOnErrorType() != 1) {
            this.sbuffer.append(" onErrorType=\"");
            this.sbuffer.append((String)JRXmlConstants.getOnErrorTypeMap().get(new Byte(image.getOnErrorType())));
            this.sbuffer.append("\"");
        }
        if (image.getHyperlinkType() != 1) {
            this.sbuffer.append(" hyperlinkType=\"");
            this.sbuffer.append((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(image.getHyperlinkType())));
            this.sbuffer.append("\"");
        }
        if (image.getHyperlinkTarget() != 1) {
            this.sbuffer.append(" hyperlinkTarget=\"");
            this.sbuffer.append((String)JRXmlConstants.getHyperlinkTargetMap().get(new Byte(image.getHyperlinkTarget())));
            this.sbuffer.append("\"");
        }
        if (image.getAnchorName() != null) {
            this.sbuffer.append(" anchorName=\"");
            this.sbuffer.append(image.getAnchorName());
            this.sbuffer.append("\"");
        }
        if (image.getHyperlinkReference() != null) {
            this.sbuffer.append(" hyperlinkReference=\"");
            this.sbuffer.append(image.getHyperlinkReference());
            this.sbuffer.append("\"");
        }
        if (image.getHyperlinkAnchor() != null) {
            this.sbuffer.append(" hyperlinkAnchor=\"");
            this.sbuffer.append(image.getHyperlinkAnchor());
            this.sbuffer.append("\"");
        }
        if (image.getHyperlinkPage() != null) {
            this.sbuffer.append(" hyperlinkPage=\"");
            this.sbuffer.append(image.getHyperlinkPage());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.exportReportElement(image);
        this.exportBox(image.getBox());
        this.exportGraphicElement(image);
        JRRenderable renderer = image.getRenderer();
        if (renderer != null) {
            this.sbuffer.append("\t\t\t<imageSource");
            if (this.isEmbeddingImages && !image.isLazy()) {
                this.sbuffer.append(" isEmbedded=\"");
                this.sbuffer.append(this.isEmbeddingImages && !image.isLazy());
                this.sbuffer.append("\"");
            }
            this.sbuffer.append("><![CDATA[");
            String imageSource = "";
            if (renderer.getType() == 1) {
                renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), image.getBackcolor());
            }
            if (this.isEmbeddingImages && !image.isLazy()) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(renderer.getImageData());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Base64Encoder encoder = new Base64Encoder(bais, baos);
                    encoder.process();
                    imageSource = new String(baos.toByteArray(), "UTF-8");
                }
                catch (IOException e) {
                    throw new JRException("Error embedding image into XML.", e);
                }
            } else if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer)) {
                imageSource = (String)this.rendererToImagePathMap.get(renderer);
            } else {
                if (image.isLazy()) {
                    imageSource = ((JRImageRenderer)renderer).getImageLocation();
                } else {
                    imageSource = "img_" + String.valueOf(this.imageNameToImageDataMap.size());
                    this.imageNameToImageDataMap.put(imageSource, renderer.getImageData());
                    imageSource = new File(this.imagesDir, imageSource).getPath();
                }
                this.rendererToImagePathMap.put(renderer, imageSource);
            }
            this.sbuffer.append(imageSource);
            this.sbuffer.append("]]></imageSource>\n");
        }
        this.sbuffer.append("\t\t</image>\n");
    }

    protected void exportText(JRPrintText text) {
        this.sbuffer.append("\t\t<text");
        if (text.getTextAlignment() != 1) {
            this.sbuffer.append(" textAlignment=\"");
            this.sbuffer.append((String)JRXmlConstants.getHorizontalAlignMap().get(new Byte(text.getTextAlignment())));
            this.sbuffer.append("\"");
        }
        if (text.getVerticalAlignment() != 1) {
            this.sbuffer.append(" verticalAlignment=\"");
            this.sbuffer.append((String)JRXmlConstants.getVerticalAlignMap().get(new Byte(text.getVerticalAlignment())));
            this.sbuffer.append("\"");
            this.sbuffer.append(" textHeight=\"");
            this.sbuffer.append(text.getTextHeight());
            this.sbuffer.append("\"");
        }
        if (text.getRotation() != 0) {
            this.sbuffer.append(" rotation=\"");
            this.sbuffer.append((String)JRXmlConstants.getRotationMap().get(new Byte(text.getRotation())));
            this.sbuffer.append("\"");
        }
        if (text.getRunDirection() != 0) {
            this.sbuffer.append(" runDirection=\"");
            this.sbuffer.append((String)JRXmlConstants.getRunDirectionMap().get(new Byte(text.getRunDirection())));
            this.sbuffer.append("\"");
        }
        if (text.getLineSpacing() != 0) {
            this.sbuffer.append(" lineSpacing=\"");
            this.sbuffer.append((String)JRXmlConstants.getLineSpacingMap().get(new Byte(text.getLineSpacing())));
            this.sbuffer.append("\"");
        }
        if (text.isStyledText()) {
            this.sbuffer.append(" isStyledText=\"");
            this.sbuffer.append(text.isStyledText());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(" lineSpacingFactor=\"");
        this.sbuffer.append(text.getLineSpacingFactor());
        this.sbuffer.append("\"");
        this.sbuffer.append(" leadingOffset=\"");
        this.sbuffer.append(text.getLeadingOffset());
        this.sbuffer.append("\"");
        if (text.getHyperlinkType() != 1) {
            this.sbuffer.append(" hyperlinkType=\"");
            this.sbuffer.append((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(text.getHyperlinkType())));
            this.sbuffer.append("\"");
        }
        if (text.getHyperlinkTarget() != 1) {
            this.sbuffer.append(" hyperlinkTarget=\"");
            this.sbuffer.append((String)JRXmlConstants.getHyperlinkTargetMap().get(new Byte(text.getHyperlinkTarget())));
            this.sbuffer.append("\"");
        }
        if (text.getAnchorName() != null) {
            this.sbuffer.append(" anchorName=\"");
            this.sbuffer.append(text.getAnchorName());
            this.sbuffer.append("\"");
        }
        if (text.getHyperlinkReference() != null) {
            this.sbuffer.append(" hyperlinkReference=\"");
            this.sbuffer.append(text.getHyperlinkReference());
            this.sbuffer.append("\"");
        }
        if (text.getHyperlinkAnchor() != null) {
            this.sbuffer.append(" hyperlinkAnchor=\"");
            this.sbuffer.append(text.getHyperlinkAnchor());
            this.sbuffer.append("\"");
        }
        if (text.getHyperlinkPage() != null) {
            this.sbuffer.append(" hyperlinkPage=\"");
            this.sbuffer.append(text.getHyperlinkPage());
            this.sbuffer.append("\"");
        }
        this.sbuffer.append(">\n");
        this.exportReportElement(text);
        this.exportBox(text.getBox());
        String font = this.exportFont(text.getFont());
        if (font != null) {
            this.sbuffer.append("\t\t\t" + font + "\n");
        }
        if (text.getText() != null) {
            this.sbuffer.append("\t\t\t<textContent><![CDATA[");
            this.sbuffer.append(text.getText());
            this.sbuffer.append("]]></textContent>\n");
        }
        this.sbuffer.append("\t\t</text>\n");
    }

    private void exportBox(JRBox box) {
        if (box != null) {
            StringBuffer tmpBuffer = new StringBuffer();
            if (box.getBorder() != 0) {
                tmpBuffer.append(" border=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getBorderColor() != null) {
                tmpBuffer.append(" borderColor=\"#");
                tmpBuffer.append(this.getHexaColor(box.getBorderColor()));
                tmpBuffer.append("\"");
            }
            if (box.getPadding() > 0) {
                tmpBuffer.append(" padding=\"");
                tmpBuffer.append(box.getPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopBorder() != null) {
                tmpBuffer.append(" topBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnTopBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopBorderColor() != null) {
                tmpBuffer.append(" topBorderColor=\"#");
                tmpBuffer.append(this.getHexaColor(box.getOwnTopBorderColor()));
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopPadding() != null) {
                tmpBuffer.append(" topPadding=\"");
                tmpBuffer.append(box.getOwnTopPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftBorder() != null) {
                tmpBuffer.append(" leftBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnLeftBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftBorderColor() != null) {
                tmpBuffer.append(" leftBorderColor=\"#");
                tmpBuffer.append(this.getHexaColor(box.getOwnLeftBorderColor()));
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftPadding() != null) {
                tmpBuffer.append(" leftPadding=\"");
                tmpBuffer.append(box.getOwnLeftPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomBorder() != null) {
                tmpBuffer.append(" bottomBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnBottomBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomBorderColor() != null) {
                tmpBuffer.append(" bottomBorderColor=\"#");
                tmpBuffer.append(this.getHexaColor(box.getOwnBottomBorderColor()));
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomPadding() != null) {
                tmpBuffer.append(" bottomPadding=\"");
                tmpBuffer.append(box.getOwnBottomPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightBorder() != null) {
                tmpBuffer.append(" rightBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnRightBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightBorderColor() != null) {
                tmpBuffer.append(" rightBorderColor=\"#");
                tmpBuffer.append(this.getHexaColor(box.getOwnRightBorderColor()));
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightPadding() != null) {
                tmpBuffer.append(" rightPadding=\"");
                tmpBuffer.append(box.getOwnRightPadding());
                tmpBuffer.append("\"");
            }
            if (tmpBuffer.length() > 0) {
                this.sbuffer.append("<box");
                this.sbuffer.append(tmpBuffer.toString());
                this.sbuffer.append("/>");
            }
        }
    }

    protected String exportFont(JRFont font) {
        String fontChunk = null;
        if (font != null) {
            StringBuffer tmpBuffer = new StringBuffer();
            if (font.getReportFont() != null) {
                JRFont baseFont = (JRFont)this.fontsMap.get(font.getReportFont().getName());
                if (baseFont != null) {
                    tmpBuffer.append(" reportFont=\"");
                    tmpBuffer.append(font.getReportFont().getName());
                    tmpBuffer.append("\"");
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + font.getReportFont().getName());
                }
            }
            if (font.getOwnFontName() != null) {
                tmpBuffer.append(" fontName=\"");
                tmpBuffer.append(font.getOwnFontName());
                tmpBuffer.append("\"");
            }
            if (font.getOwnSize() != null) {
                tmpBuffer.append(" size=\"");
                tmpBuffer.append(font.getOwnSize());
                tmpBuffer.append("\"");
            }
            if (font.isOwnBold() != null) {
                tmpBuffer.append(" isBold=\"");
                tmpBuffer.append(font.isOwnBold());
                tmpBuffer.append("\"");
            }
            if (font.isOwnItalic() != null) {
                tmpBuffer.append(" isItalic=\"");
                tmpBuffer.append(font.isOwnItalic());
                tmpBuffer.append("\"");
            }
            if (font.isOwnUnderline() != null) {
                tmpBuffer.append(" isUnderline=\"");
                tmpBuffer.append(font.isOwnUnderline());
                tmpBuffer.append("\"");
            }
            if (font.isOwnStrikeThrough() != null) {
                tmpBuffer.append(" isStrikeThrough=\"");
                tmpBuffer.append(font.isOwnStrikeThrough());
                tmpBuffer.append("\"");
            }
            if (font.getOwnPdfFontName() != null) {
                tmpBuffer.append(" pdfFontName=\"");
                tmpBuffer.append(font.getOwnPdfFontName());
                tmpBuffer.append("\"");
            }
            if (font.getOwnPdfEncoding() != null) {
                tmpBuffer.append(" pdfEncoding=\"");
                tmpBuffer.append(font.getOwnPdfEncoding());
                tmpBuffer.append("\"");
            }
            if (font.isOwnPdfEmbedded() != null) {
                tmpBuffer.append(" isPdfEmbedded=\"");
                tmpBuffer.append(font.isOwnPdfEmbedded());
                tmpBuffer.append("\"");
            }
            if (tmpBuffer.length() > 0) {
                fontChunk = "<font" + tmpBuffer.toString() + "/>";
            }
        }
        return fontChunk;
    }

    private String getHexaColor(Color color) {
        String hexa = Integer.toHexString(color.getRGB() & colorMask).toUpperCase();
        return ("000000" + hexa).substring(hexa.length());
    }
}

