/*
 * ReportElementSheetPanel.java
 *
 * Created on 16 febbraio 2005, 6.57
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.*;
import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.gui.event.*;
import it.businesslogic.ireport.util.*;
import java.util.*;

/**
 *
 * @author  Administrator
 */
public class ReportElementSheetPanel extends CategorySheetPanel implements ReportListener {
    
    // Sheet properties
    private ComboBoxSheetProperty spBands;
    private SheetProperty spTop;
    private SheetProperty spLeft;
    private SheetProperty spHeight;
    private SheetProperty spWidth;
    private ComboBoxSheetProperty spGroups;
    private ComboBoxSheetProperty spImageGroup;
    private ComboBoxSheetProperty spImageGroup1;
    private ComboBoxSheetProperty spTextFieldGroup;
    private ComboBoxSheetProperty spBarcodeGroup;
        
    private JReportFrame jrf = null;
    
    
    /** Creates a new instance of ReportElementSheetPanel */
    public ReportElementSheetPanel() {
        super();
        
        initSheetProperties();
        // We have to register for element changes...
        MainFrame mf = MainFrame.getMainInstance();
        mf.addReportListener( this );
        
    }

     public void updateSelection()
     {
        this.removeAllProperties();
        
        this.recreateSheet();
        jrf = MainFrame.getMainInstance().getActiveReportFrame();
        
        if (jrf == null || jrf.getSelectedElements().size() == 0) return;
        
        Vector selectedElements = jrf.getSelectedElements();
        ReportElement re = (ReportElement)selectedElements.elementAt(0);
        spTop.setValue( new Integer( re.getPosition().x ));
        spLeft.setValue( new Integer( re.getPosition().y));
        
        updateGroups();
        
        this.addSheetProperty("Common", spBands);
        this.addSheetProperty("Common", spTop);
        this.addSheetProperty("Common", spLeft);
        this.addSheetProperty("Common", spHeight);
        this.addSheetProperty("Common", spWidth); 
        spGroups.setValue( re.getPrintWhenGroupChanges() );
        this.addSheetProperty("Common", spGroups);
        
        this.recreateSheet();
     }
     
     /**
      *     This method is called when a new element is selected,
      *     or deselected.
      */
     public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt){
         updateSelection();
     }
   
     /*
      *     This method is called when an element is removed, changed or added.
      */
      public void reportElementsChanged(ReportElementChangedEvent evt){
        updateSelection();
      }
      
     /*
      *     This method is called when a band is removed, changed or added.
      */ 
     public void reportBandChanged(ReportBandChangedEvent evt ) {
         updateSelection();
     }
     
     protected void initSheetProperties()
     {
        spBands = new ComboBoxSheetProperty("band","Band");
        spTop =  new SheetProperty("top","Top", SheetProperty.INTEGER);
        spLeft =  new SheetProperty("left","Left", SheetProperty.INTEGER);
        spHeight =  new SheetProperty("height","Height", SheetProperty.INTEGER);
        spWidth =  new SheetProperty("width","Width", SheetProperty.INTEGER);
        
        spGroups = new ComboBoxSheetProperty("groups","Print when group change");
        spImageGroup = new ComboBoxSheetProperty("img_group","Evaluation group");
        spImageGroup1 = new ComboBoxSheetProperty("chart_group","Evaluation group");
        spTextFieldGroup = new ComboBoxSheetProperty("textfield_group","Evaluation group");
        spBarcodeGroup = new ComboBoxSheetProperty("barcode_group","Evaluation group");
     }
     
     protected void updateGroups()
     {
         if (jrf == null) return;
         // Use the name of the group and not the group object....
         Vector group_names = new Vector();
         Enumeration e = jrf.getReport().getGroups().elements();
         while (e.hasMoreElements()) {
            group_names.addElement(""+e.nextElement());
         }
         spGroups.updateValues( group_names,true);
         spImageGroup.updateValues( group_names,true);
         spImageGroup1.updateValues( group_names,true);
         spTextFieldGroup.updateValues( group_names,true);
         spBarcodeGroup.updateValues( group_names,true);
     }
     
     protected void updateBands()
     {
         spBands.updateValues( jrf.getReport().getBands(),true);
     }
}
