/*
 * FormatCommandAlignCenter.java
 *
 * Center the selected items in the center of the band, between the margins.
 *
 * Created on 9 mei 2005, 21:36
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.OperationType;
import java.awt.Point;

/**
 *
 */
public class FormatCommandAlignCenter extends FormatCommand {
        
    {
        operationType = OperationType.ALIGN_CENTER;
    }

    int centerx;
    
    public void preparation() {
        centerx = 10 + jrf.getReport().getWidth()/2;
    }
    
    public void modify() {
        int centery = jrf.getReport().getBandYLocation(re.getBand())+10+re.getBand().getHeight()/2;               
        re.setPosition(new Point(centerx - (re.getWidth() /2),  centery - (re.getHeight() /2)));
    }
    
}
