/*
 * JTableFrame.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 20 maggio 2003, 20.20
 */

package it.businesslogic.ireport.gui;
import javax.swing.*;
import java.util.*;
import java.awt.dnd.*;
import java.awt.event.*;
import javax.swing.table.*;
/**
 *
 * @author  Administrator
 */
public class JTableFrame extends javax.swing.JInternalFrame {
    
    /** Creates new form JTableFrame */
    java.awt.Point origin = null;
    public JTableFrame() {
        initComponents();
        ((javax.swing.plaf.basic.BasicInternalFrameUI)getUI()).getNorthPane().setPreferredSize( new java.awt.Dimension(0,15) ); 
    

        this.jList1.setModel(new DefaultListModel());
        ((DefaultListModel)this.jList1.getModel()).addElement("Field1");
        ((DefaultListModel)this.jList1.getModel()).addElement("Field2");
        ((DefaultListModel)this.jList1.getModel()).addElement("Field3");
        ((DefaultListModel)this.jList1.getModel()).addElement("Field4");
        ((DefaultListModel)this.jList1.getModel()).addElement("Field5");
        ((DefaultListModel)this.jList1.getModel()).addElement("Field6");
        ((DefaultListModel)this.jList1.getModel()).addElement("Field7");
        ((DefaultListModel)this.jList1.getModel()).addElement("Field8");
        ((DefaultListModel)this.jList1.getModel()).addElement("Field9");
        ((DefaultListModel)this.jList1.getModel()).addElement("Field10");
        this.dragSource = DragSource.getDefaultDragSource();
        this.dgListener = new java.awt.dnd.DragGestureListener(){
            public void dragGestureRecognized(DragGestureEvent dge)
            {
                jList1dragGestureRecognized(dge);
            }
        };
        this.dsListener = new DSListener();
        /*
        new DragSourceListener(){
            public void dragDropEnd(DragSourceDropEvent dsde) {} 
            public void dragEnter(DragSourceDragEvent dsde) {}
            public void dragExit(DragSourceEvent dse) {}
            public void dragOver(DragSourceDragEvent dsde) {}
            public void dropActionChanged(DragSourceDragEvent dsde){}
        };
         **/
        
        this.dragSource.createDefaultDragGestureRecognizer(
        this, DnDConstants.ACTION_COPY_OR_MOVE, this.dgListener );
        
        jList1.setDragEnabled(true);
        jList1.setTransferHandler(new it.businesslogic.ireport.gui.dnd.ListColumnTransferableHandler());
    }
    
    private DragSource dragSource;
    private DragGestureListener dgListener;
    private DragSourceListener dsListener;

    public void jList1dragGestureRecognized(DragGestureEvent dge)
    {
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();

        setBackground(new java.awt.Color(255, 255, 255));
        setResizable(true);
        setTitle("My Table");
        setFrameIcon(null);
        addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                formMouseDragged(evt);
            }
        });

        jList1.setDragEnabled(true);
        jList1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jList1MouseDragged(evt);
            }
        });

        jScrollPane1.setViewportView(jList1);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void jList1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jList1MouseDragged
        JComponent c = (JComponent)evt.getSource();
        TransferHandler handler = c.getTransferHandler();
        handler.exportAsDrag(c, evt, TransferHandler.COPY);
    }//GEN-LAST:event_jList1MouseDragged

    private void formMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseDragged
        
    }//GEN-LAST:event_formMouseDragged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList jList1;
    // End of variables declaration//GEN-END:variables
    
    
    class DSListener implements DragSourceListener {
    
    /**
     * @param e the event
     */
    public void dragDropEnd(DragSourceDropEvent e) {
      if( e.getDropSuccess() == false ) {
	System.out.println( "not successful");
	return;
      }

      /*
       * the dropAction should be what the drop target specified
       * in acceptDrop
       */
      System.out.println( "dragdropend action " + e.getDropAction() );

      // this is the action selected by the drop target
      //if(e.getDropAction() == DnDConstants.ACTION_MOVE)
      //DragLabel.this.setText("");
    }

    /**
     * @param e the event
     */
    public void dragEnter(DragSourceDragEvent e) {
      System.out.println( "draglabel enter " + e);
      DragSourceContext context = e.getDragSourceContext();
      //intersection of the users selected action, and the source and target actions
      int myaction = e.getDropAction();
      //if( (myaction & 1) != 0) {	
	context.setCursor(DragSource.DefaultCopyDrop);	  
      //} else {
	//context.setCursor(DragSource.DefaultCopyNoDrop);	  	
      //}
    }
    /**
     * @param e the event
     */
    public void dragOver(DragSourceDragEvent e) {
      DragSourceContext context = e.getDragSourceContext();
      int sa = context.getSourceActions();
      int ua = e.getUserAction();
      int da = e.getDropAction();
      int ta = e.getTargetActions();
      System.out.println("dl dragOver source actions" + sa);
      System.out.println("user action" + ua);
      System.out.println("drop actions" + da);
      System.out.println("target actions" + ta);      
    }
    /**
     * @param e the event
     */
    public void dragExit(DragSourceEvent e) {
      System.out.println( "draglabel exit " + e);      
      DragSourceContext context = e.getDragSourceContext();
    }

    /**
     * for example, press shift during drag to change to
     * a link action
     * @param e the event     
     */
    public void dropActionChanged (DragSourceDragEvent e) {
      DragSourceContext context = e.getDragSourceContext();      
      context.setCursor(DragSource.DefaultCopyNoDrop);	  	
    }
  }
}

