/*
 * JRDataSourceProviderConnection.java
 *
 * Created on 17 febbraio 2005, 7.26
 */

package it.businesslogic.ireport.connection;


import net.sf.jasperreports.engine.*;
import javax.swing.*;
import it.businesslogic.ireport.gui.MainFrame;
/**
 *
 * @author  Administrator
 */
public class JRDataSourceProviderConnection extends it.businesslogic.ireport.IReportConnection {
    
    
    private net.sf.jasperreports.engine.JRDataSourceProvider dsp;
    private net.sf.jasperreports.engine.JRDataSource ds;
    private java.util.HashMap properties = new java.util.HashMap();
    
    public  net.sf.jasperreports.engine.JRDataSourceProvider getDataSourceProvider() {
        
        if (dsp == null && this.getProperties().get("JRDataSourceProvider") != null)
        {
            try {
                dsp = (JRDataSourceProvider)(Class.forName( (String)this.getProperties().get("JRDataSourceProvider"))).newInstance();
            } catch (NoClassDefFoundError ex)
	    {
		JOptionPane.showMessageDialog(MainFrame.getMainInstance(),"NoClassDefFoundError!!\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
            } 
	    catch (ClassNotFoundException ex)
	    {
		JOptionPane.showMessageDialog(MainFrame.getMainInstance(),"ClassNotFoundError:\n"+ ex.getMessage() +"\n\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
            } 
            catch (Exception ex)
            {
                JOptionPane.showMessageDialog(MainFrame.getMainInstance(),"Exception:\n"+ ex.getMessage() +"\n","Error",JOptionPane.ERROR_MESSAGE);
            }
        }
        
        return dsp;
    }
    
    public String getDescription(){ return "JasperReports DataSource Provider"; }
    
    /** Creates a new instance of JRDataSourceProviderConnection */
    public JRDataSourceProviderConnection() {
    }
    
        /**
     *  This method return an instanced JRDataDource to the database.
     *  If isJDBCConnection() return true => getJRDataSource() return false
     */
    public net.sf.jasperreports.engine.JRDataSource getJRDataSource() { 
        
        return getJRDataSource(null);
    }
    
    public net.sf.jasperreports.engine.JRDataSource getJRDataSource(JasperReport jasper) { 
        
        if (ds != null)
        {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(),"This datasource is already in use by another filling process!!","Error",JOptionPane.ERROR_MESSAGE);
            return null;
        }
        
        try {
            ds = getDataSourceProvider().create(jasper);
        } catch (Exception ex)
        {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(),"Problems occurred creating the new datasource!!\n" + ex.getMessage(),"Error",JOptionPane.ERROR_MESSAGE);
        }
        
        return ds;
    }
    
    public void disposeDataSource()
    {
            if (dsp != null)
            {
                try {
                    dsp.dispose(ds);
                } catch (Exception ex) {}
                ds = null;
            }
    }
    
    public java.util.HashMap getProperties()
    {
        return properties;
    }
    
    /** All properties of a IReportConnection are stored in a XML file as Pair key/value
     *  This HashMap contains alla properties found for this IReportConnection in the
     *  XML. You must use this hashMap to initialize all attributes of your IReprotConnection
     */
    public void loadProperties(java.util.HashMap map)
    {
        properties = map;
    }
    
    /** Redefine this method is not useful (and not raccomended)
     *  It just write a portion of XML for save properties a IReportConnection name
     */
    public void save(java.io.PrintWriter pw)
    {
        java.util.HashMap hm = this.getProperties();
        pw.println("\t<iReportConnection name=\""+ this.getName() +"\" connectionClass=\"" + this.getClass().getName() +"\">");
        java.util.Iterator iterator = hm.keySet().iterator();
        
        while (iterator.hasNext())
        {
            String key = (String)iterator.next();
            pw.println("\t\t<connectionParameter name=\""  +  key + "\"><![CDATA[" + hm.get(key) + "]]></connectionParameter>");
        }
        pw.println("\t</iReportConnection>");
    }    
    
}
