/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;

public class PdfStamper {
    protected PdfStamperImp stamper;
    private HashMap moreInfo;

    public PdfStamper(PdfReader pdfReader, OutputStream outputStream) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(pdfReader, outputStream, '\u0000');
    }

    public PdfStamper(PdfReader pdfReader, OutputStream outputStream, char c) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(pdfReader, outputStream, c);
    }

    public HashMap getMoreInfo() {
        return this.moreInfo;
    }

    public void setMoreInfo(HashMap hashMap) {
        this.moreInfo = hashMap;
    }

    public void close() throws DocumentException, IOException {
        this.stamper.close(this.moreInfo);
    }

    public PdfContentByte getUnderContent(int n) {
        return this.stamper.getUnderContent(n);
    }

    public PdfContentByte getOverContent(int n) {
        return this.stamper.getOverContent(n);
    }

    public boolean isRotateContents() {
        return this.stamper.isRotateContents();
    }

    public void setRotateContents(boolean bl) {
        this.stamper.setRotateContents(bl);
    }

    public void setEncryption(byte[] byArray, byte[] byArray2, int n, boolean bl) throws DocumentException {
        if (this.stamper.isContentWritten()) {
            throw new DocumentException("Content was already written to the output.");
        }
        this.stamper.setEncryption(byArray, byArray2, n, bl);
    }

    public void setEncryption(boolean bl, String string, String string2, int n) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(string), DocWriter.getISOBytes(string2), n, bl);
    }

    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n) {
        return this.stamper.getImportedPage(pdfReader, n);
    }

    public PdfWriter getWriter() {
        return this.stamper;
    }

    public AcroFields getAcroFields() {
        return this.stamper.getAcroFields();
    }

    public void setFormFlattening(boolean bl) {
        this.stamper.setFormFlattening(bl);
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        this.stamper.addAnnotation(pdfAnnotation, n);
    }

    public void setOutlines(List list) throws IOException {
        this.stamper.setOutlines(list);
    }

    public boolean partialFormFlattening(String string) {
        return this.stamper.partialFormFlattening(string);
    }
}

