/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTableEvent;
import java.util.ArrayList;

public class PdfPTable
implements Element {
    public static final int BASECANVAS = 0;
    public static final int BACKGROUNDCANVAS = 1;
    public static final int LINECANVAS = 2;
    public static final int TEXTCANVAS = 3;
    protected ArrayList rows = new ArrayList();
    protected float totalHeight = 0.0f;
    protected PdfPCell[] currentRow;
    protected int currentRowIdx = 0;
    protected PdfPCell defaultCell = new PdfPCell((Phrase)null);
    protected float totalWidth = 0.0f;
    protected float[] relativeWidths;
    protected float[] absoluteWidths;
    protected PdfPTableEvent tableEvent;
    protected int headerRows;
    protected float widthPercentage = 80.0f;
    private int horizontalAlignment = 1;
    private boolean skipFirstHeader = false;
    protected boolean isColspan = false;
    protected int runDirection = 0;

    public PdfPTable(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException("The widths array in PdfPTable constructor can not be null.");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("The widths array in PdfPTable constructor can not have zero length.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
    }

    public PdfPTable(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The number of columns in PdfPTable constructor must be greater than zero.");
        }
        this.relativeWidths = new float[n];
        for (int i = 0; i < n; ++i) {
            this.relativeWidths[i] = 1.0f;
        }
        this.absoluteWidths = new float[this.relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
    }

    public PdfPTable(PdfPTable pdfPTable) {
        int n;
        this.relativeWidths = new float[pdfPTable.relativeWidths.length];
        this.absoluteWidths = new float[pdfPTable.relativeWidths.length];
        System.arraycopy(pdfPTable.relativeWidths, 0, this.relativeWidths, 0, this.relativeWidths.length);
        System.arraycopy(pdfPTable.absoluteWidths, 0, this.absoluteWidths, 0, this.relativeWidths.length);
        this.totalWidth = pdfPTable.totalWidth;
        this.totalHeight = pdfPTable.totalHeight;
        this.currentRowIdx = pdfPTable.currentRowIdx;
        this.tableEvent = pdfPTable.tableEvent;
        this.runDirection = pdfPTable.runDirection;
        this.defaultCell = new PdfPCell(pdfPTable.defaultCell);
        this.currentRow = new PdfPCell[pdfPTable.currentRow.length];
        this.isColspan = pdfPTable.isColspan;
        for (n = 0; n < this.currentRow.length && pdfPTable.currentRow[n] != null; ++n) {
            this.currentRow[n] = new PdfPCell(pdfPTable.currentRow[n]);
        }
        for (n = 0; n < pdfPTable.rows.size(); ++n) {
            this.rows.add(new PdfPRow((PdfPRow)pdfPTable.rows.get(n)));
        }
    }

    public void setWidths(float[] fArray) throws DocumentException {
        if (fArray.length != this.relativeWidths.length) {
            throw new DocumentException("Wrong number of columns.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights();
    }

    public void setWidths(int[] nArray) throws DocumentException {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fArray[i] = nArray[i];
        }
        this.setWidths(fArray);
    }

    private void calculateWidths() {
        int n;
        if (this.totalWidth <= 0.0f) {
            return;
        }
        float f = 0.0f;
        for (n = 0; n < this.absoluteWidths.length; ++n) {
            f += this.relativeWidths[n];
        }
        for (n = 0; n < this.absoluteWidths.length; ++n) {
            this.absoluteWidths[n] = this.totalWidth * this.relativeWidths[n] / f;
        }
    }

    public void setTotalWidth(float f) {
        if (this.totalWidth == f) {
            return;
        }
        this.totalWidth = f;
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights();
    }

    public void setTotalWidth(float[] fArray) throws DocumentException {
        if (fArray.length != this.relativeWidths.length) {
            throw new DocumentException("Wrong number of columns.");
        }
        this.totalWidth = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            this.totalWidth += fArray[i];
        }
        this.setWidths(fArray);
    }

    public void setWidthPercentage(float[] fArray, Rectangle rectangle) throws DocumentException {
        if (fArray.length != this.relativeWidths.length) {
            throw new IllegalArgumentException("Wrong number of columns.");
        }
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
        }
        this.widthPercentage = f / (rectangle.right() - rectangle.left()) * 100.0f;
        this.setWidths(fArray);
    }

    public float getTotalWidth() {
        return this.totalWidth;
    }

    void calculateHeights() {
        if (this.totalWidth <= 0.0f) {
            return;
        }
        this.totalHeight = 0.0f;
        for (int i = 0; i < this.rows.size(); ++i) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i);
            pdfPRow.setWidths(this.absoluteWidths);
            this.totalHeight += pdfPRow.getMaxHeights();
        }
    }

    public PdfPCell getDefaultCell() {
        return this.defaultCell;
    }

    public void addCell(PdfPCell pdfPCell) {
        int n;
        PdfPCell pdfPCell2 = new PdfPCell(pdfPCell);
        int n2 = pdfPCell2.getColspan();
        n2 = Math.max(n2, 1);
        n2 = Math.min(n2, this.currentRow.length - this.currentRowIdx);
        pdfPCell2.setColspan(n2);
        if (n2 != 1) {
            this.isColspan = true;
        }
        if ((n = pdfPCell2.getRunDirection()) == 0) {
            pdfPCell2.setRunDirection(this.runDirection);
        }
        this.currentRow[this.currentRowIdx] = pdfPCell2;
        this.currentRowIdx += n2;
        if (this.currentRowIdx >= this.currentRow.length) {
            Object object;
            if (this.runDirection == 3) {
                object = new PdfPCell[this.absoluteWidths.length];
                int n3 = this.currentRow.length;
                for (int i = 0; i < this.currentRow.length; ++i) {
                    PdfPCell pdfPCell3 = this.currentRow[i];
                    int n4 = pdfPCell3.getColspan();
                    object[n3 -= n4] = pdfPCell3;
                    i += n4 - 1;
                }
                this.currentRow = object;
            }
            object = new PdfPRow(this.currentRow);
            if (this.totalWidth > 0.0f) {
                ((PdfPRow)object).setWidths(this.absoluteWidths);
                this.totalHeight += ((PdfPRow)object).getMaxHeights();
            }
            this.rows.add(object);
            this.currentRow = new PdfPCell[this.absoluteWidths.length];
            this.currentRowIdx = 0;
        }
    }

    public void addCell(String string) {
        this.addCell(new Phrase(string));
    }

    public void addCell(PdfPTable pdfPTable) {
        this.defaultCell.setTable(pdfPTable);
        this.addCell(this.defaultCell);
        this.defaultCell.setTable(null);
    }

    public void addCell(Image image) {
        this.defaultCell.setImage(image);
        this.addCell(this.defaultCell);
        this.defaultCell.setImage(null);
    }

    public void addCell(Phrase phrase) {
        this.defaultCell.setPhrase(phrase);
        this.addCell(this.defaultCell);
        this.defaultCell.setPhrase(null);
    }

    public float writeSelectedRows(int n, int n2, float f, float f2, PdfContentByte[] pdfContentByteArray) {
        return this.writeSelectedRows(0, -1, n, n2, f, f2, pdfContentByteArray);
    }

    public float writeSelectedRows(int n, int n2, int n3, int n4, float f, float f2, PdfContentByte[] pdfContentByteArray) {
        if (this.totalWidth <= 0.0f) {
            throw new RuntimeException("The table width must be greater than zero.");
        }
        int n5 = this.rows.size();
        if (n4 < 0) {
            n4 = n5;
        }
        n4 = Math.min(n4, n5);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= n4) {
            return f2;
        }
        if (n2 < 0) {
            n2 = this.absoluteWidths.length;
        }
        n2 = Math.min(n2, this.absoluteWidths.length);
        if (n < 0) {
            n = 0;
        }
        n = Math.min(n, this.absoluteWidths.length);
        float f3 = f2;
        for (int i = n3; i < n4; ++i) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i);
            pdfPRow.writeCells(n, n2, f, f2, pdfContentByteArray);
            f2 -= pdfPRow.getMaxHeights();
        }
        if (this.tableEvent != null && n == 0 && n2 == this.absoluteWidths.length) {
            float[] fArray = new float[n4 - n3 + 1];
            fArray[0] = f3;
            for (int i = n3; i < n4; ++i) {
                PdfPRow pdfPRow = (PdfPRow)this.rows.get(i);
                fArray[i - n3 + 1] = fArray[i - n3] - pdfPRow.getMaxHeights();
            }
            this.tableEvent.tableLayout(this, this.getEventWidths(f, n3, n4, false), fArray, 0, n3, pdfContentByteArray);
        }
        return f2;
    }

    public float writeSelectedRows(int n, int n2, float f, float f2, PdfContentByte pdfContentByte) {
        return this.writeSelectedRows(0, -1, n, n2, f, f2, pdfContentByte);
    }

    public float writeSelectedRows(int n, int n2, int n3, int n4, float f, float f2, PdfContentByte pdfContentByte) {
        float f3;
        if (n2 < 0) {
            n2 = this.absoluteWidths.length;
        }
        n2 = Math.min(n2, this.absoluteWidths.length);
        if (n < 0) {
            n = 0;
        }
        if ((n = Math.min(n, this.absoluteWidths.length)) != 0 || n2 != this.absoluteWidths.length) {
            float f4 = 0.0f;
            for (int i = n; i < n2; ++i) {
                f4 += this.absoluteWidths[i];
            }
            pdfContentByte.saveState();
            f3 = 0.0f;
            float f5 = 0.0f;
            if (n == 0) {
                f3 = 10000.0f;
            }
            if (n2 == this.absoluteWidths.length) {
                f5 = 10000.0f;
            }
            pdfContentByte.rectangle(f - f3, -10000.0f, f4 + f3 + f5, 20000.0f);
            pdfContentByte.clip();
            pdfContentByte.newPath();
        }
        PdfContentByte[] pdfContentByteArray = PdfPTable.beginWritingRows(pdfContentByte);
        f3 = this.writeSelectedRows(n, n2, n3, n4, f, f2, pdfContentByteArray);
        PdfPTable.endWritingRows(pdfContentByteArray);
        if (n != 0 || n2 != this.absoluteWidths.length) {
            pdfContentByte.restoreState();
        }
        return f3;
    }

    public static PdfContentByte[] beginWritingRows(PdfContentByte pdfContentByte) {
        return new PdfContentByte[]{pdfContentByte, pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate()};
    }

    public static void endWritingRows(PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[0];
        pdfContentByte.saveState();
        pdfContentByte.add(pdfContentByteArray[1]);
        pdfContentByte.restoreState();
        pdfContentByte.saveState();
        pdfContentByte.setLineCap(2);
        pdfContentByte.resetRGBColorStroke();
        pdfContentByte.add(pdfContentByteArray[2]);
        pdfContentByte.restoreState();
        pdfContentByte.add(pdfContentByteArray[3]);
    }

    public int size() {
        return this.rows.size();
    }

    public float getTotalHeight() {
        return this.totalHeight;
    }

    public float getRowHeight(int n) {
        if (this.totalWidth <= 0.0f || n < 0 || n >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow pdfPRow = (PdfPRow)this.rows.get(n);
        return pdfPRow.getMaxHeights();
    }

    public float getHeaderHeight() {
        float f = 0.0f;
        int n = Math.min(this.rows.size(), this.headerRows);
        for (int i = 0; i < n; ++i) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(i);
            f += pdfPRow.getMaxHeights();
        }
        return f;
    }

    public boolean deleteRow(int n) {
        if (n < 0 || n >= this.rows.size()) {
            return false;
        }
        if (this.totalWidth > 0.0f) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(n);
            this.totalHeight -= pdfPRow.getMaxHeights();
        }
        this.rows.remove(n);
        return true;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public int getHeaderRows() {
        return this.headerRows;
    }

    public void setHeaderRows(int n) {
        if (n < 0) {
            n = 0;
        }
        this.headerRows = n;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public int type() {
        return 23;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(float f) {
        this.widthPercentage = f;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    PdfPRow getRow(int n) {
        return (PdfPRow)this.rows.get(n);
    }

    public void setTableEvent(PdfPTableEvent pdfPTableEvent) {
        this.tableEvent = pdfPTableEvent;
    }

    public PdfPTableEvent getTableEvent() {
        return this.tableEvent;
    }

    public float[] getAbsoluteWidths() {
        return this.absoluteWidths;
    }

    float[][] getEventWidths(float f, int n, int n2, boolean bl) {
        float[][] fArrayArray = new float[(bl ? this.headerRows : 0) + n2 - n][];
        if (this.isColspan) {
            int n3 = 0;
            if (bl) {
                for (int i = 0; i < this.headerRows; ++i) {
                    fArrayArray[n3++] = ((PdfPRow)this.rows.get(i)).getEventWidth(f);
                }
            }
            while (n < n2) {
                fArrayArray[n3++] = ((PdfPRow)this.rows.get(n)).getEventWidth(f);
                ++n;
            }
        } else {
            int n4;
            float[] fArray = new float[this.absoluteWidths.length + 1];
            fArray[0] = f;
            for (n4 = 0; n4 < this.absoluteWidths.length; ++n4) {
                fArray[n4 + 1] = fArray[n4] + this.absoluteWidths[n4];
            }
            for (n4 = 0; n4 < fArrayArray.length; ++n4) {
                fArrayArray[n4] = fArray;
            }
        }
        return fArrayArray;
    }

    public boolean getSkipFirstHeader() {
        return this.skipFirstHeader;
    }

    public void setSkipFirstHeader(boolean bl) {
        this.skipFirstHeader = bl;
    }

    public void setRunDirection(int n) {
        if (n < 0 || n > 3) {
            throw new RuntimeException("Invalid run direction: " + n);
        }
        this.runDirection = n;
    }

    public int getRunDirection() {
        return this.runDirection;
    }
}

