/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.view.JRDesignViewer;

public class JasperDesignViewer
extends JFrame {
    private JPanel pnlMain;

    public JasperDesignViewer(String sourceFile, boolean isXML) throws JRException {
        this.initComponents();
        JRDesignViewer viewer = new JRDesignViewer(sourceFile, isXML);
        this.pnlMain.add((Component)viewer, "Center");
    }

    public JasperDesignViewer(InputStream is, boolean isXML) throws JRException {
        this.initComponents();
        JRDesignViewer viewer = new JRDesignViewer(is, isXML);
        this.pnlMain.add((Component)viewer, "Center");
    }

    public JasperDesignViewer(JRReport report) throws JRException {
        this.initComponents();
        JRDesignViewer viewer = new JRDesignViewer(report);
        this.pnlMain.add((Component)viewer, "Center");
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.setTitle("JasperDesignViewer");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/jricon.GIF")).getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JasperDesignViewer.this.exitForm(evt);
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(750, 550));
        this.setLocation((screenSize.width - 750) / 2, (screenSize.height - 550) / 2);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        String fileName = null;
        boolean isXMLFile = false;
        if (args.length == 0) {
            JasperDesignViewer.usage();
            return;
        }
        for (int k = 0; args.length > k; ++k) {
            if (args[k].startsWith("-F")) {
                fileName = args[k].substring(2);
            }
            if (!args[k].startsWith("-XML")) continue;
            isXMLFile = true;
        }
        try {
            JasperDesignViewer.viewReportDesign(fileName, isXMLFile);
        }
        catch (JRException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("JasperDesignViewer usage:");
        System.out.println("\tjava JasperDesignViewer -XML -Ffile");
    }

    public static void viewReportDesign(String sourceFile, boolean isXML) throws JRException {
        JasperDesignViewer jasperDesignViewer = new JasperDesignViewer(sourceFile, isXML);
        jasperDesignViewer.show();
    }

    public static void viewReportDesign(InputStream is, boolean isXML) throws JRException {
        JasperDesignViewer jasperDesignViewer = new JasperDesignViewer(is, isXML);
        jasperDesignViewer.show();
    }

    public static void viewReportDesign(JRReport report) throws JRException {
        JasperDesignViewer jasperDesignViewer = new JasperDesignViewer(report);
        jasperDesignViewer.show();
    }
}

