/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.math.BigDecimal;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRBigDecimalIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRIncrementer;

class JRBigDecimalVarianceIncrementer
implements JRIncrementer {
    private static JRBigDecimalVarianceIncrementer mainInstance = new JRBigDecimalVarianceIncrementer();

    private JRBigDecimalVarianceIncrementer() {
    }

    public static JRBigDecimalVarianceIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRFillVariable variable, Object expressionValue, AbstractValueProvider valueProvider) throws JRException {
        BigDecimal value = (BigDecimal)variable.getIncrementedValue();
        BigDecimal newValue = (BigDecimal)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            return JRBigDecimalIncrementerFactory.ZERO;
        }
        BigDecimal countValue = (BigDecimal)valueProvider.getValue((JRFillVariable)variable.getCountVariable());
        BigDecimal sumValue = (BigDecimal)valueProvider.getValue((JRFillVariable)variable.getSumVariable());
        return countValue.subtract(JRBigDecimalIncrementerFactory.ONE).multiply(value).divide(countValue, 4).add(sumValue.divide(countValue, 4).subtract(newValue).multiply(sumValue.divide(countValue, 4).subtract(newValue)).divide(countValue.subtract(JRBigDecimalIncrementerFactory.ONE), 4));
    }
}

