/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRVerifier {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$design$JRVerifier == null ? (class$net$sf$jasperreports$engine$design$JRVerifier = JRVerifier.class$("net.sf.jasperreports.engine.design.JRVerifier")) : class$net$sf$jasperreports$engine$design$JRVerifier));
    private static String[] queryParameterClassNames = null;
    private static String[] fieldClassNames = null;
    private static String[] textFieldClassNames = null;
    private static String[] imageClassNames = null;
    private static String[] subreportClassNames = null;
    private JasperDesign jasperDesign = null;
    private Collection brokenRules = null;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$design$JRVerifier;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRDataSource;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRRenderable;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JasperReport;

    protected JRVerifier(JasperDesign jrDesign) {
        this.jasperDesign = jrDesign;
        this.brokenRules = new ArrayList();
    }

    public static Collection verifyDesign(JasperDesign jasperDesign) throws JRException {
        JRVerifier verifier = new JRVerifier(jasperDesign);
        return verifier.verifyDesign();
    }

    protected Collection verifyDesign() throws JRException {
        this.verifyDesignAttributes();
        this.verifyExpressions();
        this.verifyReportFonts();
        this.verifyParameters();
        this.verifyQuery();
        this.verifyFields();
        this.verifyVariables();
        this.verifyGroups();
        this.verifyBand(this.jasperDesign.getBackground());
        this.verifyBand(this.jasperDesign.getTitle());
        this.verifyBand(this.jasperDesign.getPageHeader());
        this.verifyBand(this.jasperDesign.getColumnHeader());
        this.verifyBand(this.jasperDesign.getDetail());
        this.verifyBand(this.jasperDesign.getColumnFooter());
        this.verifyBand(this.jasperDesign.getPageFooter());
        this.verifyBand(this.jasperDesign.getLastPageFooter());
        this.verifyBand(this.jasperDesign.getSummary());
        return this.brokenRules;
    }

    private void verifyDesignAttributes() throws JRException {
        if (this.jasperDesign.getName() == null || this.jasperDesign.getName().trim().length() == 0) {
            this.brokenRules.add("Report name is missing.");
        }
        if (this.jasperDesign.getColumnCount() <= 0) {
            this.brokenRules.add("Column count must be greater than zero.");
        }
        if (this.jasperDesign.getPageWidth() < 0) {
            this.brokenRules.add("Page width must be positive.");
        }
        if (this.jasperDesign.getPageHeight() < 0) {
            this.brokenRules.add("Page height must be positive.");
        }
        if (this.jasperDesign.getColumnWidth() < 0) {
            this.brokenRules.add("Column width must be positive.");
        }
        if (this.jasperDesign.getColumnSpacing() < 0) {
            this.brokenRules.add("Column spacing must be positive.");
        }
        if (this.jasperDesign.getLeftMargin() < 0) {
            this.brokenRules.add("Left margin must be positive.");
        }
        if (this.jasperDesign.getRightMargin() < 0) {
            this.brokenRules.add("Right margin must be positive.");
        }
        if (this.jasperDesign.getTopMargin() < 0) {
            this.brokenRules.add("Top margin must be positive.");
        }
        if (this.jasperDesign.getBottomMargin() < 0) {
            this.brokenRules.add("Bottom margin must be positive.");
        }
        if (this.jasperDesign.getLeftMargin() + this.jasperDesign.getColumnCount() * this.jasperDesign.getColumnWidth() + (this.jasperDesign.getColumnCount() - 1) * this.jasperDesign.getColumnSpacing() + this.jasperDesign.getRightMargin() > this.jasperDesign.getPageWidth()) {
            this.brokenRules.add("The columns and the margins do not fit the page width.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getBackground() != null ? this.jasperDesign.getBackground().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The background section and the margins do not fit the page height.");
        }
        if (this.jasperDesign.isTitleNewPage()) {
            if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                this.brokenRules.add("The title section and the margins do not fit the page height.");
            }
        } else if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The title section, the page and column headers and footers and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The page and column headers and footers and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getLastPageFooter() != null ? this.jasperDesign.getLastPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The page and column headers and footers and the margins do not fit the last page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getSummary() != null ? this.jasperDesign.getSummary().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The summary section and the margins do not fit the page height.");
        }
        if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (this.jasperDesign.getDetail() != null ? this.jasperDesign.getDetail().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
            this.brokenRules.add("The detail section, the page and column headers and footers and the margins do not fit the page height.");
        }
    }

    private void verifyQuery() throws JRException {
        JRQueryChunk[] chunks;
        JRQuery query = this.jasperDesign.getQuery();
        if (query != null && (chunks = query.getChunks()) != null && chunks.length > 0) {
            Map parametersMap = this.jasperDesign.getParametersMap();
            block3: for (int j = 0; j < chunks.length; ++j) {
                JRQueryChunk queryChunk = chunks[j];
                switch (queryChunk.getType()) {
                    case 2: {
                        JRParameter parameter = (JRParameter)parametersMap.get(queryChunk.getText());
                        if (parameter == null) {
                            this.brokenRules.add("Query parameter not found : " + queryChunk.getText());
                            continue block3;
                        }
                        if (Arrays.binarySearch(JRVerifier.getQueryParameterClassNames(), parameter.getValueClassName()) >= 0) continue block3;
                        this.brokenRules.add("Parameter type not supported in query : " + queryChunk.getText() + " class " + parameter.getValueClassName());
                        continue block3;
                    }
                }
            }
        }
    }

    private void verifyExpressions() throws JRException {
        Collection expressions = this.jasperDesign.getExpressions();
        if (expressions != null && expressions.size() > 0) {
            Map parametersMap = this.jasperDesign.getParametersMap();
            Map fieldsMap = this.jasperDesign.getFieldsMap();
            Map variablesMap = this.jasperDesign.getVariablesMap();
            Iterator it = expressions.iterator();
            while (it.hasNext()) {
                JRExpression expression = (JRExpression)it.next();
                JRExpressionChunk[] chunks = expression.getChunks();
                if (chunks == null || chunks.length <= 0) continue;
                block6: for (int j = 0; j < chunks.length; ++j) {
                    JRExpressionChunk expressionChunk = chunks[j];
                    switch (expressionChunk.getType()) {
                        case 4: {
                            if (variablesMap.containsKey(expressionChunk.getText())) continue block6;
                            this.brokenRules.add("Variable not found : " + expressionChunk.getText());
                            continue block6;
                        }
                        case 3: {
                            if (fieldsMap.containsKey(expressionChunk.getText())) continue block6;
                            this.brokenRules.add("Field not found : " + expressionChunk.getText());
                            continue block6;
                        }
                        case 2: {
                            if (parametersMap.containsKey(expressionChunk.getText())) continue block6;
                            this.brokenRules.add("Parameter not found : " + expressionChunk.getText());
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    private void verifyReportFonts() throws JRException {
        JRReportFont[] fonts = this.jasperDesign.getFonts();
        if (fonts != null && fonts.length > 0) {
            for (int index = 0; index < fonts.length; ++index) {
                JRReportFont font = fonts[index];
                if (font.getName() != null && font.getName().trim().length() != 0) continue;
                this.brokenRules.add("Report font name missing.");
            }
        }
    }

    private void verifyParameters() throws JRException {
        JRParameter[] parameters = this.jasperDesign.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int index = 0; index < parameters.length; ++index) {
                Class valueClass;
                JRParameter parameter = parameters[index];
                if (parameter.getName() == null || parameter.getName().trim().length() == 0) {
                    this.brokenRules.add("Parameter name missing.");
                }
                if ((valueClass = parameter.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for parameter : " + parameter.getName());
                    continue;
                }
                JRExpression expression = parameter.getDefaultValueExpression();
                if (expression == null || valueClass.isAssignableFrom(expression.getValueClass())) continue;
                this.brokenRules.add("The parameter default value expression class is not compatible with the parameter's class : " + parameter.getName());
            }
        }
    }

    private void verifyFields() throws JRException {
        JRField[] fields = this.jasperDesign.getFields();
        if (fields != null && fields.length > 0) {
            for (int index = 0; index < fields.length; ++index) {
                String className;
                JRField field = fields[index];
                if (field.getName() == null || field.getName().trim().length() == 0) {
                    this.brokenRules.add("Field name missing.");
                }
                if ((className = field.getValueClassName()) == null) {
                    this.brokenRules.add("Class not set for field : " + field.getName());
                    continue;
                }
                if (Arrays.binarySearch(JRVerifier.getFieldClassNames(), className) >= 0) continue;
                this.brokenRules.add("Class \"" + className + "\" not supported for field : " + field.getName() + ". Use java.lang.Object instead.");
            }
        }
    }

    private void verifyVariables() throws JRException {
        JRVariable[] variables = this.jasperDesign.getVariables();
        if (variables != null && variables.length > 0) {
            for (int index = 0; index < variables.length; ++index) {
                Map groupsMap;
                Class valueClass;
                JRVariable variable = variables[index];
                if (variable.getName() == null || variable.getName().trim().length() == 0) {
                    this.brokenRules.add("Variable name missing.");
                }
                if ((valueClass = variable.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for variable : " + variable.getName());
                } else {
                    JRExpression expression = variable.getExpression();
                    if (expression != null && variable.getCalculation() != 1 && variable.getCalculation() != 8 && !valueClass.isAssignableFrom(expression.getValueClass())) {
                        this.brokenRules.add("The variable expression class is not compatible with the variable's class : " + variable.getName());
                    }
                    if (variable.getInitialValueExpression() != null && !valueClass.isAssignableFrom(variable.getInitialValueExpression().getValueClass())) {
                        this.brokenRules.add("The initial value class is not compatible with the variable's class : " + variable.getName());
                    }
                }
                if (variable.getResetType() == 4) {
                    if (variable.getResetGroup() == null) {
                        this.brokenRules.add("Reset group missing for variable : " + variable.getName());
                    } else {
                        groupsMap = this.jasperDesign.getGroupsMap();
                        if (!groupsMap.containsKey(variable.getResetGroup().getName())) {
                            this.brokenRules.add("Reset group \"" + variable.getResetGroup().getName() + "\" not found for variable : " + variable.getName());
                        }
                    }
                }
                if (variable.getIncrementType() != 4) continue;
                if (variable.getIncrementGroup() == null) {
                    this.brokenRules.add("Increment group missing for variable : " + variable.getName());
                    continue;
                }
                groupsMap = this.jasperDesign.getGroupsMap();
                if (groupsMap.containsKey(variable.getIncrementGroup().getName())) continue;
                this.brokenRules.add("Increment group \"" + variable.getIncrementGroup().getName() + "\" not found for variable : " + variable.getName());
            }
        }
    }

    private void verifyGroups() throws JRException {
        JRGroup[] groups = this.jasperDesign.getGroups();
        if (groups != null && groups.length > 0) {
            for (int index = 0; index < groups.length; ++index) {
                Class clazz;
                JRExpression expression;
                JRGroup group = groups[index];
                if (group.getName() == null || group.getName().trim().length() == 0) {
                    this.brokenRules.add("Group name missing.");
                }
                if (this.jasperDesign.isTitleNewPage()) {
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                        this.brokenRules.add("The '" + group.getName() + "' group header section, the page and column headers and footers and the margins do not fit the page height.");
                    }
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                        this.brokenRules.add("The '" + group.getName() + "' group footer section, the page and column headers and footers and the margins do not fit the page height.");
                    }
                } else {
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                        this.brokenRules.add("The '" + group.getName() + "' group header section, the title, the page and column headers and footers and the margins do not fit the first page height.");
                    }
                    if (this.jasperDesign.getTopMargin() + (this.jasperDesign.getTitle() != null ? this.jasperDesign.getTitle().getHeight() : 0) + (this.jasperDesign.getPageHeader() != null ? this.jasperDesign.getPageHeader().getHeight() : 0) + (this.jasperDesign.getColumnHeader() != null ? this.jasperDesign.getColumnHeader().getHeight() : 0) + (group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0) + (this.jasperDesign.getColumnFooter() != null ? this.jasperDesign.getColumnFooter().getHeight() : 0) + (this.jasperDesign.getPageFooter() != null ? this.jasperDesign.getPageFooter().getHeight() : 0) + this.jasperDesign.getBottomMargin() > this.jasperDesign.getPageHeight()) {
                        this.brokenRules.add("The '" + group.getName() + "' group footer section, the title, the page and column headers and footers and the margins do not fit the first page height.");
                    }
                }
                if ((expression = group.getExpression()) != null && (clazz = expression.getValueClass()) == null) {
                    this.brokenRules.add("Class not set for group expression : " + group.getName());
                }
                this.verifyBand(group.getGroupHeader());
                this.verifyBand(group.getGroupFooter());
            }
        }
    }

    private void verifyBand(JRBand band) throws JRException {
        JRElement[] elements;
        if (band != null && (elements = band.getElements()) != null && elements.length > 0) {
            JRExpression expression = band.getPrintWhenExpression();
            if (expression != null) {
                Class clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for band \"print when\" expression.");
                } else if (!(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRVerifier.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for band \"print when\" expression. Use java.lang.Boolean instead.");
                }
            }
            for (int index = 0; index < elements.length; ++index) {
                JRElement element = elements[index];
                expression = element.getPrintWhenExpression();
                if (expression != null) {
                    Class clazz = expression.getValueClass();
                    if (clazz == null) {
                        this.brokenRules.add("Class not set for element \"print when\" expression.");
                    } else if (!(class$java$lang$Boolean == null ? JRVerifier.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(clazz)) {
                        this.brokenRules.add("Class " + clazz + " not supported for element \"print when\" expression. Use java.lang.Boolean instead.");
                    }
                }
                if (element.getY() + element.getHeight() > band.getHeight() && log.isWarnEnabled()) {
                    log.warn((Object)("Warning : Element bottom reaches outside band area : y=" + element.getY() + " height=" + element.getHeight() + " band-height=" + band.getHeight()));
                }
                if (element instanceof JRTextField) {
                    this.verifyTextField((JRTextField)element);
                    continue;
                }
                if (element instanceof JRImage) {
                    this.verifyImage((JRImage)element);
                    continue;
                }
                if (!(element instanceof JRSubreport)) continue;
                this.verifySubreport((JRSubreport)element);
            }
        }
    }

    private void verifyTextField(JRTextField textField) throws JRException {
        JRExpression expression;
        this.verifyTextElement(textField);
        this.verifyAnchor(textField);
        this.verifyHyperlink(textField);
        if (textField != null && (expression = textField.getExpression()) != null) {
            String className = expression.getValueClassName();
            if (className == null) {
                this.brokenRules.add("Class not set for text field expression.");
            } else if (Arrays.binarySearch(JRVerifier.getTextFieldClassNames(), className) < 0) {
                this.brokenRules.add("Class \"" + className + "\" not supported for text field expression.");
            }
        }
    }

    private void verifyTextElement(JRTextElement textElement) throws JRException {
        Map fontsMap;
        JRReportFont reportFont;
        JRFont font;
        if (textElement != null && (font = textElement.getFont()) != null && (reportFont = font.getReportFont()) != null && reportFont.getName() != null && !(fontsMap = this.jasperDesign.getFontsMap()).containsKey(reportFont.getName())) {
            this.brokenRules.add("Report font not found : " + reportFont.getName());
        }
    }

    private void verifyAnchor(JRAnchor anchor) throws JRException {
        JRExpression expression;
        if (anchor != null && (expression = anchor.getAnchorNameExpression()) != null) {
            Class clazz = expression.getValueClass();
            if (clazz == null) {
                this.brokenRules.add("Class not set for anchor name expression.");
            } else if (!(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
                this.brokenRules.add("Class " + clazz + " not supported for anchor name expression. Use java.lang.String instead.");
            }
        }
    }

    private void verifyHyperlink(JRHyperlink hyperlink) throws JRException {
        if (hyperlink != null) {
            Class clazz;
            JRExpression expression = hyperlink.getHyperlinkReferenceExpression();
            if (expression != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink reference expression.");
                } else if (!(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink reference expression. Use java.lang.String instead.");
                }
            }
            if ((expression = hyperlink.getHyperlinkAnchorExpression()) != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink anchor expression.");
                } else if (!(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink anchor expression. Use java.lang.String instead.");
                }
            }
            if ((expression = hyperlink.getHyperlinkPageExpression()) != null) {
                clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for hyperlink page expression.");
                } else if (!(class$java$lang$Integer == null ? (class$java$lang$Integer = JRVerifier.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for hyperlink page expression. Use java.lang.Integer instead.");
                }
            }
        }
    }

    private void verifyImage(JRImage image) throws JRException {
        JRExpression expression;
        this.verifyAnchor(image);
        this.verifyHyperlink(image);
        if (image != null && (expression = image.getExpression()) != null) {
            String className = expression.getValueClassName();
            if (className == null) {
                this.brokenRules.add("Class not set for image expression.");
            } else if (Arrays.binarySearch(JRVerifier.getImageClassNames(), className) < 0) {
                this.brokenRules.add("Class \"" + className + "\" not supported for image expression.");
            }
        }
    }

    private void verifySubreport(JRSubreport subreport) throws JRException {
        if (subreport != null) {
            JRSubreportParameter[] parameters;
            JRExpression expression = subreport.getExpression();
            if (expression != null) {
                String className = expression.getValueClassName();
                if (className == null) {
                    this.brokenRules.add("Class not set for subreport expression.");
                } else if (Arrays.binarySearch(JRVerifier.getSubreportClassNames(), className) < 0) {
                    this.brokenRules.add("Class \"" + className + "\" not supported for subreport expression.");
                }
            }
            if ((expression = subreport.getParametersMapExpression()) != null) {
                Class clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport parameters map expression.");
                } else if (!(class$java$util$Map == null ? (class$java$util$Map = JRVerifier.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport parameters map expression. Use java.util.Map instead.");
                }
            }
            if ((parameters = subreport.getParameters()) != null && parameters.length > 0) {
                for (int index = 0; index < parameters.length; ++index) {
                    Class clazz;
                    JRSubreportParameter parameter = parameters[index];
                    if (parameter.getName() == null || parameter.getName().trim().length() == 0) {
                        this.brokenRules.add("Subreport parameter name missing.");
                    }
                    if ((expression = parameter.getExpression()) == null || (clazz = expression.getValueClass()) != null) continue;
                    this.brokenRules.add("Class not set for subreport parameter expression : " + parameter.getName() + ". Use java.lang.Object class.");
                }
            }
            if (subreport.getConnectionExpression() != null && subreport.getDataSourceExpression() != null) {
                this.brokenRules.add("Subreport cannot have both connection expresion and data source expression.");
            }
            if ((expression = subreport.getConnectionExpression()) != null) {
                Class clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport connection expression.");
                } else if (!(class$java$sql$Connection == null ? (class$java$sql$Connection = JRVerifier.class$("java.sql.Connection")) : class$java$sql$Connection).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport connection expression. Use java.sql.Connection instead.");
                }
            }
            if ((expression = subreport.getDataSourceExpression()) != null) {
                Class clazz = expression.getValueClass();
                if (clazz == null) {
                    this.brokenRules.add("Class not set for subreport data source expression.");
                } else if (!(class$net$sf$jasperreports$engine$JRDataSource == null ? (class$net$sf$jasperreports$engine$JRDataSource = JRVerifier.class$("net.sf.jasperreports.engine.JRDataSource")) : class$net$sf$jasperreports$engine$JRDataSource).isAssignableFrom(clazz)) {
                    this.brokenRules.add("Class " + clazz + " not supported for subreport data source expression. Use net.sf.jasperreports.engine.JRDataSource instead.");
                }
            }
        }
    }

    private static synchronized String[] getQueryParameterClassNames() {
        if (queryParameterClassNames == null) {
            queryParameterClassNames = new String[]{(class$java$lang$Object == null ? (class$java$lang$Object = JRVerifier.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRVerifier.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), (class$java$lang$Byte == null ? (class$java$lang$Byte = JRVerifier.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), (class$java$lang$Double == null ? (class$java$lang$Double = JRVerifier.class$("java.lang.Double")) : class$java$lang$Double).getName(), (class$java$lang$Float == null ? (class$java$lang$Float = JRVerifier.class$("java.lang.Float")) : class$java$lang$Float).getName(), (class$java$lang$Integer == null ? (class$java$lang$Integer = JRVerifier.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), (class$java$lang$Long == null ? (class$java$lang$Long = JRVerifier.class$("java.lang.Long")) : class$java$lang$Long).getName(), (class$java$lang$Short == null ? (class$java$lang$Short = JRVerifier.class$("java.lang.Short")) : class$java$lang$Short).getName(), (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRVerifier.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), (class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$util$Date == null ? (class$java$util$Date = JRVerifier.class$("java.util.Date")) : class$java$util$Date).getName(), (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRVerifier.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName(), (class$java$sql$Time == null ? (class$java$sql$Time = JRVerifier.class$("java.sql.Time")) : class$java$sql$Time).getName()};
            Arrays.sort(queryParameterClassNames);
        }
        return queryParameterClassNames;
    }

    private static synchronized String[] getFieldClassNames() {
        if (fieldClassNames == null) {
            fieldClassNames = new String[]{(class$java$lang$Object == null ? (class$java$lang$Object = JRVerifier.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRVerifier.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), (class$java$lang$Byte == null ? (class$java$lang$Byte = JRVerifier.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), (class$java$util$Date == null ? (class$java$util$Date = JRVerifier.class$("java.util.Date")) : class$java$util$Date).getName(), (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRVerifier.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName(), (class$java$sql$Time == null ? (class$java$sql$Time = JRVerifier.class$("java.sql.Time")) : class$java$sql$Time).getName(), (class$java$lang$Double == null ? (class$java$lang$Double = JRVerifier.class$("java.lang.Double")) : class$java$lang$Double).getName(), (class$java$lang$Float == null ? (class$java$lang$Float = JRVerifier.class$("java.lang.Float")) : class$java$lang$Float).getName(), (class$java$lang$Integer == null ? (class$java$lang$Integer = JRVerifier.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), (class$java$io$InputStream == null ? (class$java$io$InputStream = JRVerifier.class$("java.io.InputStream")) : class$java$io$InputStream).getName(), (class$java$lang$Long == null ? (class$java$lang$Long = JRVerifier.class$("java.lang.Long")) : class$java$lang$Long).getName(), (class$java$lang$Short == null ? (class$java$lang$Short = JRVerifier.class$("java.lang.Short")) : class$java$lang$Short).getName(), (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRVerifier.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), (class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).getName()};
            Arrays.sort(fieldClassNames);
        }
        return fieldClassNames;
    }

    private static synchronized String[] getTextFieldClassNames() {
        if (textFieldClassNames == null) {
            textFieldClassNames = new String[]{(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRVerifier.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), (class$java$lang$Byte == null ? (class$java$lang$Byte = JRVerifier.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), (class$java$util$Date == null ? (class$java$util$Date = JRVerifier.class$("java.util.Date")) : class$java$util$Date).getName(), (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JRVerifier.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName(), (class$java$sql$Time == null ? (class$java$sql$Time = JRVerifier.class$("java.sql.Time")) : class$java$sql$Time).getName(), (class$java$lang$Double == null ? (class$java$lang$Double = JRVerifier.class$("java.lang.Double")) : class$java$lang$Double).getName(), (class$java$lang$Float == null ? (class$java$lang$Float = JRVerifier.class$("java.lang.Float")) : class$java$lang$Float).getName(), (class$java$lang$Integer == null ? (class$java$lang$Integer = JRVerifier.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), (class$java$lang$Long == null ? (class$java$lang$Long = JRVerifier.class$("java.lang.Long")) : class$java$lang$Long).getName(), (class$java$lang$Short == null ? (class$java$lang$Short = JRVerifier.class$("java.lang.Short")) : class$java$lang$Short).getName(), (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JRVerifier.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), (class$java$lang$Number == null ? (class$java$lang$Number = JRVerifier.class$("java.lang.Number")) : class$java$lang$Number).getName(), (class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).getName()};
            Arrays.sort(textFieldClassNames);
        }
        return textFieldClassNames;
    }

    private static synchronized String[] getImageClassNames() {
        if (imageClassNames == null) {
            imageClassNames = new String[]{(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$io$File == null ? (class$java$io$File = JRVerifier.class$("java.io.File")) : class$java$io$File).getName(), (class$java$net$URL == null ? (class$java$net$URL = JRVerifier.class$("java.net.URL")) : class$java$net$URL).getName(), (class$java$io$InputStream == null ? (class$java$io$InputStream = JRVerifier.class$("java.io.InputStream")) : class$java$io$InputStream).getName(), (class$java$awt$Image == null ? (class$java$awt$Image = JRVerifier.class$("java.awt.Image")) : class$java$awt$Image).getName(), (class$net$sf$jasperreports$engine$JRRenderable == null ? (class$net$sf$jasperreports$engine$JRRenderable = JRVerifier.class$("net.sf.jasperreports.engine.JRRenderable")) : class$net$sf$jasperreports$engine$JRRenderable).getName()};
            Arrays.sort(imageClassNames);
        }
        return imageClassNames;
    }

    private static synchronized String[] getSubreportClassNames() {
        if (subreportClassNames == null) {
            subreportClassNames = new String[]{(class$java$lang$String == null ? (class$java$lang$String = JRVerifier.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$io$File == null ? (class$java$io$File = JRVerifier.class$("java.io.File")) : class$java$io$File).getName(), (class$java$net$URL == null ? (class$java$net$URL = JRVerifier.class$("java.net.URL")) : class$java$net$URL).getName(), (class$java$io$InputStream == null ? (class$java$io$InputStream = JRVerifier.class$("java.io.InputStream")) : class$java$io$InputStream).getName(), (class$net$sf$jasperreports$engine$JasperReport == null ? (class$net$sf$jasperreports$engine$JasperReport = JRVerifier.class$("net.sf.jasperreports.engine.JasperReport")) : class$net$sf$jasperreports$engine$JasperReport).getName()};
            Arrays.sort(subreportClassNames);
        }
        return subreportClassNames;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

