/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.HashMap;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;

public class JRTableModelDataSource
implements JRRewindableDataSource {
    private TableModel tableModel = null;
    private int index = -1;
    private HashMap columnNames = new HashMap();

    public JRTableModelDataSource(TableModel model) {
        this.tableModel = model;
        if (this.tableModel != null) {
            for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
                this.columnNames.put(this.tableModel.getColumnName(i), new Integer(i));
            }
        }
    }

    public boolean next() throws JRException {
        ++this.index;
        if (this.tableModel != null) {
            return this.index < this.tableModel.getRowCount();
        }
        return false;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        Integer columnIndex = (Integer)this.columnNames.get(fieldName);
        if (columnIndex != null) {
            return this.tableModel.getValueAt(this.index, columnIndex);
        }
        if (fieldName.startsWith("COLUMN_")) {
            return this.tableModel.getValueAt(this.index, Integer.parseInt(fieldName.substring(7)));
        }
        throw new JRException("Unknown column name : " + fieldName);
    }

    public void moveFirst() throws JRException {
        this.index = -1;
    }
}

