/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;

public class JRMapCollectionDataSource
implements JRRewindableDataSource {
    private Collection records = null;
    private Iterator iterator = null;
    private Map currentRecord = null;

    public JRMapCollectionDataSource(Collection col) {
        this.records = col;
        if (this.records != null) {
            this.iterator = this.records.iterator();
        }
    }

    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentRecord = (Map)this.iterator.next();
        }
        return hasNext;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (this.currentRecord != null) {
            value = this.currentRecord.get(field.getName());
        }
        return value;
    }

    public void moveFirst() throws JRException {
        if (this.records != null) {
            this.iterator = this.records.iterator();
        }
    }
}

