/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;
import org.apache.commons.beanutils.PropertyUtils;

public class JRBeanCollectionDataSource
extends JRAbstractBeanDataSource {
    private Collection data = null;
    private Iterator iterator = null;
    private Object currentBean = null;

    public JRBeanCollectionDataSource(Collection beanCollection) {
        this(beanCollection, true);
    }

    public JRBeanCollectionDataSource(Collection beanCollection, boolean isUseFieldDescription) {
        super(isUseFieldDescription);
        this.data = beanCollection;
        if (this.data != null) {
            this.iterator = this.data.iterator();
        }
    }

    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentBean = this.iterator.next();
        }
        return hasNext;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (this.currentBean != null) {
            String propertyName = this.propertyNameProvider.getPropertyName(field);
            try {
                value = PropertyUtils.getProperty((Object)this.currentBean, (String)propertyName);
            }
            catch (IllegalAccessException e) {
                throw new JRException("Error retrieving field value from bean : " + propertyName, e);
            }
            catch (InvocationTargetException e) {
                throw new JRException("Error retrieving field value from bean : " + propertyName, e);
            }
            catch (NoSuchMethodException e) {
                throw new JRException("Error retrieving field value from bean : " + propertyName, e);
            }
        }
        return value;
    }

    public void moveFirst() throws JRException {
        if (this.data != null) {
            this.iterator = this.data.iterator();
        }
    }
}

