/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import org.codehaus.groovy.runtime.InvokerHelper;

public class Proxy
extends GroovyObjectSupport {
    private boolean tryRealFirst;
    private Object realObject;
    private MetaClass realMeta;
    private MetaClass first;
    private MetaClass second;

    public Proxy(Object real) {
        this(real, true);
    }

    public Proxy(Object real, boolean tryRealFirst) {
        this.tryRealFirst = tryRealFirst;
        this.realObject = real;
        this.setMetaClass(InvokerHelper.getMetaClass(real));
    }

    public Object getProperty(String property) {
        try {
            return this.first.getProperty(this, property);
        }
        catch (MissingPropertyException e) {
            return this.second.getProperty(this.realObject, property);
        }
    }

    public void setProperty(String property, Object newValue) {
        try {
            this.first.setProperty(this, property, newValue);
        }
        catch (MissingPropertyException e) {
            this.second.setProperty(this.realObject, property, newValue);
        }
    }

    public MetaClass getMetaClass() {
        return this.realMeta;
    }

    public MetaClass getProxyMetaClass() {
        return super.getMetaClass();
    }

    public Object getRealObject() {
        return this.realObject;
    }

    public Object invokeMethod(String name, Object args) {
        try {
            return this.first.invokeMethod((Object)this, name, args);
        }
        catch (MissingMethodException e) {
            return this.second.invokeMethod((Object)this, name, args);
        }
    }

    public void setMetaClass(MetaClass metaClass) {
        this.realMeta = metaClass;
        if (this.tryRealFirst) {
            this.first = this.realMeta;
            this.second = this.getMetaClass();
        } else {
            this.first = this.getMetaClass();
            this.second = this.realMeta;
        }
    }

    public void setProxyMetaClass(MetaClass metaClass) {
        super.setMetaClass(metaClass);
        if (this.tryRealFirst) {
            this.first = this.realMeta;
            this.second = this.getMetaClass();
        } else {
            this.first = this.getMetaClass();
            this.second = this.realMeta;
        }
    }
}

