/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class TinyPopupMenuBorder
extends AbstractBorder
implements UIResource {
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyBorder(g, w, h);
                break;
            }
            case 1: {
                this.drawWinBorder(g, w, h);
                break;
            }
            case 2: {
                this.drawXpBorder(g, w, h);
            }
        }
    }

    private void drawTinyBorder(Graphics g, int w, int h) {
    }

    private void drawWinBorder(Graphics g, int w, int h) {
        g.setColor(Color.WHITE);
        g.drawLine(1, 1, w - 2, 1);
        g.drawLine(1, 1, 1, h - 2);
        g.setColor(Theme.menuBorderColor[Theme.style].getColor());
        g.drawLine(w - 2, 2, w - 2, h - 2);
        g.drawLine(2, h - 2, w - 2, h - 2);
        g.setColor(Theme.menuBarColor[Theme.style].getColor());
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 0, 0, h - 1);
        g.setColor(ColorRoutines.darken(Theme.menuBorderColor[Theme.style].getColor(), 50));
        g.drawLine(w - 1, 0, w - 1, h - 1);
        g.drawLine(0, h - 1, w - 1, h - 1);
    }

    private void drawXpBorder(Graphics g, int w, int h) {
        g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
        g.drawLine(1, 1, w - 2, 1);
        g.drawLine(1, 1, 1, h - 2);
        g.setColor(MetalLookAndFeel.getDesktopColor());
        g.drawLine(w - 2, 2, w - 2, h - 2);
        g.drawLine(2, h - 2, w - 2, h - 2);
        g.setColor(Theme.menuBorderColor[Theme.style].getColor());
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 0, 0, h - 1);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawLine(w - 1, 0, w - 1, h - 1);
        g.drawLine(0, h - 1, w - 1, h - 1);
    }

    public Insets getBorderInsets(Component c) {
        return Theme.menuBorderInsets[Theme.style];
    }
}

