/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyScrollBarUI;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.plaf.basic.BasicArrowButton;

public class TinyScrollButton
extends BasicArrowButton {
    private int orientation;
    private boolean isRollover;
    private TinyScrollBarUI scrollbarUI;
    protected static Dimension[] size = new Dimension[3];

    static {
        TinyScrollButton.size[0] = new Dimension(15, 15);
        TinyScrollButton.size[1] = new Dimension(16, 16);
        TinyScrollButton.size[2] = new Dimension(17, 17);
    }

    public TinyScrollButton(int orientation, TinyScrollBarUI scrollbarUI) {
        super(orientation);
        this.orientation = orientation;
        this.scrollbarUI = scrollbarUI;
        this.setBorder(null);
        this.setRolloverEnabled(true);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setSize(size[Theme.derivedStyle[Theme.style]]);
    }

    public void paint(Graphics g) {
        this.isRollover = false;
        Color c = null;
        if (!this.scrollbarUI.isThumbVisible()) {
            c = Theme.scrollButtDisabledColor[Theme.style].getColor();
        } else if (this.getModel().isPressed()) {
            c = Theme.scrollButtPressedColor[Theme.style].getColor();
        } else if (this.getModel().isRollover() && Theme.scrollRollover[Theme.style]) {
            c = Theme.scrollButtRolloverColor[Theme.style].getColor();
            this.isRollover = true;
        } else {
            c = Theme.scrollButtColor[Theme.style].getColor();
        }
        g.setColor(c);
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyButton(g, this.getSize());
                break;
            }
            case 1: {
                this.drawWinButton(g, this.getSize());
                break;
            }
            case 2: {
                this.drawXpButton(g, this.getSize(), c);
            }
        }
        if (!this.scrollbarUI.isThumbVisible()) {
            g.setColor(Theme.scrollArrowDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.scrollArrowColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyArrow(g, this.getSize());
                break;
            }
            case 1: {
                this.drawWinArrow(g, this.getSize());
                break;
            }
            case 2: {
                this.drawXpArrow(g, this.getSize());
            }
        }
    }

    private void drawTinyButton(Graphics g, Dimension size) {
    }

    private void drawWinButton(Graphics g, Dimension size) {
        g.fillRect(1, 1, size.width - 2, size.height - 2);
        g.drawLine(0, 0, size.width - 1, 0);
        g.drawLine(0, 0, 0, size.height - 1);
        if (this.getModel().isPressed() && this.scrollbarUI.isThumbVisible()) {
            g.setColor(Theme.scrollBorderColor[Theme.style].getColor());
            g.drawRect(0, 0, size.width - 1, size.height - 1);
        } else {
            g.setColor(Theme.scrollLightColor[Theme.style].getColor());
            g.drawLine(1, 1, size.width - 3, 1);
            g.drawLine(1, 1, 1, size.height - 3);
            g.setColor(Theme.scrollDarkColor[Theme.style].getColor());
            g.drawLine(size.width - 2, 1, size.width - 2, size.height - 3);
            g.drawLine(1, size.height - 2, size.width - 2, size.height - 2);
            g.setColor(Theme.scrollBorderColor[Theme.style].getColor());
            g.drawLine(size.width - 1, 0, size.width - 1, size.height - 2);
            g.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
        }
    }

    private void drawXpButton(Graphics g, Dimension size, Color c) {
        int spread1 = Theme.scrollSpreadLight[Theme.style];
        int spread2 = Theme.scrollSpreadDark[Theme.style];
        if (!this.scrollbarUI.isThumbVisible()) {
            spread1 = Theme.scrollSpreadLightDisabled[Theme.style];
            spread2 = Theme.scrollSpreadDarkDisabled[Theme.style];
        }
        switch (this.orientation) {
            case 1: 
            case 5: {
                int h = 17;
                float spreadStep1 = 10.0f * (float)spread1 / 11.0f;
                float spreadStep2 = 10.0f * (float)spread2 / 11.0f;
                int halfY = 6;
                int y = 1;
                while (y < h - 1) {
                    int yd;
                    if (y < halfY) {
                        yd = halfY - y;
                        g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        g.setColor(c);
                    } else {
                        yd = y - halfY;
                        g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    g.drawLine(3, y, 14, y);
                    ++y;
                }
                g.setColor(Theme.scrollTrackBorderColor[Theme.style].getColor());
                g.drawLine(0, 0, 0, 16);
                g.drawLine(1, 16, 1, 16);
                g.drawLine(16, 16, 16, 16);
                if (!this.scrollbarUI.isThumbVisible()) {
                    g.setColor(Theme.scrollLightDisabledColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.scrollLightColor[Theme.style].getColor());
                }
                g.drawLine(2, 2, 2, 14);
                g.drawLine(15, 2, 15, 14);
                if (!this.scrollbarUI.isThumbVisible()) {
                    g.setColor(Theme.scrollDarkDisabledColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.scrollDarkColor[Theme.style].getColor());
                }
                g.drawLine(1, 1, 1, 15);
                g.drawLine(2, 16, 15, 16);
                g.drawLine(16, 1, 16, 15);
                g.drawLine(2, 0, 2, 0);
                g.drawLine(15, 0, 15, 0);
                if (!this.scrollbarUI.isThumbVisible()) {
                    g.setColor(Theme.scrollBorderDisabledColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.scrollBorderColor[Theme.style].getColor());
                }
                g.drawLine(3, 0, 14, 0);
                g.setColor(c);
                g.drawLine(2, 15, 15, 15);
                g.drawLine(1, 0, 1, 0);
                g.drawLine(16, 0, 16, 0);
                g.drawLine(2, 1, 2, 1);
                g.drawLine(15, 1, 15, 1);
                break;
            }
            case 3: 
            case 7: {
                float spreadStep1 = 10.0f * (float)spread1 / 10.0f;
                float spreadStep2 = 10.0f * (float)spread2 / 10.0f;
                int halfY = 6;
                int y = 1;
                while (y < 14) {
                    int yd;
                    if (y < halfY) {
                        yd = halfY - y;
                        g.setColor(ColorRoutines.lighten(c, (int)((float)yd * spreadStep1)));
                    } else if (y == halfY) {
                        g.setColor(c);
                    } else {
                        yd = y - halfY;
                        g.setColor(ColorRoutines.darken(c, (int)((float)yd * spreadStep2)));
                    }
                    g.drawLine(2, y + 1, 14, y + 1);
                    ++y;
                }
                g.setColor(Theme.scrollTrackBorderColor[Theme.style].getColor());
                g.drawLine(0, 0, 16, 0);
                g.drawLine(0, 1, 0, 1);
                g.drawLine(16, 1, 16, 1);
                if (!this.scrollbarUI.isThumbVisible()) {
                    g.setColor(Theme.scrollLightDisabledColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.scrollLightColor[Theme.style].getColor());
                }
                g.drawLine(1, 3, 1, 14);
                g.drawLine(15, 3, 15, 14);
                if (!this.scrollbarUI.isThumbVisible()) {
                    g.setColor(Theme.scrollDarkDisabledColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.scrollDarkColor[Theme.style].getColor());
                }
                g.drawLine(0, 2, 0, 15);
                g.drawLine(1, 16, 15, 16);
                g.drawLine(16, 2, 16, 15);
                g.drawLine(1, 1, 1, 1);
                g.drawLine(15, 1, 15, 1);
                if (!this.scrollbarUI.isThumbVisible()) {
                    g.setColor(Theme.scrollBorderDisabledColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.scrollBorderColor[Theme.style].getColor());
                }
                g.drawLine(2, 1, 14, 1);
                g.setColor(c);
                g.drawLine(1, 15, 15, 15);
                g.drawLine(0, 16, 0, 16);
                g.drawLine(16, 16, 16, 16);
                g.drawLine(1, 2, 1, 2);
                g.drawLine(15, 2, 15, 2);
            }
        }
    }

    private void drawTinyArrow(Graphics g, Dimension size) {
    }

    private void drawWinArrow(Graphics g, Dimension size) {
        int x = 4;
        if (this.getModel().isPressed() && this.scrollbarUI.isThumbVisible()) {
            x = 5;
        }
        switch (this.orientation) {
            case 1: {
                g.drawLine(x + 3, x + 2, x + 3, x + 2);
                g.drawLine(x + 2, x + 3, x + 4, x + 3);
                g.drawLine(x + 1, x + 4, x + 5, x + 4);
                g.drawLine(x, x + 5, x + 6, x + 5);
                if (this.scrollbarUI.isThumbVisible()) break;
                g.setColor(Color.WHITE);
                g.drawLine(x + 1, x + 6, x + 7, x + 6);
                break;
            }
            case 5: {
                g.drawLine(x, x + 2, x + 6, x + 2);
                g.drawLine(x + 1, x + 3, x + 5, x + 3);
                g.drawLine(x + 2, x + 4, x + 4, x + 4);
                g.drawLine(x + 3, x + 5, x + 3, x + 5);
                if (this.scrollbarUI.isThumbVisible()) break;
                g.setColor(Color.WHITE);
                g.drawLine(x + 4, x + 6, x + 4, x + 6);
                g.drawLine(x + 4, x + 5, x + 5, x + 5);
                g.drawLine(x + 5, x + 4, x + 6, x + 4);
                g.drawLine(x + 6, x + 3, x + 7, x + 3);
                break;
            }
            case 3: {
                g.drawLine(x + 5, x + 3, x + 5, x + 3);
                g.drawLine(x + 4, x + 2, x + 4, x + 4);
                g.drawLine(x + 3, x + 1, x + 3, x + 5);
                g.drawLine(x + 2, x, x + 2, x + 6);
                if (this.scrollbarUI.isThumbVisible()) break;
                g.setColor(Color.WHITE);
                g.drawLine(x + 3, x + 7, x + 3, x + 7);
                g.drawLine(x + 3, x + 6, x + 4, x + 6);
                g.drawLine(x + 4, x + 5, x + 5, x + 5);
                g.drawLine(x + 5, x + 4, x + 6, x + 4);
                break;
            }
            case 7: {
                g.drawLine(x + 1, x + 3, x + 1, x + 3);
                g.drawLine(x + 2, x + 2, x + 2, x + 4);
                g.drawLine(x + 3, x + 1, x + 3, x + 5);
                g.drawLine(x + 4, x, x + 4, x + 6);
                if (this.scrollbarUI.isThumbVisible()) break;
                g.setColor(Color.WHITE);
                g.drawLine(x + 5, x + 1, x + 5, x + 7);
            }
        }
    }

    private void drawXpArrow(Graphics g, Dimension size) {
        switch (this.orientation) {
            case 1: {
                g.drawLine(8, 5, 8, 5);
                g.drawLine(7, 6, 9, 6);
                g.drawLine(6, 7, 10, 7);
                g.drawLine(5, 8, 7, 8);
                g.drawLine(9, 8, 11, 8);
                g.drawLine(4, 9, 6, 9);
                g.drawLine(10, 9, 12, 9);
                g.drawLine(5, 10, 5, 10);
                g.drawLine(11, 10, 11, 10);
                break;
            }
            case 5: {
                g.drawLine(5, 6, 5, 6);
                g.drawLine(11, 6, 11, 6);
                g.drawLine(4, 7, 6, 7);
                g.drawLine(10, 7, 12, 7);
                g.drawLine(5, 8, 7, 8);
                g.drawLine(9, 8, 11, 8);
                g.drawLine(6, 9, 10, 9);
                g.drawLine(7, 10, 9, 10);
                g.drawLine(8, 11, 8, 11);
                break;
            }
            case 3: {
                g.drawLine(6, 5, 6, 5);
                g.drawLine(6, 11, 6, 11);
                g.drawLine(7, 4, 7, 6);
                g.drawLine(7, 10, 7, 12);
                g.drawLine(8, 5, 8, 7);
                g.drawLine(8, 9, 8, 11);
                g.drawLine(9, 6, 9, 10);
                g.drawLine(10, 7, 10, 9);
                g.drawLine(11, 8, 11, 8);
                break;
            }
            case 7: {
                g.drawLine(4, 8, 4, 8);
                g.drawLine(5, 7, 5, 9);
                g.drawLine(6, 6, 6, 10);
                g.drawLine(7, 5, 7, 7);
                g.drawLine(7, 9, 7, 11);
                g.drawLine(8, 4, 8, 6);
                g.drawLine(8, 10, 8, 12);
                g.drawLine(9, 5, 9, 5);
                g.drawLine(9, 11, 9, 11);
            }
        }
    }

    public Dimension getPreferredSize() {
        return size[Theme.derivedStyle[Theme.style]];
    }
}

