/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRDesignFont;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.xml.sax.SAXException;

public class JRDesignViewer
extends JPanel {
    private static final int TYPE_FILE_NAME = 1;
    private static final int TYPE_INPUT_STREAM = 2;
    private static final int TYPE_JASPER_DESIGN = 3;
    private static final int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250};
    private int type = 1;
    private boolean isXML = false;
    private String reportFileName = null;
    private JRReport report = null;
    private float zoom = 1.0f;
    private int offsetY = 0;
    private int upColumns = 0;
    private int downColumns = 0;
    private int downX = 0;
    private int downY = 0;
    private JScrollBar hBar = null;
    private JScrollBar vBar = null;
    private JRFont defaultFont = null;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected TextRenderer simluationTextRenderer = new TextRenderer(){

        public void draw(TextLayout layout) {
        }
    };
    protected TextRenderer textRenderer = new TextRenderer();
    private static final double THIN_CORNER_OFFSET = 0.25;
    private static final Stroke STROKE_THIN = new BasicStroke(0.5f);
    private static final Stroke STROKE_1_POINT = new BasicStroke(1.0f);
    private static final Stroke STROKE_2_POINT = new BasicStroke(2.0f);
    private static final Stroke STROKE_4_POINT = new BasicStroke(4.0f);
    private static final Stroke STROKE_DOTTED = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
    protected JPanel tlbToolBar;
    private JPanel pnlInScroll;
    private JPanel jPanel4;
    private JPanel pnlPage;
    private JLabel jLabel1;
    private JScrollPane scrollPane;
    private JPanel pnlMain;
    private JPanel pnlSep02;
    private JButton btnReload;
    private JPanel jPanel5;
    private JButton btnZoomOut;
    private JLabel lblPage;
    private JPanel jPanel8;
    private JButton btnZoomIn;
    private JPanel jPanel7;
    private JPanel pnlSep01;
    private JPanel jPanel6;
    private JComboBox cmbZoom;
    private JPanel jPanel9;

    public JRDesignViewer(String fileName, boolean isXML) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.initComponents();
        this.hBar = this.scrollPane.getHorizontalScrollBar();
        this.vBar = this.scrollPane.getVerticalScrollBar();
        this.loadReport(fileName, isXML);
        this.cmbZoom.setSelectedIndex(2);
    }

    public JRDesignViewer(InputStream is, boolean isXML) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.initComponents();
        this.hBar = this.scrollPane.getHorizontalScrollBar();
        this.vBar = this.scrollPane.getVerticalScrollBar();
        this.loadReport(is, isXML);
        this.cmbZoom.setSelectedIndex(2);
    }

    public JRDesignViewer(JRReport report) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.initComponents();
        this.hBar = this.scrollPane.getHorizontalScrollBar();
        this.vBar = this.scrollPane.getVerticalScrollBar();
        this.loadReport(report);
        this.cmbZoom.setSelectedIndex(2);
    }

    private void initComponents() {
        this.tlbToolBar = new JPanel();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.pnlSep02 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < zooms.length; ++i) {
            model.addElement("" + zooms[i] + "%");
        }
        this.cmbZoom.setModel(model);
        this.pnlMain = new JPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.lblPage = new JLabel();
        this.setLayout(new BorderLayout());
        this.tlbToolBar.setLayout(new FlowLayout(0, 0, 2));
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/reload.GIF")));
        this.btnReload.setText("Reload");
        this.btnReload.setToolTipText("Reload Document");
        this.btnReload.setMargin(new Insets(2, 2, 2, 2));
        this.btnReload.setMaximumSize(new Dimension(80, 23));
        this.btnReload.setMinimumSize(new Dimension(80, 23));
        this.btnReload.setPreferredSize(new Dimension(80, 23));
        this.btnReload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnReloadActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep01);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep02);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomin.GIF")));
        this.btnZoomIn.setToolTipText("Zoom In");
        this.btnZoomIn.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnZoomInActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomout.GIF")));
        this.btnZoomOut.setToolTipText("Zoom Out");
        this.btnZoomOut.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnZoomOutActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnZoomOut);
        this.cmbZoom.setToolTipText("Zoom Ratio");
        this.cmbZoom.setMaximumSize(new Dimension(80, 23));
        this.cmbZoom.setMinimumSize(new Dimension(80, 23));
        this.cmbZoom.setPreferredSize(new Dimension(80, 23));
        this.cmbZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.cmbZoomActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.cmbZoom);
        this.add((Component)this.tlbToolBar, "North");
        this.pnlMain.setLayout(new BorderLayout());
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setLayout(new BorderLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        this.lblPage.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                JRDesignViewer.this.lblPageMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                JRDesignViewer.this.lblPageMouseReleased(evt);
            }
        });
        this.lblPage.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                JRDesignViewer.this.lblPageMouseDragged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, gridBagConstraints);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, gridBagConstraints);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.pnlMain.add((Component)this.scrollPane, "Center");
        this.add((Component)this.pnlMain, "Center");
    }

    private void btnReloadActionPerformed(ActionEvent evt) {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
                this.refreshDesign();
            }
            catch (JRException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error loading report design. See console for details.");
            }
        }
    }

    private void btnZoomInActionPerformed(ActionEvent evt) {
        int index = this.cmbZoom.getSelectedIndex();
        if (index < this.cmbZoom.getModel().getSize() - 1) {
            this.cmbZoom.setSelectedIndex(index + 1);
        }
    }

    private void btnZoomOutActionPerformed(ActionEvent evt) {
        int index = this.cmbZoom.getSelectedIndex();
        if (index > 0) {
            this.cmbZoom.setSelectedIndex(index - 1);
        }
    }

    private void lblPageMousePressed(MouseEvent evt) {
        this.lblPage.setCursor(new Cursor(13));
        this.downX = evt.getX();
        this.downY = evt.getY();
    }

    private void lblPageMouseReleased(MouseEvent evt) {
        this.lblPage.setCursor(new Cursor(0));
    }

    private void lblPageMouseDragged(MouseEvent evt) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            JViewport viewport = (JViewport)container;
            Point point = viewport.getViewPosition();
            int newX = point.x - (evt.getX() - this.downX);
            int newY = point.y - (evt.getY() - this.downY);
            int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
            int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
            if (newX < 0) {
                newX = 0;
            }
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY < 0) {
                newY = 0;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            viewport.setViewPosition(new Point(newX, newY));
        }
    }

    private void cmbZoomActionPerformed(ActionEvent evt) {
        int index = this.cmbZoom.getSelectedIndex();
        this.zoom = (float)zooms[index] / 100.0f;
        this.btnZoomIn.setEnabled(index < this.cmbZoom.getModel().getSize() - 1);
        this.btnZoomOut.setEnabled(index > 0);
        this.refreshDesign();
    }

    private void verifyDesign(JasperDesign jasperDesign) throws JRException {
        Collection brokenRules = JasperCompileManager.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Report definition not valid : ");
            int i = 1;
            Iterator it = brokenRules.iterator();
            while (it.hasNext()) {
                sbuffer.append("\n\t " + i + ". " + (String)it.next());
                ++i;
            }
            throw new JRException(sbuffer.toString());
        }
    }

    private void loadReport(String fileName, boolean isXML) throws JRException {
        if (isXML) {
            JasperDesign jasperDesign = JRXmlLoader.load(fileName);
            this.verifyDesign(jasperDesign);
            this.report = jasperDesign;
        } else {
            this.report = (JRReport)JRLoader.loadObject(fileName);
        }
        this.type = 1;
        this.isXML = isXML;
        this.reportFileName = fileName;
        this.setOffsetY();
        this.btnReload.setEnabled(true);
    }

    private void loadReport(InputStream is, boolean isXML) throws JRException {
        if (isXML) {
            JasperDesign jasperDesign = JRXmlLoader.load(is);
            this.verifyDesign(jasperDesign);
            this.report = jasperDesign;
        } else {
            this.report = (JRReport)JRLoader.loadObject(is);
        }
        this.type = 2;
        this.isXML = isXML;
        this.setOffsetY();
        this.btnReload.setEnabled(false);
    }

    private void loadReport(JRReport report) throws JRException {
        this.report = report;
        this.type = 3;
        this.isXML = false;
        this.setOffsetY();
        this.btnReload.setEnabled(false);
    }

    public void setOffsetY() {
        int i;
        this.offsetY = this.report.getTopMargin();
        this.offsetY += this.report.getTitle() != null ? this.report.getTitle().getHeight() : 0;
        this.offsetY += this.report.getPageHeader() != null ? this.report.getPageHeader().getHeight() : 0;
        this.upColumns = this.offsetY;
        this.offsetY += this.report.getColumnHeader() != null ? this.report.getColumnHeader().getHeight() : 0;
        JRGroup group = null;
        JRGroup[] groups = this.report.getGroups();
        if (groups != null && groups.length > 0) {
            for (i = 0; i < groups.length; ++i) {
                group = groups[i];
                this.offsetY += group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0;
            }
        }
        this.offsetY += this.report.getDetail() != null ? this.report.getDetail().getHeight() : 0;
        if (groups != null && groups.length > 0) {
            for (i = groups.length - 1; i >= 0; --i) {
                group = groups[i];
                this.offsetY += group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0;
            }
        }
        this.offsetY += this.report.getColumnFooter() != null ? this.report.getColumnFooter().getHeight() : 0;
        this.downColumns = this.offsetY;
        this.offsetY += this.report.getPageFooter() != null ? this.report.getPageFooter().getHeight() : 0;
        this.offsetY += this.report.getLastPageFooter() != null ? this.report.getLastPageFooter().getHeight() : 0;
        this.offsetY += this.report.getSummary() != null ? this.report.getSummary().getHeight() : 0;
        this.offsetY += this.report.getBottomMargin();
    }

    private void refreshDesign() {
        Image image = null;
        ImageIcon imageIcon = null;
        Dimension dim = new Dimension((int)((float)this.report.getPageWidth() * this.zoom) + 8, (int)((float)this.offsetY * this.zoom) + 8);
        this.pnlPage.setMaximumSize(dim);
        this.pnlPage.setMinimumSize(dim);
        this.pnlPage.setPreferredSize(dim);
        try {
            image = this.printDesignToImage();
            imageIcon = new ImageIcon(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lblPage.setIcon(imageIcon);
    }

    private Image printDesignToImage() {
        BufferedImage designImage = new BufferedImage((int)((float)this.report.getPageWidth() * this.zoom) + 1, (int)((float)this.offsetY * this.zoom) + 1, 1);
        Graphics2D grx = (Graphics2D)((Image)designImage).getGraphics();
        grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        AffineTransform atrans = new AffineTransform();
        atrans.scale(this.zoom, this.zoom);
        grx.transform(atrans);
        this.printDesign(grx);
        grx.dispose();
        return designImage;
    }

    private void printDesign(Graphics2D grx) {
        int i;
        BasicStroke dashedStroke = new BasicStroke(1.0f / this.zoom, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
        Color dashedColor = new Color(170, 170, 255);
        grx.setColor(Color.white);
        grx.fillRect(0, 0, this.report.getPageWidth() + 1, this.offsetY + 1);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(this.report.getLeftMargin(), 0, this.report.getLeftMargin(), this.offsetY + 1);
        grx.drawLine(this.report.getPageWidth() - this.report.getRightMargin(), 0, this.report.getPageWidth() - this.report.getRightMargin(), this.offsetY + 1);
        grx.drawLine(this.report.getLeftMargin() + this.report.getColumnWidth(), this.upColumns, this.report.getLeftMargin() + this.report.getColumnWidth(), this.downColumns);
        grx.drawLine(this.report.getLeftMargin() + this.report.getColumnWidth() + this.report.getColumnSpacing(), this.upColumns, this.report.getLeftMargin() + this.report.getColumnWidth() + this.report.getColumnSpacing(), this.downColumns);
        grx.translate(this.report.getLeftMargin(), this.report.getTopMargin());
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getTitle(), grx);
        grx.translate(0, this.report.getTitle() != null ? this.report.getTitle().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getPageHeader(), grx);
        grx.translate(0, this.report.getPageHeader() != null ? this.report.getPageHeader().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getColumnHeader(), grx);
        grx.translate(0, this.report.getColumnHeader() != null ? this.report.getColumnHeader().getHeight() : 0);
        JRGroup group = null;
        JRGroup[] groups = this.report.getGroups();
        if (groups != null && groups.length > 0) {
            for (i = 0; i < groups.length; ++i) {
                group = groups[i];
                grx.setStroke(dashedStroke);
                grx.setColor(dashedColor);
                grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
                grx.setColor(Color.black);
                grx.setStroke(new BasicStroke(1.0f));
                this.printBand(group.getGroupHeader(), grx);
                grx.translate(0, group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0);
            }
        }
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getDetail(), grx);
        grx.translate(0, this.report.getDetail() != null ? this.report.getDetail().getHeight() : 0);
        if (groups != null && groups.length > 0) {
            for (i = groups.length - 1; i >= 0; --i) {
                group = groups[i];
                grx.setStroke(dashedStroke);
                grx.setColor(dashedColor);
                grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
                grx.setColor(Color.black);
                grx.setStroke(new BasicStroke(1.0f));
                this.printBand(group.getGroupFooter(), grx);
                grx.translate(0, group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0);
            }
        }
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getColumnFooter(), grx);
        grx.translate(0, this.report.getColumnFooter() != null ? this.report.getColumnFooter().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getPageFooter(), grx);
        grx.translate(0, this.report.getPageFooter() != null ? this.report.getPageFooter().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getLastPageFooter(), grx);
        grx.translate(0, this.report.getLastPageFooter() != null ? this.report.getLastPageFooter().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getSummary(), grx);
        grx.translate(0, this.report.getSummary() != null ? this.report.getSummary().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
    }

    private void printBand(JRBand band, Graphics2D grx) {
        if (band != null) {
            JRElement element = null;
            JRElement[] elements = band.getElements();
            if (elements != null && elements.length > 0) {
                for (int i = 0; i < elements.length; ++i) {
                    element = elements[i];
                    if (element instanceof JRLine) {
                        this.printLine((JRLine)element, grx);
                        continue;
                    }
                    if (element instanceof JRRectangle) {
                        this.printRectangle((JRRectangle)element, grx);
                        continue;
                    }
                    if (element instanceof JREllipse) {
                        this.printEllipse((JREllipse)element, grx);
                        continue;
                    }
                    if (element instanceof JRImage) {
                        this.printImage((JRImage)element, grx);
                        continue;
                    }
                    if (element instanceof JRStaticText) {
                        this.printText((JRTextElement)element, grx);
                        continue;
                    }
                    if (element instanceof JRTextField) {
                        this.printText((JRTextElement)element, grx);
                        continue;
                    }
                    if (!(element instanceof JRSubreport)) continue;
                    this.printSubreport((JRSubreport)element, grx);
                }
            }
        }
    }

    private void printLine(JRLine line, Graphics2D grx) {
        grx.setColor(line.getForecolor());
        Stroke stroke = JRDesignViewer.getStroke(line.getPen());
        if (stroke != null) {
            grx.setStroke(stroke);
            if (line.getDirection() == 1) {
                grx.drawLine(line.getX(), line.getY(), line.getX() + line.getWidth() - 1, line.getY() + line.getHeight() - 1);
            } else {
                grx.drawLine(line.getX(), line.getY() + line.getHeight() - 1, line.getX() + line.getWidth() - 1, line.getY());
            }
        }
    }

    private void printRectangle(JRRectangle rectangle, Graphics2D grx) {
        if (rectangle.getMode() == 1) {
            grx.setColor(rectangle.getBackcolor());
            grx.fillRoundRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
        }
        grx.setColor(rectangle.getForecolor());
        Stroke stroke = JRDesignViewer.getStroke(rectangle.getPen());
        if (stroke != null) {
            grx.setStroke(stroke);
            grx.drawRoundRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth() - 1, rectangle.getHeight() - 1, 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
        }
    }

    private void printEllipse(JREllipse ellipse, Graphics2D grx) {
        if (ellipse.getMode() == 1) {
            grx.setColor(ellipse.getBackcolor());
            grx.fillOval(ellipse.getX(), ellipse.getY(), ellipse.getWidth(), ellipse.getHeight());
        }
        grx.setColor(ellipse.getForecolor());
        Stroke stroke = JRDesignViewer.getStroke(ellipse.getPen());
        if (stroke != null) {
            grx.setStroke(stroke);
            grx.drawOval(ellipse.getX(), ellipse.getY(), ellipse.getWidth() - 1, ellipse.getHeight() - 1);
        }
    }

    private void printImage(JRImage jrImage, Graphics2D grx) {
        int availableImageWidth;
        if (jrImage.getMode() == 1) {
            grx.setColor(jrImage.getBackcolor());
            grx.fillRect(jrImage.getX(), jrImage.getY(), jrImage.getWidth(), jrImage.getHeight());
        }
        int topPadding = 0;
        int leftPadding = 0;
        int bottomPadding = 0;
        int rightPadding = 0;
        if (jrImage.getBox() != null) {
            topPadding = jrImage.getBox().getTopPadding();
            leftPadding = jrImage.getBox().getLeftPadding();
            bottomPadding = jrImage.getBox().getBottomPadding();
            rightPadding = jrImage.getBox().getRightPadding();
        }
        availableImageWidth = (availableImageWidth = jrImage.getWidth() - leftPadding - rightPadding) < 0 ? 0 : availableImageWidth;
        int availableImageHeight = jrImage.getHeight() - topPadding - bottomPadding;
        int n = availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        if (availableImageWidth > 0 && availableImageHeight > 0) {
            String location;
            JRExpressionChunk firstChunk;
            Image awtImage = null;
            JRExpression jrExpression = jrImage.getExpression();
            if (jrExpression != null && jrExpression.getChunks().length == 1 && (firstChunk = jrExpression.getChunks()[0]).getType() == 1 && (location = firstChunk.getText().trim()).startsWith("\"") && location.endsWith("\"")) {
                location = location.substring(1, location.length() - 1);
                try {
                    awtImage = JRImageLoader.loadImage(JRImageLoader.loadImageDataFromLocation(location));
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
            if (awtImage != null) {
                int awtWidth = awtImage.getWidth(null);
                int awtHeight = awtImage.getHeight(null);
                float xalignFactor = 0.0f;
                switch (jrImage.getHorizontalAlignment()) {
                    case 3: {
                        xalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        xalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        xalignFactor = 0.0f;
                    }
                }
                float yalignFactor = 0.0f;
                switch (jrImage.getVerticalAlignment()) {
                    case 3: {
                        yalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        yalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        yalignFactor = 0.0f;
                    }
                }
                switch (jrImage.getScaleImage()) {
                    case 1: {
                        int xoffset = (int)(xalignFactor * (float)(availableImageWidth - awtWidth));
                        int yoffset = (int)(yalignFactor * (float)(availableImageHeight - awtHeight));
                        grx.setClip(jrImage.getX() + leftPadding, jrImage.getY() + topPadding, availableImageWidth, availableImageHeight);
                        grx.drawImage(awtImage, jrImage.getX() + leftPadding + xoffset, jrImage.getY() + topPadding + yoffset, awtWidth, awtHeight, this);
                        grx.setClip(-this.report.getLeftMargin(), 0, this.report.getPageWidth(), this.report.getPageHeight());
                        break;
                    }
                    case 2: {
                        grx.drawImage(awtImage, jrImage.getX() + leftPadding, jrImage.getY() + topPadding, availableImageWidth, availableImageHeight, this);
                        break;
                    }
                    default: {
                        if (jrImage.getHeight() > 0) {
                            double ratio = (double)awtWidth / (double)awtHeight;
                            if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                                awtWidth = availableImageWidth;
                                awtHeight = (int)((double)availableImageWidth / ratio);
                            } else {
                                awtWidth = (int)((double)availableImageHeight * ratio);
                                awtHeight = availableImageHeight;
                            }
                            int xoffset = (int)(xalignFactor * (float)(availableImageWidth - awtWidth));
                            int yoffset = (int)(yalignFactor * (float)(availableImageHeight - awtHeight));
                            grx.drawImage(awtImage, jrImage.getX() + leftPadding + xoffset, jrImage.getY() + topPadding + yoffset, awtWidth, awtHeight, this);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                try {
                    awtImage = JRImageLoader.getImage((byte)1);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                grx.setClip(jrImage.getX() + leftPadding, jrImage.getY() + topPadding, availableImageWidth, availableImageHeight);
                grx.drawImage(awtImage, jrImage.getX() + leftPadding + 2, jrImage.getY() + topPadding + 2, awtImage.getWidth(null), awtImage.getHeight(null), this);
                grx.setClip(-this.report.getLeftMargin(), 0, this.report.getPageWidth(), this.report.getPageHeight());
            }
        }
        if (jrImage.getBox() == null) {
            Stroke stroke = JRDesignViewer.getStroke(jrImage.getPen());
            if (stroke != null) {
                grx.setColor(jrImage.getForecolor());
                grx.setStroke(stroke);
                grx.drawRect(jrImage.getX(), jrImage.getY(), jrImage.getWidth() - 1, jrImage.getHeight() - 1);
            }
        } else {
            this.printBox(jrImage.getBox(), jrImage, grx);
        }
    }

    private JRStyledText getStyledText(JRTextElement textElement) {
        JRStyledText styledText = null;
        String text = null;
        if (textElement instanceof JRStaticText) {
            text = ((JRStaticText)textElement).getText();
        } else if (textElement instanceof JRTextField && ((JRTextField)textElement).getExpression() != null) {
            text = ((JRTextField)textElement).getExpression().getText();
        }
        if (text != null && text.length() > 0) {
            JRFont font = textElement.getFont();
            if (font == null) {
                font = this.getDefaultFont();
            }
            HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
            attributes.putAll(font.getAttributes());
            attributes.put(TextAttribute.FOREGROUND, textElement.getForecolor());
            if (textElement.getMode() == 1) {
                attributes.put(TextAttribute.BACKGROUND, textElement.getBackcolor());
            }
            if (textElement instanceof JRStaticText && textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(attributes, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
            }
        }
        return styledText;
    }

    private void printText(JRTextElement text, Graphics2D grx) {
        JRStyledText styledText = this.getStyledText(text);
        if (styledText == null) {
            return;
        }
        String allText = styledText.getText();
        int x = text.getX();
        int y = text.getY();
        int width = text.getWidth();
        int height = text.getHeight();
        int topPadding = 0;
        int leftPadding = 0;
        int bottomPadding = 0;
        int rightPadding = 0;
        if (text.getBox() != null) {
            topPadding = text.getBox().getTopPadding();
            leftPadding = text.getBox().getLeftPadding();
            bottomPadding = text.getBox().getBottomPadding();
            rightPadding = text.getBox().getRightPadding();
        }
        double angle = 0.0;
        switch (text.getRotation()) {
            case 1: {
                y = text.getY() + text.getHeight();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = leftPadding;
                leftPadding = bottomPadding;
                bottomPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = -1.5707963267948966;
                break;
            }
            case 2: {
                x = text.getX() + text.getWidth();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = rightPadding;
                rightPadding = bottomPadding;
                bottomPadding = leftPadding;
                leftPadding = tmpPadding;
                angle = 1.5707963267948966;
                break;
            }
        }
        grx.rotate(angle, x, y);
        if (text.getMode() == 1) {
            grx.setColor(text.getBackcolor());
            grx.fillRect(x, y, width, height);
        }
        grx.setColor(text.getForecolor());
        this.simluationTextRenderer.render(grx, x, y, width, height, topPadding, leftPadding, bottomPadding, rightPadding, 0.0f, text.getTextAlignment(), text.getVerticalAlignment(), text.getLineSpacing(), styledText, allText);
        this.textRenderer.render(grx, x, y, width, height, topPadding, leftPadding, bottomPadding, rightPadding, this.simluationTextRenderer.getTextHeight(), text.getTextAlignment(), text.getVerticalAlignment(), text.getLineSpacing(), styledText, allText);
        grx.rotate(-angle, x, y);
        this.printBox(text.getBox(), text, grx);
    }

    private void printBox(JRBox box, JRElement element, Graphics2D grx) {
        Stroke topStroke = null;
        Stroke leftStroke = null;
        Stroke bottomStroke = null;
        Stroke rightStroke = null;
        if (box != null) {
            topStroke = JRDesignViewer.getStroke(box.getTopBorder());
            leftStroke = JRDesignViewer.getStroke(box.getLeftBorder());
            bottomStroke = JRDesignViewer.getStroke(box.getBottomBorder());
            rightStroke = JRDesignViewer.getStroke(box.getRightBorder());
        }
        if (topStroke != null) {
            grx.setStroke(topStroke);
            grx.setColor(box.getTopBorderColor() == null ? element.getForecolor() : box.getTopBorderColor());
            if (topStroke == STROKE_THIN) {
                grx.translate(-0.25, -0.25);
                grx.drawLine(element.getX(), element.getY(), element.getX() + element.getWidth(), element.getY());
                grx.translate(0.25, 0.25);
            } else {
                grx.drawLine(element.getX(), element.getY(), element.getX() + element.getWidth() - 1, element.getY());
            }
        }
        if (leftStroke != null) {
            grx.setStroke(leftStroke);
            grx.setColor(box.getLeftBorderColor() == null ? element.getForecolor() : box.getLeftBorderColor());
            if (leftStroke == STROKE_THIN) {
                grx.translate(-0.25, -0.25);
                grx.drawLine(element.getX(), element.getY(), element.getX(), element.getY() + element.getHeight());
                grx.translate(0.25, 0.25);
            } else {
                grx.drawLine(element.getX(), element.getY(), element.getX(), element.getY() + element.getHeight() - 1);
            }
        }
        if (bottomStroke != null) {
            grx.setStroke(bottomStroke);
            grx.setColor(box.getBottomBorderColor() == null ? element.getForecolor() : box.getBottomBorderColor());
            if (bottomStroke == STROKE_THIN) {
                grx.translate(-0.25, 0.25);
                grx.drawLine(element.getX(), element.getY() + element.getHeight() - 1, element.getX() + element.getWidth(), element.getY() + element.getHeight() - 1);
                grx.translate(0.25, -0.25);
            } else {
                grx.drawLine(element.getX(), element.getY() + element.getHeight() - 1, element.getX() + element.getWidth() - 1, element.getY() + element.getHeight() - 1);
            }
        }
        if (rightStroke != null) {
            grx.setStroke(rightStroke);
            grx.setColor(box.getRightBorderColor() == null ? element.getForecolor() : box.getRightBorderColor());
            if (rightStroke == STROKE_THIN) {
                grx.translate(0.25, -0.25);
                grx.drawLine(element.getX() + element.getWidth() - 1, element.getY(), element.getX() + element.getWidth() - 1, element.getY() + element.getHeight());
                grx.translate(-0.25, 0.25);
            } else {
                grx.drawLine(element.getX() + element.getWidth() - 1, element.getY(), element.getX() + element.getWidth() - 1, element.getY() + element.getHeight() - 1);
            }
        }
        if (topStroke == null && leftStroke == null && bottomStroke == null && rightStroke == null) {
            grx.setColor(element.getForecolor());
            grx.setStroke(new BasicStroke(1.0f / this.zoom));
            grx.drawRect(element.getX(), element.getY(), element.getWidth() - 1, element.getHeight() - 1);
        }
    }

    private void printSubreport(JRSubreport subreport, Graphics2D grx) {
        if (subreport.getMode() == 1) {
            grx.setColor(subreport.getBackcolor());
            grx.fillRect(subreport.getX(), subreport.getY(), subreport.getWidth(), subreport.getHeight());
        }
        Image image = null;
        try {
            image = JRImageLoader.getImage((byte)2);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        grx.setClip(subreport.getX(), subreport.getY(), subreport.getWidth(), subreport.getHeight());
        grx.drawImage(image, subreport.getX() + 2, subreport.getY() + 2, image.getWidth(null), image.getHeight(null), this);
        grx.setClip(-this.report.getLeftMargin(), 0, this.report.getPageWidth(), this.report.getPageHeight());
        grx.setColor(subreport.getForecolor());
        grx.setStroke(new BasicStroke(1.0f / this.zoom));
        grx.drawRect(subreport.getX(), subreport.getY(), subreport.getWidth() - 1, subreport.getHeight() - 1);
    }

    private JRFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.report.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRDesignFont();
            }
        }
        return this.defaultFont;
    }

    private static Stroke getStroke(byte pen) {
        switch (pen) {
            case 4: {
                return STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return STROKE_THIN;
            }
        }
        return STROKE_1_POINT;
    }
}

