/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JasperCompileManager {
    public static String compileReportToFile(String sourceFileName) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperDesign jasperDesign = JRXmlLoader.load(sourceFileName);
        File destFile = new File(sourceFile.getParent(), jasperDesign.getName() + ".jasper");
        String destFileName = destFile.toString();
        JasperCompileManager.compileReportToFile(jasperDesign, destFileName);
        return destFileName;
    }

    public static void compileReportToFile(String sourceFileName, String destFileName) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(sourceFileName);
        JasperCompileManager.compileReportToFile(jasperDesign, destFileName);
    }

    public static void compileReportToFile(JasperDesign jasperDesign, String destFileName) throws JRException {
        JasperReport jasperReport = new JRDefaultCompiler().compileReport(jasperDesign);
        JRSaver.saveObject((Object)jasperReport, destFileName);
    }

    public static JasperReport compileReport(String sourceFileName) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(sourceFileName);
        return JasperCompileManager.compileReport(jasperDesign);
    }

    public static void compileReportToStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(inputStream);
        JasperCompileManager.compileReportToStream(jasperDesign, outputStream);
    }

    public static void compileReportToStream(JasperDesign jasperDesign, OutputStream outputStream) throws JRException {
        JasperReport jasperReport = new JRDefaultCompiler().compileReport(jasperDesign);
        JRSaver.saveObject((Object)jasperReport, outputStream);
    }

    public static JasperReport compileReport(InputStream inputStream) throws JRException {
        JasperDesign jasperDesign = JRXmlLoader.load(inputStream);
        return JasperCompileManager.compileReport(jasperDesign);
    }

    public static JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        return new JRDefaultCompiler().compileReport(jasperDesign);
    }

    public static Collection verifyDesign(JasperDesign jasperDesign) throws JRException {
        return JRVerifier.verifyDesign(jasperDesign);
    }

    public static String writeReportToXmlFile(String sourceFileName) throws JRException {
        File sourceFile = new File(sourceFileName);
        JRReport report = (JRReport)JRLoader.loadObject(sourceFile);
        File destFile = new File(sourceFile.getParent(), report.getName() + ".jasper.jrxml");
        String destFileName = destFile.toString();
        JasperCompileManager.writeReportToXmlFile(report, destFileName);
        return destFileName;
    }

    public static void writeReportToXmlFile(String sourceFileName, String destFileName) throws JRException {
        JRReport report = (JRReport)JRLoader.loadObject(sourceFileName);
        JasperCompileManager.writeReportToXmlFile(report, destFileName);
    }

    public static void writeReportToXmlFile(JRReport report, String destFileName) throws JRException {
        JRXmlWriter.writeReport(report, destFileName, "UTF-8");
    }

    public static void writeReportToXmlStream(InputStream inputStream, OutputStream outputStream) throws JRException {
        JRReport report = (JRReport)JRLoader.loadObject(inputStream);
        JasperCompileManager.writeReportToXmlStream(report, outputStream);
    }

    public static void writeReportToXmlStream(JRReport report, OutputStream outputStream) throws JRException {
        JRXmlWriter.writeReport(report, outputStream, "UTF-8");
    }

    public static String writeReportToXml(JRReport report) throws JRException {
        return JRXmlWriter.writeReport(report, "UTF-8");
    }
}

