/*
 * CompatibilityDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 2 giugno 2003, 22.30
 */

package it.businesslogic.ireport.gui;
import it.businesslogic.ireport.util.*;
/**
 *
 * @author  Administrator
 */
public class CompatibilityDialog extends javax.swing.JDialog {
    
    MainFrame mf = null;


    public CompatibilityDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        this.mf = (MainFrame)parent;
        initComponents();
        this.setSize(330, 253);
	load();
        Misc.centerFrame(this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
        private void initComponents() {//GEN-BEGIN:initComponents
                jPanel1 = new javax.swing.JPanel();
                jPanel8 = new javax.swing.JPanel();
                jCheckBoxAutosave1 = new javax.swing.JCheckBox();
                jCheckBoxAutosave2 = new javax.swing.JCheckBox();
                jCheckBoxAutosave3 = new javax.swing.JCheckBox();
                jPanel9 = new javax.swing.JPanel();
                jCheckBoxAutosave4 = new javax.swing.JCheckBox();
                jCheckBoxAutosave5 = new javax.swing.JCheckBox();
                jCheckBoxAutosave6 = new javax.swing.JCheckBox();
                jPanel2 = new javax.swing.JPanel();
                jButton2 = new javax.swing.JButton();
                jButton1 = new javax.swing.JButton();

                setTitle("Compatibility options");
                setResizable(false);
                addWindowListener(new java.awt.event.WindowAdapter() {
                        public void windowClosing(java.awt.event.WindowEvent evt) {
                                closeDialog(evt);
                        }
                });

                jPanel1.setLayout(new java.awt.GridLayout(2, 1));

                jPanel8.setLayout(new java.awt.GridLayout(3, 1));

                jPanel8.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "JasperReports 0.4.5", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
                jPanel8.setFont(new java.awt.Font("Dialog", 0, 11));
                jCheckBoxAutosave1.setFont(new java.awt.Font("Dialog", 0, 11));
                jCheckBoxAutosave1.setText("Save text vertical alignement");
                jCheckBoxAutosave1.setSelected(true);
                jPanel8.add(jCheckBoxAutosave1);

                jCheckBoxAutosave2.setFont(new java.awt.Font("Dialog", 0, 11));
                jCheckBoxAutosave2.setText("Save rounded rectangle");
                jCheckBoxAutosave2.setSelected(true);
                jPanel8.add(jCheckBoxAutosave2);

                jCheckBoxAutosave3.setFont(new java.awt.Font("Dialog", 0, 11));
                jCheckBoxAutosave3.setText("Save ellipse");
                jCheckBoxAutosave3.setSelected(true);
                jPanel8.add(jCheckBoxAutosave3);

                jPanel1.add(jPanel8);

                jPanel9.setLayout(new java.awt.GridLayout(3, 1));

                jPanel9.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "JasperReports 0.4.6", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
                jPanel9.setFont(new java.awt.Font("Dialog", 0, 11));
                jCheckBoxAutosave4.setFont(new java.awt.Font("Dialog", 0, 11));
                jCheckBoxAutosave4.setText("Save image vertical alignement");
                jCheckBoxAutosave4.setSelected(true);
                jPanel9.add(jCheckBoxAutosave4);

                jCheckBoxAutosave5.setFont(new java.awt.Font("Dialog", 0, 11));
                jCheckBoxAutosave5.setText("Save image horizontal alignement");
                jCheckBoxAutosave5.setSelected(true);
                jPanel9.add(jCheckBoxAutosave5);

                jCheckBoxAutosave6.setFont(new java.awt.Font("Dialog", 0, 11));
                jCheckBoxAutosave6.setText("Save background band");
                jCheckBoxAutosave6.setSelected(true);
                jPanel9.add(jCheckBoxAutosave6);

                jPanel1.add(jPanel9);

                getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

                jPanel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

                jButton2.setFont(new java.awt.Font("Dialog", 0, 11));
                jButton2.setText("Ok");
                jButton2.setMnemonic('o');
                jPanel2.add(jButton2);

                jButton1.setFont(new java.awt.Font("Dialog", 0, 11));
                jButton1.setText("Cancel");
                jButton1.setMnemonic('c');
                jPanel2.add(jButton1);

                getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

                pack();
        }//GEN-END:initComponents

    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        // Add your handling code here:
    }//GEN-LAST:event_closeDialog
    
    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt){
	close();
    }
    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt){
	save();
	close();
    }
    private void load(){
       if (mf == null || mf.getProperties() == null)
       {
          return;
       }
       java.util.Properties prop = mf.getProperties();
       try
       {
	  String ca1 = prop.getProperty("CompatibilityAutosave1");
	  String ca2 = prop.getProperty("CompatibilityAutosave2");
	  String ca3 = prop.getProperty("CompatibilityAutosave3");
	  String ca4 = prop.getProperty("CompatibilityAutosave4");
	  String ca5 = prop.getProperty("CompatibilityAutosave5");
	  String ca6 = prop.getProperty("CompatibilityAutosave6");
	  if(ca1 != null)
             jCheckBoxAutosave1.setSelected( (ca1.equals("1")?true:false));
	  if(ca2 != null)
             jCheckBoxAutosave2.setSelected( (ca2.equals("1")?true:false));
	  if(ca3 != null)
             jCheckBoxAutosave3.setSelected( (ca3.equals("1")?true:false));
	  if(ca4 != null)
             jCheckBoxAutosave4.setSelected( (ca4.equals("1")?true:false));
	  if(ca5 != null)
             jCheckBoxAutosave5.setSelected( (ca5.equals("1")?true:false));
	  if(ca6 != null)
             jCheckBoxAutosave6.setSelected( (ca6.equals("1")?true:false));
       } catch (Exception ex)
       { ex.printStackTrace(); }
    }
    private void save(){
       if (mf == null || mf.getProperties() == null)
       {
          return;
       }
       java.util.Properties prop = mf.getProperties();
       try
       {
          prop.put("CompatibilityAutosave1", ""+(jCheckBoxAutosave1.isSelected()?1:0));
          prop.put("CompatibilityAutosave2", ""+(jCheckBoxAutosave2.isSelected()?1:0));
          prop.put("CompatibilityAutosave3", ""+(jCheckBoxAutosave3.isSelected()?1:0));
          prop.put("CompatibilityAutosave4", ""+(jCheckBoxAutosave4.isSelected()?1:0));
          prop.put("CompatibilityAutosave5", ""+(jCheckBoxAutosave5.isSelected()?1:0));
          prop.put("CompatibilityAutosave6", ""+(jCheckBoxAutosave6.isSelected()?1:0));          
       } catch (Exception ex)
       { ex.printStackTrace(); }
    }
    private void close(){
        setVisible(false);
        dispose();	
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new CompatibilityDialog(new javax.swing.JFrame(), true).show();
    }
    
    
        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JButton jButton1;
        private javax.swing.JButton jButton2;
        private javax.swing.JCheckBox jCheckBoxAutosave1;
        private javax.swing.JCheckBox jCheckBoxAutosave2;
        private javax.swing.JCheckBox jCheckBoxAutosave3;
        private javax.swing.JCheckBox jCheckBoxAutosave4;
        private javax.swing.JCheckBox jCheckBoxAutosave5;
        private javax.swing.JCheckBox jCheckBoxAutosave6;
        private javax.swing.JPanel jPanel1;
        private javax.swing.JPanel jPanel2;
        private javax.swing.JPanel jPanel8;
        private javax.swing.JPanel jPanel9;
        // End of variables declaration//GEN-END:variables
    
}
