/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.jdbc2.optional;

import com.mysql.jdbc.Driver;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class MysqlDataSource
implements DataSource,
Referenceable,
Serializable {
    protected static Driver mysqlDriver = null;
    protected boolean explicitUrl = false;
    protected String url = null;
    protected String hostName = null;
    protected int port = 3306;
    protected String databaseName = null;
    protected String encoding = null;
    protected String user = null;
    protected String password = null;
    protected PrintWriter logWriter = null;
    protected String profileSql = "false";

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String userID, String password) throws SQLException {
        Properties props = new Properties();
        if (userID == null) {
            userID = "";
        }
        if (password == null) {
            password = "";
        }
        props.put("user", userID);
        props.put("password", password);
        props.put("profileSql", this.getProfileSql());
        return this.getConnection(props);
    }

    protected Connection getConnection(Properties props) throws SQLException {
        String jdbcUrlToUse = null;
        if (!this.explicitUrl) {
            StringBuffer jdbcUrl = new StringBuffer("jdbc:mysql://");
            if (this.hostName != null) {
                jdbcUrl.append(this.hostName);
            }
            jdbcUrl.append(":");
            jdbcUrl.append(this.port);
            jdbcUrl.append("/");
            if (this.databaseName != null) {
                jdbcUrl.append(this.databaseName);
            }
            jdbcUrlToUse = jdbcUrl.toString();
        } else {
            jdbcUrlToUse = this.url;
        }
        return mysqlDriver.connect(jdbcUrlToUse, props);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public int getLoginTimeout() {
        return 0;
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public int getPort() {
        return this.port;
    }

    public String getProfileSql() {
        return this.profileSql;
    }

    public void setProfileSql(String flag) {
        this.profileSql = flag;
    }

    public Reference getReference() throws NamingException {
        String factoryName = "com.mysql.jdbc.jdbc2.optional.MysqlDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), factoryName, null);
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("serverName", this.getServerName()));
        ref.add(new StringRefAddr("port", "" + this.getPort()));
        ref.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        ref.add(new StringRefAddr("profileSql", this.getProfileSql()));
        return ref;
    }

    public String getServerName() {
        return this.hostName;
    }

    public void setUrl(String url) {
        this.url = url;
        this.explicitUrl = true;
    }

    public String getUrl() {
        if (!this.explicitUrl) {
            String builtUrl = "jdbc:mysql://";
            builtUrl = builtUrl + this.getServerName() + ":" + this.getPort() + "/" + this.getDatabaseName();
            return builtUrl;
        }
        return this.url;
    }

    public void setURL(String url) {
        this.setUrl(url);
    }

    public String getURL() {
        return this.getUrl();
    }

    public String getUser() {
        return this.user;
    }

    public void setDatabaseName(String dbName) {
        this.databaseName = dbName;
    }

    public void setLogWriter(PrintWriter output) throws SQLException {
        this.logWriter = output;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setPortNumber(int p) {
        this.setPort(p);
    }

    public void setServerName(String serverName) {
        this.hostName = serverName;
    }

    public void setUser(String userID) {
        this.user = userID;
    }

    static {
        try {
            mysqlDriver = (Driver)Class.forName("com.mysql.jdbc.Driver").newInstance();
        }
        catch (Exception E) {
            throw new RuntimeException("Can not load Driver class com.mysql.jdbc.Driver");
        }
    }
}

