/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Hashtable;
import org.hsqldb.ByteArray;
import org.hsqldb.HsqlName;
import org.hsqldb.Library;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlDateTime;

class Column {
    static final int VARCHAR_IGNORECASE = 100;
    private static Hashtable hTypes;
    static final int[] numericTypes;
    static final int[] otherTypes;
    static final int[][] typesArray;
    HsqlName columnName;
    private int colType;
    private int colSize;
    private int colScale;
    private boolean isNullable;
    private boolean isIdentity;
    private boolean isPrimaryKey;
    private String defaultString;
    private static final BigDecimal BIGDECIMAL_0;
    private static Collator i18nCollator;
    private static boolean sql_compare_in_locale;

    Column(HsqlName hsqlName, boolean bl, int n, int n2, int n3, boolean bl2, boolean bl3, String string) {
        this.columnName = hsqlName;
        this.isNullable = bl;
        this.colType = n;
        this.colSize = n2;
        this.colScale = n3;
        this.isIdentity = bl2;
        this.isPrimaryKey = bl3;
        this.defaultString = string;
    }

    boolean isIdentity() {
        return this.isIdentity;
    }

    boolean isNullable() {
        return this.isNullable;
    }

    void setNullable(boolean bl) {
        this.isNullable = bl;
    }

    boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean bl) {
        this.isPrimaryKey = bl;
    }

    String getDefaultString() {
        return this.defaultString;
    }

    int getType() {
        return this.colType;
    }

    int getSize() {
        return this.colSize;
    }

    int getScale() {
        return this.colScale;
    }

    static int getTypeNr(String string) throws SQLException {
        Integer n = (Integer)hTypes.get(string);
        Trace.check(n != null, 16, string);
        return n;
    }

    static String getTypeString(int n) throws SQLException {
        switch (n) {
            case 0: {
                return "NULL";
            }
            case 4: {
                return "INTEGER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 3: {
                return "DECIMAL";
            }
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case -5: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMERIC";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 1111: {
                return "OBJECT";
            }
        }
        throw Trace.error(16, n);
    }

    static Object add(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return new Double(d + d2);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return (String)object + (String)object2;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.add(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return new Integer(n2 + n3);
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return new Long(l + l2);
            }
        }
        throw Trace.error(20, n);
    }

    static Object concat(Object object, Object object2) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        return Column.convertObject(object) + Column.convertObject(object2);
    }

    static Object negate(Object object, int n) throws SQLException {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(-((Number)object).doubleValue());
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).negate();
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(-((Number)object).intValue());
            }
            case -5: {
                return new Long(-((Number)object).longValue());
            }
        }
        throw Trace.error(20, n);
    }

    static Object multiply(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return new Double(d * d2);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.multiply(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return new Integer(n2 * n3);
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return new Long(l * l2);
            }
        }
        throw Trace.error(20, n);
    }

    static Object divide(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return new Double(d / d2);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                int n2 = bigDecimal.scale() > bigDecimal2.scale() ? bigDecimal.scale() : bigDecimal2.scale();
                return bigDecimal2.signum() == 0 ? null : bigDecimal.divide(bigDecimal2, n2, 5);
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = ((Number)object).intValue();
                int n4 = ((Number)object2).intValue();
                Trace.check(n4 != 0, 6);
                return new Integer(n3 / n4);
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return l2 == 0L ? null : new Long(l / l2);
            }
        }
        throw Trace.error(20, n);
    }

    static Object subtract(Object object, Object object2, int n) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return new Double(d - d2);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.subtract(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n2 = ((Number)object).intValue();
                int n3 = ((Number)object2).intValue();
                return new Integer(n2 - n3);
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return new Long(l - l2);
            }
        }
        throw Trace.error(20, n);
    }

    static Object sum(Object object, Object object2, int n) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(((Number)object).doubleValue() + ((Number)object2).doubleValue());
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).add((BigDecimal)object2);
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(((Number)object).intValue() + ((Number)object2).intValue());
            }
            case -5: {
                return new Long(((Number)object).longValue() + ((Number)object2).longValue());
            }
        }
        throw Trace.error(15);
    }

    static Object avg(Object object, int n, int n2) throws SQLException {
        if (object == null || n2 == 0) {
            return null;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double((Double)object / (double)n2);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).divide(new BigDecimal((double)n2), 5);
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(((Number)object).intValue() / n2);
            }
            case -5: {
                return new Long((Long)object / (long)n2);
            }
        }
        throw Trace.error(15);
    }

    static Object min(Object object, Object object2, int n) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        if (Column.compare(object, object2, n) < 0) {
            return object;
        }
        return object2;
    }

    static Object max(Object object, Object object2, int n) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        if (Column.compare(object, object2, n) > 0) {
            return object;
        }
        return object2;
    }

    static void setCompareInLocal(boolean bl) {
        sql_compare_in_locale = bl;
    }

    static int compare(Object object, Object object2, int n) throws SQLException {
        int n2 = 0;
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case -1: 
            case 12: {
                if (sql_compare_in_locale) {
                    n2 = i18nCollator.compare((String)object, (String)object2);
                    break;
                }
                n2 = ((String)object).compareTo((String)object2);
                break;
            }
            case 1: {
                if (sql_compare_in_locale) {
                    n2 = i18nCollator.compare(Library.rtrim((String)object), Library.rtrim((String)object2));
                    break;
                }
                n2 = Library.rtrim((String)object).compareTo(Library.rtrim((String)object2));
                break;
            }
            case 100: {
                if (sql_compare_in_locale) {
                    n2 = i18nCollator.compare(((String)object).toUpperCase(), ((String)object2).toUpperCase());
                    break;
                }
                n2 = ((String)object).toUpperCase().compareTo(((String)object2).toUpperCase());
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = ((Number)object).intValue();
                int n4 = ((Number)object2).intValue();
                return n3 > n4 ? 1 : (n4 > n3 ? -1 : 0);
            }
            case -5: {
                long l = ((Number)object).longValue();
                long l2 = ((Number)object2).longValue();
                return l > l2 ? 1 : (l2 > l ? -1 : 0);
            }
            case 6: 
            case 7: 
            case 8: {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return d > d2 ? 1 : (d2 > d ? -1 : 0);
            }
            case 2: 
            case 3: {
                n2 = ((BigDecimal)object).compareTo((BigDecimal)object2);
                break;
            }
            case 91: {
                if (((Date)object).after((Date)object2)) {
                    return 1;
                }
                if (((Date)object).before((Date)object2)) {
                    return -1;
                }
                return 0;
            }
            case 92: {
                if (((Time)object).after((Time)object2)) {
                    return 1;
                }
                if (((Time)object).before((Time)object2)) {
                    return -1;
                }
                return 0;
            }
            case 93: {
                if (((Timestamp)object).after((Timestamp)object2)) {
                    return 1;
                }
                if (((Timestamp)object).before((Timestamp)object2)) {
                    return -1;
                }
                return 0;
            }
            case -7: {
                boolean bl = (Boolean)object;
                boolean bl2 = (Boolean)object2;
                return bl == bl2 ? 0 : (bl2 ? -1 : 1);
            }
            case -4: 
            case -3: 
            case -2: {
                n2 = ByteArray.compareTo((byte[])object, (byte[])object2);
                break;
            }
            case 1111: {
                return 0;
            }
            default: {
                throw Trace.error(20, n);
            }
        }
        return n2 > 0 ? 1 : (n2 < 0 ? -1 : 0);
    }

    private static String convertObject(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    static Object convertObject(Object object, int n) throws SQLException {
        try {
            if (object == null) {
                return null;
            }
            switch (n) {
                case 0: {
                    return null;
                }
                case -6: {
                    if (object instanceof String) {
                        object = new Integer((String)object);
                    }
                    if (object instanceof Integer || object instanceof Long) {
                        int n2 = ((Number)object).intValue();
                        if (127 < n2 || n2 < -128) {
                            throw new NumberFormatException();
                        }
                        return object;
                    }
                    if (!(object instanceof Byte)) break;
                    return new Integer(((Number)object).intValue());
                }
                case 5: {
                    if (object instanceof String) {
                        object = new Integer((String)object);
                    }
                    if (object instanceof Integer || object instanceof Long) {
                        int n3 = ((Number)object).intValue();
                        if (Short.MAX_VALUE < n3 || n3 < Short.MIN_VALUE) {
                            throw new NumberFormatException();
                        }
                        return object;
                    }
                    if (!(object instanceof Byte) && !(object instanceof Short)) break;
                    return new Integer(((Number)object).intValue());
                }
                case 4: {
                    if (object instanceof String) {
                        return new Integer((String)object);
                    }
                    if (object instanceof Integer) {
                        return object;
                    }
                    if (!(object instanceof Long)) break;
                    long l = ((Number)object).longValue();
                    if (Integer.MAX_VALUE < l || l < Integer.MIN_VALUE) {
                        throw new NumberFormatException();
                    }
                    return new Integer(((Number)object).intValue());
                }
                case -5: {
                    if (object instanceof Long) {
                        return object;
                    }
                    if (object instanceof String) {
                        return new Long((String)object);
                    }
                    if (!(object instanceof Integer)) break;
                    return new Long(((Integer)object).longValue());
                }
                case 6: 
                case 7: 
                case 8: {
                    if (object instanceof Double) {
                        return object;
                    }
                    if (object instanceof String) {
                        return new Double((String)object);
                    }
                    if (!(object instanceof Number)) break;
                    return new Double(((Number)object).doubleValue());
                }
                case 2: 
                case 3: {
                    if (!(object instanceof BigDecimal)) break;
                    return object;
                }
                case -7: {
                    if (object instanceof Boolean) {
                        return object;
                    }
                    if (object instanceof String) {
                        return new Boolean((String)object);
                    }
                    if (object instanceof Integer || object instanceof Long) {
                        boolean bl = ((Number)object).longValue() != 0L;
                        return new Boolean(bl);
                    }
                    if (object instanceof Double) {
                        boolean bl = (Double)object != 0.0;
                        return new Boolean(bl);
                    }
                    if (!(object instanceof BigDecimal)) break;
                    boolean bl = ((BigDecimal)object).compareTo(BIGDECIMAL_0) != 0;
                    return new Boolean(bl);
                }
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    if (object instanceof String) {
                        return object;
                    }
                    if (!(object instanceof byte[])) break;
                    return ByteArray.toString((byte[])object);
                }
                case 92: {
                    if (object instanceof Timestamp) {
                        return new Time(((java.util.Date)((Timestamp)object)).getTime());
                    }
                    if (!(object instanceof Date)) break;
                    return new Time(0L);
                }
                case 91: {
                    if (!(object instanceof Timestamp)) break;
                    return new Date(((java.util.Date)((Timestamp)object)).getTime());
                }
                case -4: 
                case -3: 
                case -2: {
                    if (!(object instanceof byte[])) break;
                    return object;
                }
                case 1111: {
                    if (object instanceof String) break;
                    return object;
                }
            }
            return Column.convertString(object.toString(), n);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw Trace.error(16, exception.getMessage());
        }
    }

    private static Object convertString(String string, int n) throws SQLException {
        switch (n) {
            case -6: 
            case 5: {
                return Column.convertObject(string, n);
            }
            case 4: {
                return new Integer(string);
            }
            case -5: {
                return new Long(string);
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(string);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return string;
            }
            case 91: {
                return HsqlDateTime.dateValue(string);
            }
            case 92: {
                return HsqlDateTime.timeValue(string);
            }
            case 93: {
                return HsqlDateTime.timestampValue(string);
            }
            case 2: 
            case 3: {
                return new BigDecimal(string.trim());
            }
            case -7: {
                return new Boolean(string);
            }
            case -4: 
            case -3: 
            case -2: {
                return ByteArray.hexToByteArray(string);
            }
            case 1111: {
                return ByteArray.deserialize(ByteArray.hexToByteArray(string));
            }
        }
        throw Trace.error(20, n);
    }

    static String createSQLString(Object object, int n) throws SQLException {
        if (object == null) {
            return "NULL";
        }
        switch (n) {
            case 0: {
                return "NULL";
            }
            case 6: 
            case 7: 
            case 8: {
                return Column.createSQLString(((Number)object).doubleValue());
            }
            case 91: 
            case 92: 
            case 93: {
                return StringConverter.toQuotedString(object.toString(), '\'', false);
            }
            case -4: 
            case -3: 
            case -2: {
                return StringConverter.toQuotedString(ByteArray.toString((byte[])object), '\'', false);
            }
            case 1111: {
                return StringConverter.toQuotedString(ByteArray.serializeToString(object), '\'', false);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return Column.createSQLString((String)object);
            }
        }
        return object.toString();
    }

    static String createSQLString(double d) throws SQLException {
        if (d == Double.NEGATIVE_INFINITY) {
            return "-1E0/0";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "1E0/0";
        }
        if (Double.isNaN(d)) {
            return "0E0/0E0";
        }
        String string = Double.toString(d);
        if (string.indexOf(69) < 0) {
            string = string.concat("E0");
        }
        return string;
    }

    static String createSQLString(String string) {
        return StringConverter.toQuotedString(string, '\'', true);
    }

    static int getCombinedNumberType(int n, int n2, int n3) {
        int n4 = Column.getNumTypeWidth(n);
        int n5 = Column.getNumTypeWidth(n2);
        if (n4 == 16 || n5 == 16) {
            return 8;
        }
        if (n3 != 14) {
            if (n4 + n5 <= 4) {
                return 4;
            }
            if (n4 + n5 <= 8) {
                return -5;
            }
            if (n4 + n5 <= 16) {
                return 2;
            }
        }
        return n4 > n5 ? n : n2;
    }

    private static int getNumTypeWidth(int n) {
        switch (n) {
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 6: 
            case 7: 
            case 8: {
                return 16;
            }
            case 2: 
            case 3: {
                return 32;
            }
        }
        return 32;
    }

    static {
        numericTypes = new int[]{-6, 5, 4, -5, 2, 3, 6, 7, 8};
        otherTypes = new int[]{-7, -4, -3, -2, -1, 1, 12, 91, 92, 93, 1111};
        typesArray = new int[][]{numericTypes, otherTypes};
        BIGDECIMAL_0 = new BigDecimal("0");
        hTypes = new Hashtable(67, 1.0f);
        hTypes.put("INTEGER", new Integer(4));
        hTypes.put("INT", new Integer(4));
        hTypes.put("int", new Integer(4));
        hTypes.put("java.lang.Integer", new Integer(4));
        hTypes.put("IDENTITY", new Integer(4));
        hTypes.put("DOUBLE", new Integer(8));
        hTypes.put("double", new Integer(8));
        hTypes.put("java.lang.Double", new Integer(8));
        hTypes.put("FLOAT", new Integer(6));
        hTypes.put("REAL", new Integer(7));
        hTypes.put("VARCHAR", new Integer(12));
        hTypes.put("java.lang.String", new Integer(12));
        hTypes.put("CHAR", new Integer(1));
        hTypes.put("CHARACTER", new Integer(1));
        hTypes.put("LONGVARCHAR", new Integer(-1));
        hTypes.put("VARCHAR_IGNORECASE", new Integer(100));
        hTypes.put("DATE", new Integer(91));
        hTypes.put("java.sql.Date", new Integer(91));
        hTypes.put("TIME", new Integer(92));
        hTypes.put("java.sql.Time", new Integer(92));
        hTypes.put("TIMESTAMP", new Integer(93));
        hTypes.put("java.sql.Timestamp", new Integer(93));
        hTypes.put("DATETIME", new Integer(93));
        hTypes.put("DECIMAL", new Integer(3));
        hTypes.put("java.math.BigDecimal", new Integer(3));
        hTypes.put("NUMERIC", new Integer(2));
        hTypes.put("BIT", new Integer(-7));
        hTypes.put("boolean", new Integer(-7));
        hTypes.put("java.lang.Boolean", new Integer(-7));
        hTypes.put("TINYINT", new Integer(-6));
        hTypes.put("byte", new Integer(-6));
        hTypes.put("java.lang.Byte", new Integer(-6));
        hTypes.put("SMALLINT", new Integer(5));
        hTypes.put("short", new Integer(5));
        hTypes.put("java.lang.Short", new Integer(5));
        hTypes.put("BIGINT", new Integer(-5));
        hTypes.put("long", new Integer(-5));
        hTypes.put("java.lang.Long", new Integer(-5));
        hTypes.put("BINARY", new Integer(-2));
        hTypes.put("[B", new Integer(-2));
        hTypes.put("VARBINARY", new Integer(-3));
        hTypes.put("LONGVARBINARY", new Integer(-4));
        hTypes.put("OTHER", new Integer(1111));
        hTypes.put("OBJECT", new Integer(1111));
        hTypes.put("java.lang.Object", new Integer(1111));
        hTypes.put("NULL", new Integer(0));
        hTypes.put("void", new Integer(0));
        hTypes.put("java.lang.Void", new Integer(0));
        i18nCollator = Collator.getInstance();
        sql_compare_in_locale = false;
    }
}

